package com.aote.plugin;

import com.aote.path.PathServer;
import com.aote.sql.SqlServer;
import org.json.JSONArray;
import org.json.JSONObject;

import java.util.HashMap;
import java.util.Map;

/**
 *  获取评价记录
 */
public class GetEvaluate {

    /**
     * 返回 评价记录列表
     */
    public JSONArray getEvalueList(PathServer path, SqlServer sql, JSONObject data) throws Exception {
        JSONArray jsonEvalute = new JSONArray();
        // 存放处理过的节点
        Map<Integer, JSONObject> proced = new HashMap<>();
        JSONObject node ;
        // 获取评价记录
        JSONArray evaluates = getEvaluate(path, data.getString("f_type"), data.getString("f_middle_id"));

        // 获取评价类型记录
        JSONArray evaluateTypes = getEvaluateType(sql, data.getString("f_type"), data.getString("f_middle_id"));
        // 组合结构
        for(int i=0; i<evaluates.length(); i++) {
            node = (JSONObject) evaluates.get(i);
            node.put("open", false);
            node.put("isSelect", false);
            proced.put(node.getInt("id"), node);
            jsonEvalute.put(node);
        }
        for(int i=0; i<evaluateTypes.length();i++) {
            node = (JSONObject) evaluateTypes.get(i);
            // 根据parentid从处理过的找到父
            Integer parentid = getByParentId(proced, node);
            if(parentid != null) {
                JSONObject parent = proced.get(parentid);
                // 给父添加子
                JSONArray children = this.getChildren(parent);
                children.put(node);
            }
        }
        return jsonEvalute;
    }

    /**
     * 获取评价
     * @return
     */
    public JSONArray getEvaluate(PathServer path, String fType, String fMiddleId) throws Exception {
        String value = "{data: {f_type: '"+fType+"',f_middle_id: '"+fMiddleId+"'} }";

        JSONArray evaluates = path.query("evaluate", 0, 1000, value);
        return evaluates;
    }

    /**
     *  获取评价类型
     */
    public JSONArray getEvaluateType(SqlServer sql, String fType, String fMiddleId)throws Exception {
        String value = "{data: {f_type: '"+fType+"', f_middle_id: '"+fMiddleId+"'}}";
        JSONArray evaType = sql.query("getEvaluateType", 0, 1000, value);
        return evaType;
    }

    /**
     * 根据parentid从处理过的找到父
     * @param proced 处理过的
     * @param node
     * @return
     */
    private Integer getByParentId(Map<Integer, JSONObject> proced, JSONObject node) {
        // 判断是否是根
        String parentId = node.optString("f_evaluate_id", null);
        if(parentId == null) {
            return null;
        }
        // 从处理过的节点中找父
        for(Integer key: proced.keySet()) {
            // 判断处理过的是否是父级
            if(key == node.getInt("f_evaluate_id")) {
                return key;
            }
        }
        return null;
    }
    /***
     * 获取父节点的子集合，没有，创建一个空的
     * @param pnode
     * @return
     */
    private JSONArray getChildren(JSONObject pnode) {
        if (pnode.has("evaluate_type")) {
            return pnode.getJSONArray("evaluate_type");
        }
        JSONArray result = new JSONArray();
        pnode.put("evaluate_type", result);
        return result;
    }
}
