package com.aote.rs;

import com.aote.plugin.AccessToken;
import com.aote.rs.entity.WxConfig;
//import com.thoughtworks.xstream.XStream;
//import com.thoughtworks.xstream.io.xml.DomDriver;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntity;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.multipart.FormDataContentDisposition;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.json.JSONObject;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.context.ContextLoaderListener;

import javax.imageio.ImageIO;
import javax.inject.Singleton;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.*;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.StreamingOutput;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.*;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.util.*;

@Path("materials")
@Singleton
@Component
@Transactional
public class WeiXinService {
	static Logger log = Logger.getLogger(WeiXinService.class);

	//////the code below is for texting service added by lgy on 23/11/2017

	public static boolean hasCustomService;
	public static int THUMBNAIL_SIZE = 200;
	public static String FILE_LOCATION;
//	public static String FFMPEG_LOCATION;

	//pre-fecthing
	static {
		log.debug("start access token background thread.");
		InputStream is = null;
		try {
			is = WeiXinService.class.getClassLoader().getResourceAsStream("config.properties");
			Properties prop = new Properties();
			prop.load(is);
			AccessToken.url = prop.getProperty("aturl");
			hasCustomService = Boolean.parseBoolean(prop.getProperty("hasCustomService"));
			THUMBNAIL_SIZE = Integer.parseInt(prop.getProperty("thumbNailSize"));
			FILE_LOCATION = prop.getProperty("fileLocation");
//			FFMPEG_LOCATION = WeiXinService.class.getProtectionDomain().getCodeSource().getLocation().getPath()
//					.substring(1) + "ffmpeg/bin/ffmpeg.exe";
			if(hasCustomService)
				AccessToken.getAccessToken();
		} catch (IOException e) {
			log.debug(e.getMessage());
			e.printStackTrace();
		} finally {
			if(is != null)
				try {
					is.close();
				} catch (IOException e) {
					e.printStackTrace();
				}
		}
	}



	@POST
	@Path("upload/{type}")
	public String uploadFile(@PathParam("type") String type,
		@FormDataParam("file") InputStream uploadedInputStream,
		@FormDataParam("file") FormDataContentDisposition fileDetail) {
		try {
			String fileName = fileDetail.getFileName();
			fileName = new String (fileName.getBytes ("iso-8859-1"), "UTF-8");

			int pos = fileName.lastIndexOf('.');
			String thumbNailFileName = fileName.substring(0, pos) + "_";

			if(type.equals("voice"))
				thumbNailFileName += ".mp3";
			else if(type.equals("video"))
				thumbNailFileName += ".jpg";
			else
				thumbNailFileName += fileName.substring(pos);

			String fullFileName = FILE_LOCATION + "/" + fileName;

			writeToFile(uploadedInputStream, fullFileName);
			uploadedInputStream.close();
			String mediaId = null;
			if (hasCustomService) {
				mediaId = uploadWcMedia(fullFileName, fileName, type);

				if(mediaId == null)
					return "{\"code\":500, \"msg\":\"上传素材到微信失败！\"}";
			}
			File file = new File(fullFileName);
			if(type.equals("video")) {
				createVideoThumbNail(FILE_LOCATION + "/" + thumbNailFileName, fullFileName);
			}
//			else if(type.equals("voice")) {
//				createVoiceThumbNail(FILE_LOCATION + "/" + thumbNailFileName, fullFileName);
//			}
			else if(type.equals("image")) {
				createImageThumbNail(FILE_LOCATION + "/" + thumbNailFileName, file);
			}
			if(hasCustomService){
				return "{\"code\": 200, \"msgType\": \"" + type + "\", \"mediaId\": \"" + mediaId
						+ "\", \"fileName\": \"" + fileName + "\", \"thumbnail\": \"" + thumbNailFileName + "\"}";
			}else{
				return "{\"code\": 200, \"msgType\": \"" + type + "\", \"fileName\": \"" + fileName + "\", \"thumbnail\": \"" + thumbNailFileName + "\"}";
			}
		} catch (Exception e) {
			e.printStackTrace();
			return "{\"code\":500}";
		}
	}

	/**
	 * 删除素材id
	 * @param mediaId
	 * @return
	 */
	@POST
	@Path("del/{mediaId}")
	public String delMediaById(@PathParam("mediaId") String mediaId) {
		try {
			if(hasCustomService){
				HttpClient client = new DefaultHttpClient();
				String url = "https://api.weixin.qq.com/cgi-bin/material/del_material??access_token=" + AccessToken.getAccessToken();
				HttpPost post = new HttpPost(url);
				post.setEntity(new StringEntity("{\"mediaId\":\"" + mediaId + "\"}"));
				HttpResponse response = client.execute(post);
				if(response.getStatusLine().getStatusCode() == 200) {
					String result = EntityUtils.toString(response.getEntity());
					JSONObject js = new JSONObject(result);
					if(js.has("errcode") && js.getInt("errcode") == 0)
						return "{\"code\":200}";
					else
						return "{\"code\":500}";
				} else {
					return "{\"code\":500}";
				}
			}else{
				return "{\"code\":200}";
			}

		} catch (Exception e) {
			e.printStackTrace();
			return "{\"code\":500}";
		}
	}

	private String uploadWcMedia(String fileName, String desc, String type) throws Exception{

		HttpClient client = new DefaultHttpClient();

		String url = "://api.weixin.qq.com/cgi-bin/material/add_material?access_token=" + AccessToken.getAccessToken() + "&type=" + type;
		if(type.equals("video"))
			url = "http" + url;
		else
			url = "https" + url;

		HttpPost post = new HttpPost(url);

		MultipartEntity entity = new MultipartEntity();

		File file = new File(fileName);
		entity.addPart("media", new FileBody(file));
		if(type.equals("video")) {
			String uuid = UUID.randomUUID().toString();
			entity.addPart("description", new StringBody("{\"title\": \"" + uuid + "\", \"introduction\": \"" + uuid + "\"}"));
		}
		post.setEntity(entity);
		HttpResponse response = client.execute(post);
		if(response.getStatusLine().getStatusCode() == 200) {
			String result = EntityUtils.toString(response.getEntity());
			JSONObject js = new JSONObject(result);
			if(js.has("media_id"))
				return js.getString("media_id");
			else
				return null;
		} else
			return null;
	}

	private void writeToFile(InputStream uploadedInputStream, String uploadedFileLocation) throws Exception {
		OutputStream out = new FileOutputStream(new File(uploadedFileLocation));
		int read = 0;
		byte[] bytes = new byte[1024];
		while ((read = uploadedInputStream.read(bytes)) != -1) {
			out.write(bytes, 0, read);
		}
		out.flush();
		out.close();
	}

	/**
	 * create a thumb nail
	 * @param thumbNailFileName
	 * @param file
	 * @throws Exception
	 */
	private void createImageThumbNail(String thumbNailFileName, File file) throws Exception{
		BufferedImage originImg = ImageIO.read(file);
		int d = ((originImg.getWidth() > originImg.getHeight()) ? originImg.getWidth() : originImg.getHeight());

		double scale = (THUMBNAIL_SIZE*1.0) / d;
        int w = (int)(originImg.getWidth() * scale);
        int h = (int)(originImg.getHeight() * scale);

		BufferedImage img = new BufferedImage(w, h, BufferedImage.TYPE_INT_RGB);
		img.createGraphics().drawImage(originImg.getScaledInstance(w, h, Image.SCALE_SMOOTH),0,0,null);
		ImageIO.write(img, "jpg", new File(thumbNailFileName));
	}

	/**
	 *
	 * @param thumbNailFileName
	 * @param fileName
	 * @throws IOException
	 */
	private void createVoiceThumbNail(String thumbNailFileName, String fileName) throws Exception {
//		log.debug("FFMPEG_LOCATION-----------"+FFMPEG_LOCATION);
		String path = "cmd.exe /c ffmpeg -i " + fileName + " " + thumbNailFileName;
		Runtime rt = Runtime.getRuntime();
		Process pr = rt.exec(path);
		pr.waitFor();
	}

	/**
	 *
	 * @param thumbNailFileName
	 * @param file
	 * @throws IOException
	 */
	private void createVideoThumbNail(String thumbNailFileName, String fileName) throws Exception {
		File file = new File(thumbNailFileName);
		// 如果文件路径所对应的文件存在，并且是一个文件，则直接删除
		if (file.exists() && file.isFile()) {
			if (file.delete()) {
				log.debug("替换" + thumbNailFileName + "成功！");
			} else {
				log.debug("删除" + thumbNailFileName + "失败！");
			}
		}
		String path = "cmd.exe /c ffmpeg -i " + fileName + " -ss 00:00:00.000 -vframes 1 " + thumbNailFileName;
		System.out.println("8888888888888888888888");
		System.out.println(path);
		Runtime rt = Runtime.getRuntime();
		Process pr = rt.exec(path);
		pr.waitFor();
	}

	public static boolean deleteFile(String fileName) {
		File file = new File(fileName);
		// 如果文件路径所对应的文件存在，并且是一个文件，则直接删除
		if (file.exists() && file.isFile()) {
			if (file.delete()) {
				System.out.println("删除单个文件" + fileName + "成功！");
				return true;
			} else {
				System.out.println("删除单个文件" + fileName + "失败！");
				return false;
			}
		} else {
			System.out.println("删除单个文件失败：" + fileName + "不存在！");
			return false;
		}
	}


	/**

	 * 获取素材列表

	 * @param request

	 * @param response

	 * @return

	 * @throws Exception

	 */
	@POST
	@Path("material/{type}/{offset}/{count}")
	public String getmaterial(@PathParam("type") String type, @PathParam("offset") int offset, @PathParam("count") String count) throws Exception {
		HttpClient client = new DefaultHttpClient();
		String url = "https://api.weixin.qq.com/cgi-bin/material/batchget_material?access_token=" + AccessToken.getAccessToken();
		HttpPost post = new HttpPost(url);
		post.setEntity(new StringEntity("{\"type\":\"" + type + "\",\"offset\":" + offset + ", \"count\":" + count + "}"));
		HttpResponse res = client.execute(post);
		if(res.getStatusLine().getStatusCode() == 200) {
			String result = new String(EntityUtils.toString(res.getEntity()).getBytes("iso-8859-1"), "UTF-8");
			log.debug("获取素材返回信息" + result);
			return result;
		} else {
			return "{\"code\":500}";
		}
	}

	/**

	 * 获取图片素材

	 * @return

	 * @throws IOException

	 * @throws Exception

	 */
	@GET
	@Path("image/material/{mediaId}")
	@Produces("image/jpeg")
	public StreamingOutput  getFullImage(@PathParam("mediaId")String mediaId) throws IOException {
	    return new StreamingOutput() {

	        @Override
	        public void write(OutputStream outputStream) throws IOException {
	          InputStream is = fetchImage(mediaId);
	          int nextByte = 0;
	          while((nextByte  = is.read()) != -1 ){
	            outputStream.write(nextByte);
	          }
	          outputStream.flush();
	          outputStream.close();
	          is.close();
	        }

			private InputStream fetchImage(String mediaId) throws IOException {
				log.debug("mediaId:" + mediaId);
				String url = "https://api.weixin.qq.com/cgi-bin/material/get_material?access_token=" + AccessToken.getAccessToken();
				HttpURLConnection conn = (HttpURLConnection) new URL(url).openConnection();
				conn.setRequestMethod("POST");
				conn.setDoOutput(true);
			    conn.setDoInput(true);
			    conn.setReadTimeout(20000);
			    conn.setConnectTimeout(20000);
			    conn.setUseCaches(false);
			    conn.connect();
			    PrintWriter pw = new PrintWriter(new OutputStreamWriter(
		                conn.getOutputStream(), "UTF-8"), true);
		        pw.print("{\"media_id\":\"" + mediaId + "\"}");
			    pw.flush();
			    InputStream is = conn.getInputStream();
			    return is;
			}
	      };

	}



}
