/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.aote.path.PathMapper;
import com.aote.rs.DirConfig;
import com.aote.rs.mapper.WebException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import org.apache.log4j.Logger;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.context.ContextLoaderListener;

@Path(value="dir")
public class DirService {
    static Logger log = Logger.getLogger(DirService.class);
    public static String fileStaticPath = "";

    @GET
    public String files(@QueryParam(value="path") String path) {
        StringBuilder result = new StringBuilder();
        try {
            if ("".equals(fileStaticPath)) {
                String read;
                DirConfig dirConfig = (DirConfig)ContextLoaderListener.getCurrentWebApplicationContext().getBean("global");
                FileInputStream is = new FileInputStream(dirConfig.getGlobalPath());
                StringBuilder sb = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((read = br.readLine()) != null) {
                    sb.append(read);
                }
                br.close();
                JSONObject jsonObject = JSON.parseObject((String)sb.toString());
                fileStaticPath = jsonObject.getString("REMOTE_WWW_PREFIX");
            }
            System.out.println(fileStaticPath);
            File file = new File(fileStaticPath);
            List<File> files = this.list(file);
            for (File f : files) {
                if (!result.toString().equals("")) {
                    result.append("|");
                }
                result.append(f.getPath().replace(fileStaticPath, "")).append(",").append(f.lastModified());
            }
            log.debug((Object)result.toString());
            return result.toString();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
            return "";
        }
    }

    @POST
    @Path(value="/getfile")
    public String files2(@RequestBody String path) {
        StringBuilder result = new StringBuilder();
        if (path == null || path.trim().length() == 0) {
            throw new RuntimeException("\u6587\u4ef6\u8def\u5f84\u4e3anull");
        }
        log.debug((Object)path);
        File file = new File(path);
        List<File> files = this.list(file);
        for (File f : files) {
            if (!result.toString().equals("")) {
                result.append("|");
            }
            result.append(f.getPath()).append(",").append(f.lastModified());
        }
        log.debug((Object)result.toString());
        return result.toString();
    }

    @POST
    @Path(value="/{name}")
    public String getGlobalFileByName(@Context HttpServletResponse response, @PathParam(value="name") String name) {
        DirConfig dirConfig = (DirConfig)ContextLoaderListener.getCurrentWebApplicationContext().getBean(name);
        try {
            response.setStatus(200);
            response.setContentType("application/octet-stream");
            log.debug((Object)(name + " path:" + dirConfig.getGlobalPath()));
            FileInputStream is = new FileInputStream(dirConfig.getGlobalPath());
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            this.transformStream(is, os);
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return "";
    }

    @GET
    @Path(value="/version")
    public String getVersion(@Context HttpServletResponse response) {
        String path = PathMapper.class.getClassLoader().getResource("app.json").getPath();
        try {
            path = URLDecoder.decode(path, "utf-8");
            response.setStatus(200);
            response.setContentType("application/octet-stream");
            log.debug((Object)path);
            FileInputStream is = new FileInputStream(path);
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            this.transformStream(is, os);
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return "";
    }

    @POST
    public String getFile(@Context HttpServletResponse response, String fileName) {
        try {
            fileName = URLDecoder.decode(fileName, "utf-8");
            if ("".equals(fileStaticPath)) {
                String read;
                DirConfig dirConfig = (DirConfig)ContextLoaderListener.getCurrentWebApplicationContext().getBean("global");
                FileInputStream is = new FileInputStream(dirConfig.getGlobalPath());
                StringBuilder sb = new StringBuilder();
                BufferedReader br = new BufferedReader(new InputStreamReader(is));
                while ((read = br.readLine()) != null) {
                    sb.append(read);
                }
                br.close();
                JSONObject jsonObject = JSON.parseObject((String)sb.toString());
                fileStaticPath = jsonObject.getString("REMOTE_WWW_PREFIX");
            }
            if (!fileName.contains(fileStaticPath)) {
                throw new WebException(500, "\u6587\u4ef6\u672a\u627e\u5230");
            }
            response.setStatus(200);
            response.setContentType("application/octet-stream");
            log.debug((Object)fileName);
            FileInputStream is = new FileInputStream(fileName);
            BufferedOutputStream os = new BufferedOutputStream((OutputStream)response.getOutputStream());
            this.transformStream(is, os);
            ((InputStream)is).close();
            ((OutputStream)os).close();
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        return "";
    }

    public void transformStream(InputStream is, OutputStream os) {
        try {
            byte[] buffer = new byte[1024];
            int length = is.read(buffer);
            while (length != -1) {
                os.write(buffer, 0, length);
                length = is.read(buffer);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private List<File> list(File dir) {
        File[] files;
        ArrayList<File> result = new ArrayList<File>();
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                result.addAll(this.list(file));
                continue;
            }
            result.add(file);
        }
        return result;
    }
}

