/*
 * Decompiled with CFR 0.152.
 */
package com.aote.rs;

import com.aote.logic.LogicMapper;
import com.aote.path.PathMapper;
import com.aote.sql.SqlMapper;
import com.aote.util.ResourceHelper;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import org.apache.log4j.Logger;

@Path(value="dir2")
public class DirService2 {
    static Logger log = Logger.getLogger(DirService2.class);
    private static Map<String, String> xmls = new HashMap<String, String>();

    @GET
    public String getfiles() {
        String result = "";
        result = result + this.getLogicMap(true);
        result = result + "|" + this.getSqlMap(true);
        result = result + "|" + this.getPathMap(true);
        return result;
    }

    @GET
    @Path(value="noxml")
    public String getfilesNoXML() {
        String result = "";
        result = this.union(result, this.getLogicMap(false), "|");
        result = this.union(result, this.getSqlMap(false), "|");
        result = this.union(result, this.getPathMap(false), "|");
        return result;
    }

    private String union(String str1, String str2, String ch) {
        if (str1 == null || str1.equals("")) {
            return str2;
        }
        if (str2 == null || str2.equals("")) {
            return str1;
        }
        return str1 + ch + str2;
    }

    @POST
    public String getFile(String fileName) {
        try {
            if (fileName.endsWith(".xml")) {
                String type = fileName.substring(0, fileName.length() - 4);
                return xmls.get(type);
            }
            String path = new String();
            if (fileName.endsWith("logic")) {
                Map logicmap = LogicMapper.getMap();
                path = (String)((Map)logicmap.get(fileName.substring(fileName.lastIndexOf("/") + 1, fileName.lastIndexOf(".")))).get("path");
            } else if (fileName.endsWith("path")) {
                Map logicmap = PathMapper.getMap();
                path = (String)((Map)logicmap.get(fileName.substring(fileName.lastIndexOf("/") + 1, fileName.lastIndexOf(".")))).get("path");
            } else {
                Map logicmap = SqlMapper.getMap();
                path = (String)((Map)logicmap.get(fileName.substring(fileName.lastIndexOf("/") + 1, fileName.lastIndexOf(".")))).get("path");
            }
            return ResourceHelper.getString((String)path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    private String getLogicMap(boolean hasXml) {
        Map logicmap = LogicMapper.getMap();
        String result = this.getMap(logicmap, "logic", hasXml);
        return result;
    }

    private String getSqlMap(boolean hasXml) {
        Map logicmap = SqlMapper.getMap();
        String result = this.getMap(logicmap, "sql", hasXml);
        return result;
    }

    private String getPathMap(boolean hasXml) {
        Map logicmap = PathMapper.getMap();
        String result = this.getMap(logicmap, "path", hasXml);
        return result;
    }

    private String getMap(Map<String, Map<String, String>> logicmap, String type, boolean hasXml) {
        String result = "";
        String xml = "<cfg>";
        for (Map.Entry<String, Map<String, String>> entry : logicmap.entrySet()) {
            if (!"true".equals(entry.getValue().get("mobile"))) continue;
            if (!result.equals("")) {
                result = result + "|";
            }
            String file = entry.getKey();
            String path = entry.getValue().get("path");
            file = type.equals("logic") ? "logics/" + file + ".logic" : (type.equals("path") ? "paths/" + file + ".path" : "sqls/" + file + ".sql");
            result = result + file + "," + this.getMD5(path);
            file = file.substring(file.indexOf("/") + 1);
            xml = xml + "<" + type + " alias='" + entry.getKey() + "' path='" + file + "' />";
        }
        xml = xml + "</cfg>";
        if (!xmls.containsKey(type)) {
            xmls.put(type, xml);
        }
        if (!hasXml) {
            return result;
        }
        if (!result.equals("")) {
            result = result + "|";
        }
        result = result + "/" + type + ".xml," + this.getStringMD5(xml);
        return result;
    }

    private String getMD5(String fileName) {
        String str = null;
        try {
            str = ResourceHelper.getString((String)fileName);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage());
            e.printStackTrace();
        }
        String result = this.getStringMD5(str);
        return result;
    }

    private String getStringMD5(String str) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            String result = new BigInteger(1, md.digest()).toString(16);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("md5\u52a0\u5bc6\u5931\u8d25", e);
        }
    }
}

