select *,
       case
           when f_balance > 0
               then
               case when f_balance >= f_oughtfee_all then 0 else f_oughtfee_all - f_balance end
           else f_oughtfee_all
           end f_oughtfee_col
from (select f_userfiles_id,
             f_stairprice_id,
             f_meter_classify,
             f_userinfo_id,                                                                                     --户编号
             f_user_type,
             f_gasproperties,
             f_meter_classify                                                                   f_meter_type,
             (select f_tablebase
              from t_handplan
              where id = max(h.handplan_id))                                                    f_tablebase,
             convert(varchar (100), max(f_operate_date), 111)                                   f_operate_date, -- 缴费时间
             count(*)                                                                           c,              --欠费次数
             case
                 when CONVERT(varchar (7), min(f_hand_date), 23) = CONVERT(varchar (7), max(f_hand_date), 23)
                     then CONVERT(varchar (7), min(f_hand_date), 23)
                 else CONVERT(varchar (7), min(f_hand_date), 23) + '至' +
                      CONVERT(varchar (7), max(f_hand_date), 23) end                            f_hand_date,    --欠费区间
             sum(f_oughtamount)                                                                 f_oughtamount,  --用气量
             sum(f_oughtfee_all)                                                                f_oughtfee,     --用气金额
             sum(isnull(f_debt_money, 0))                                                       f_debt_money,   --已交金额
             convert(decimal (18, 2), sum(isnull(f_debt_money, 0)) / sum(f_oughtfee_all) * 100) f_hand_bv,      --回收率
             sum(f_oughtfee)                                                                    f_oughtfee_new, --气费金额
             sum(alloverdue)                                                                    overdue,
             sum(f_garbage_fee)                                                                 f_garbage_fee,--附加费
             (SELECT f_last_tablebase from t_handplan where id = MIN(h.handplan_id))            f_last_tablebase,
             f_balance,
             sum(f_oughtfee) + sum(alloverdue) + sum(f_garbage_fee)                             f_oughtfee_all  --合计欠费金额
      from (SELECT mhs.realyminid,
                   handplan_id,                                                       --抄表记录id
                   f_stairprice_id,
                   f_sell_id,
                   f_last_tablebase,                                                  --上期指数
                   f_tablebase,                                                       --本期指数
                   f_hand_date,                                                       --抄表日期
                   f_input_date,
                   f_userinfo_id,
                   f_user_id,
                   f_meter_classify,
                   f_user_type,
                   f_gasproperties,
                   p.f_userfiles_id,
                   f_surplus_gas,
                   f_haircut_gas,
                   f_oughtamount,                                                     --应交气量  convert(decimal(18,2),f_oughtamount)  ROUND(f_oughtamount,2)
                   f_oughtfee                                            f_oughtfee_all,
                   ROUND(f_oughtfee - f_debt_money, 2)                   f_oughtfee,  --实际应交金额 convert(decimal(18,2),f_oughtfee-f_debt_money) ROUND(f_oughtfee-f_debt_money,2)
                   f_debt_money,                                                      --已交气费 convert(decimal(18,2),f_debt_money) ROUND(f_debt_money,2)
                   f_charge_money,                                                    --已交总金额 convert(decimal(18,2),f_charge_money) ROUND(f_charge_money,2)
                   f_selloverdue,                                                     --已交滞纳金 convert(decimal(18,2),f_selloverdue) ROUND(f_selloverdue,2)
                   f_allfee,                                                          --总应交金额 convert(decimal(18,2),f_oughtfee) ROUND(f_oughtfee,2)
                   f_totalowe_gas,                                                    -- convert(decimal(18,2),f_totalowe_gas) ROUND(f_totalowe_gas,2)
                   f_totalowe_fee,                                                    -- convert(decimal(18,2),f_totalowe_fee) ROUND(f_totalowe_fee,2)
                   f_whether_pay,                                                     --是否缴费
                   f_end_date,                                                        --截止日期
                   CASE WHEN overduedays < 1 THEN 0 ELSE overduedays END overduedays, --滞纳天数
                   f_balance,                                                         --余额
                   f_last_balance,
                   f_operate_date,                                                    -- 缴费时间
                   --滞纳天数小于0，不计算滞纳金，返回0
                   convert(decimal (18, 3),
                           CASE
                               WHEN overduedays <= 0 THEN
                                   0
                               ELSE
                                   --滞纳金天数大于0，若应交金额小于0
                                   CASE
                                       WHEN overduedays * zhinajinbilv * (f_oughtfee - f_debt_money - (case
                                                                                                           when mh.minid is null
                                                                                                               then 0
                                                                                                           else (case when f_balance < 0 then 0 else f_balance end) end)) <
                                            0
                                           THEN
                                           0
                                       ELSE
                                           --判断应交金额是否小于0
                                           (CASE
                                                WHEN overduedays * zhinajinbilv * (f_oughtfee - f_debt_money - (case
                                                                                                                    when mh.minid is null
                                                                                                                        then 0
                                                                                                                    else (case when f_balance < 0 then 0 else f_balance end) end)) >=
                                                     f_oughtfee - f_debt_money - (case
                                                                                      when mh.minid is null then 0
                                                                                      else (case when f_balance < 0 then 0 else f_balance end) end)
                                                    THEN
                                                    CASE
                                                        WHEN f_oughtfee - f_debt_money - f_balance < 0
                                                            THEN 0
                                                        ELSE f_oughtfee - f_debt_money - f_balance
                                                        END
                                                ELSE
                                                        overduedays * zhinajinbilv * (f_oughtfee - f_debt_money - (case
                                                                                                                       when mh.minid is null
                                                                                                                           then 0
                                                                                                                       else (case when f_balance < 0 then 0 else f_balance end) end))
                                               END)
                                       END
                               END)                                      overdue,
                   convert(decimal (18, 2),
                           CASE
                               WHEN overduedays <= 0 THEN
                                   isnull(f_latefee_ought, 0)
                               ELSE
                                   --滞纳金天数大于0，若应交金额小于0
                                   CASE
                                       WHEN overduedays * zhinajinbilv * (f_oughtfee - f_debt_money -
                                                                          (case when mh.minid is null then 0 else f_balance end)) <=
                                            0
                                           THEN
                                           isnull(f_latefee_ought, 0)
                                       ELSE
                                           --判断应交金额是否小于0
                                           (CASE
                                                WHEN overduedays * zhinajinbilv * (f_oughtfee - f_debt_money - case
                                                                                                                   when mh.minid is null
                                                                                                                       then 0
                                                                                                                   else f_balance end) +
                                                     isnull(zhengchang, 0) >=
                                                     f_oughtfee - f_debt_money -
                                                     (case when mh.minid is null then 0 else f_balance end)
                                                    THEN
                                                    CASE
                                                        WHEN f_oughtfee - f_debt_money -
                                                             (case when mh.minid is null then 0 else f_balance end) < 0
                                                            THEN 0
                                                        ELSE
                                                            case
                                                                when f_oughtfee - f_debt_money -
                                                                     (case when mh.minid is null then 0 else f_balance end) -
                                                                     isnull(jianmian, 0) <= 0
                                                                    then 0
                                                                else f_oughtfee - f_debt_money -
                                                                     (case when mh.minid is null then 0 else f_balance end) -
                                                                     isnull(jianmian, 0)
                                                                end
                                                        END
                                                ELSE
                                                            overduedays * zhinajinbilv * (f_oughtfee - f_debt_money -
                                                                                          (case when mh.minid is null then 0 else f_balance end)) +
                                                            isnull(f_latefee_ought, 0)
                                               END)
                                       END
                               END)                                      alloverdue,
                   gh.minid,
                   0                                                     f_garbage_fee
            FROM (SELECT h.id as                                                              handplan_id,
                         h.f_sell_id,
                         h.f_last_tablebase,
                         h.f_tablebase,
                         h.f_hand_date,
                         h.f_input_date,
                         h.f_oughtamount,
                         h.f_oughtfee,
                         h.f_user_type,
                         h.f_gasproperties,
                         h.f_meter_classify,
                         isnull(f_debt_money, 0)                                              f_debt_money,
                         isnull(f_charge_money, 0)                                            f_charge_money,
                         isnull(f_selloverdue, 0)                                             f_selloverdue,
                         f_oughtfee                                                           f_allfee,
                         f_whether_pay,
                         f_loss_gas,
                         h.f_end_date,
                         h.f_user_id,
                         h.f_userfiles_id,
                         h.f_surplus_gas,
                         h.f_haircut_gas,
                         f_share_gas,
                         f_totalowe_fee,
                         f_totalowe_gas,
                         h.f_overdue,
                         h.f_userinfo_id,
                         h.f_stairprice_id,
                         case when u.f_balance < 0 then 0 else u.f_balance end                f_balance,
                         sh.f_last_balance,                                                                -- 上期余额
                         ss.f_operate_date,
                         lr.f_latefee_ought,
                         lr.zhengchang,
                         lr.jianmian,
                         DATEDIFF(dd, h.f_end_date, getdate())                                overduedays, --滞纳天数 sql server
                         CASE
                             WHEN h.f_user_type = '民用'
                                 THEN isnull((SELECT cast(value as float)
                                              FROM t_singlevalue
                                              WHERE name = '民用违约金'
                                                and f_filialeids = u.f_orgid),
                                             (SELECT cast(value as float) FROM t_singlevalue WHERE name = '民用违约金'))
                             ELSE
                                 isnull((SELECT cast(value as float)
                                         FROM t_singlevalue
                                         WHERE name = '非民用违约金'
                                           and f_filialeids = u.f_orgid),
                                        (SELECT cast(value as float) FROM t_singlevalue WHERE name = '非民用违约金'))
                             END                                                              zhinajinbilv,
                         (SELECT cast(value as int) FROM t_singlevalue WHERE name = '垃圾费') f_lajifei
                  FROM t_handplan h
                           LEFT JOIN (select f_operate_date, id from t_sellinggas) ss on ss.id = h.f_sell_id
                           LEFT JOIN (select f_balance, f_userinfo_id, f_orgid from t_userinfo) u
                                     ON h.f_userinfo_id = u.f_userinfo_id
                           LEFT JOIN (SELECT f_hand_id,
                                             SUM(f_debt_money)                                               f_debt_money,
                                             (SELECT f_last_balance from t_sellinghand where id = min(d.id)) f_last_balance,
                                             SUM(f_charge_money)                                             f_charge_money,
                                             SUM(f_overdue)                                                  f_selloverdue
                                      FROM t_sellinghand d
                                      WHERE f_state = '有效'
                                      GROUP BY f_hand_id) sh
                  on h.id = sh.f_hand_id
                      left join (select f_hand_id,
                      sum (f_latefee_ought) f_latefee_ought,
                      sum (jianmian) jianmian,
                      sum (zhengchang) zhengchang
                      from (select f_hand_id,
                      f_latefee_ought,
                      case when f_latefee_ought < 0 then 0 - f_latefee_ought else 0 end jianmian,
                      case when f_latefee_ought > 0 then f_latefee_ought else 0 end zhengchang
                      from t_latefee_record
                      where f_state = '有效') l
                      group by f_hand_id) lr on h.id = lr.f_hand_id
                  WHERE f_whether_pay = '否'
                    AND f_hand_state = '有效'
                    and h.f_meter_state = '已抄表'
                    AND f_oughtfee
                      > 0
                    and h.f_hand_date >= '{startDate}'
                    and h.f_hand_date <= '{endDate}') p
                     left join(select f_userfiles_id, CONVERT(varchar (7), f_hand_date, 23) f_date, min(id) minid
                               from t_handplan
                               where f_hand_state = '有效'
                                 and f_meter_state = '已抄表'
                                 AND f_oughtfee > 0
                               group by CONVERT(varchar (7), f_hand_date, 23), f_userfiles_id) gh
                              on CONVERT(varchar (7), p.f_hand_date, 23) = gh.f_date and
                                 p.f_userfiles_id = gh.f_userfiles_id
                     left join (select f_userfiles_id, min(id) minid
                                from t_handplan
                                where f_hand_state = '有效'
                                  and f_meter_state = '已抄表'
                                  AND f_oughtfee > 0
                                  and f_whether_pay = '否'
                                group by f_userfiles_id) mh
                               on p.handplan_id = mh.minid and p.f_userfiles_id = mh.f_userfiles_id
                     left join (select f_userfiles_id, min(id) realyminid
                                from t_handplan
                                where f_hand_state = '有效'
                                  and f_meter_state = '已抄表'
                                  and f_hand_date >= '{startDate}'
                                  and f_hand_date <= '{endDate}'
                                  AND f_oughtfee > 0
                                  and f_whether_pay = '否'
                                group by f_userfiles_id) mhs on p.f_userfiles_id = mhs.f_userfiles_id
            where {condValue}) h
      group by f_userinfo_id, h.f_userfiles_id, h.f_stairprice_id, f_user_type, f_gasproperties, realyminid,
               f_meter_classify, f_balance) s
         LEFT JOIN (select f_user_name,
                           f_userinfo_code,
                           f_user_phone,
                           f_rent_phone,
                           f_comments,
                           f_cost_type,
                           f_userinfo_id u_userinfo_id
                    from t_userinfo) u
                   ON s.f_userinfo_id = u.u_userinfo_id
         left join (select f_meter_book_num,
                           f_inputtor f_dainputtores,
                           f_depid,
                           f_depname,
                           f_orgid,
                           f_orgname,
                           f_operatorid,
                           f_userfiles_id uf_userfiles_id
                    from t_userfiles) uf on s.f_userfiles_id = uf.uf_userfiles_id
         left join (select f_price_name, id sp_id from t_stairprice) sp on s.f_stairprice_id = sp.sp_id
         left join (select f_book_name, f_inputtor, id mb_id from t_meter_book) mb on uf.f_meter_book_num = mb.mb_id
         left join (select f_residential_area, f_slice_area f_zones, f_address, f_userinfo_id add_userinfo_id from t_user_address) ua
                   on s.f_userinfo_id = ua.add_userinfo_id

where {condition}
order by f_userinfo_code
