select
        f_orgname,
		f_payment,
		f_bank_name,
    CONVERT(VARCHAR(10),f_trade_date,120) f_trade_date,
    CONVERT(DECIMAL(18,2),SUM(f_total_charge)) f_total_charge,
    CONVERT(DECIMAL(18,2),SUM(f_collection)) f_collection
from (
    SELECT
        isnull(( mid_t.f_total_charge + 0.00 ) / ( 100 + 0.00 ),0) f_total_charge,
        mid_t.id,
        CONVERT(VARCHAR(10),ISNULL(mid_t.f_trade_date, bill_t.f_operate_date),120) f_trade_date,
        mid_t.f_sell_id,
        isnull(mid_t.f_userinfo_code,bill_t.f_userinfo_code) f_userinfo_code,
        bill_t.f_serial_id,
        bill_t.f_collection,
        bill_t.f_orgname,
        --bill_t.f_operate_date,
        bill_t.f_depname,
        bill_t.f_depid,
        bill_t.f_operatorid,
		bill_t.f_payment,
		bill_t.f_bank_name
    FROM (
      SELECT
            bank.id,
            bank.f_trade_date,
            bank.f_total_charge,
            bank.f_sell_id,
            bank.f_userinfo_code,
            bank.f_whether_reciliat,
            bank.f_filialeid
        FROM t_bank_payment bank
        WHERE bank.f_trade_date >= '{startDate} 00:00:00'
        AND bank.f_trade_date <= '{endDate} 23:59:59'
    ) mid_t
    FULL OUTER JOIN (
       SELECT
            sell.f_payment,
            sell.f_operate_date,
            sell.f_collection,
            sell.f_serial_id,
            sell.f_orgid,
            sell.f_orgname,
            sell.f_depid,
            sell.f_depname,
            sell.f_operatorid,
            sell.f_operator,
            sell.f_userinfo_id,
            userinfo.f_userinfo_code,
			sell.f_bank_name,
            sell.f_user_name
        FROM t_sellinggas sell
        RIGHT JOIN t_userinfo userinfo ON sell.f_userinfo_id = userinfo.f_userinfo_id
        WHERE sell.f_state = '有效'
        AND sell.f_payment in('银行','pos聚合支付')
        AND sell.f_operate_date >= '{startDate} 00:00:00'
        AND sell.f_operate_date <= '{endDate} 23:59:59'
    ) bill_t ON mid_t.f_sell_id = bill_t.f_serial_id
) tt
where  {condition}
GROUP BY f_trade_date,f_payment,f_bank_name,f_orgname


