select * from (
  select
    t.*,
    hand.f_tablebase f_real_last_tablebase,
    case when hand.f_tablebase is null then 0 else
      case when hand.f_tablebase=t.f_last_tablebase
      then 0 else 1 end
    end f_out_stock,
    case when hand.f_tablebase is null then 0 else
      case when hand.f_tablebase=t.f_last_tablebase
      then 0 else t.f_last_tablebase-hand.f_tablebase end
    end f_out_gas
  from (
      select
          th.id,
          tui.f_userinfo_code,
          tui.f_user_name,
          tui.f_user_phone,
          tua.f_address,
          tuf.f_user_type,
          tuf.f_gasproperties,
          tuf.f_meter_classify,
          tgs.f_meter_brand,
          isnull(tui.f_balance,0) f_balance,
          isnull(tuf.f_balance_amount,0) f_balance_amount,
          isnull(th.f_tablebase,0) f_tablebase,  --本期底数
          isnull(th.f_last_tablebase,0) f_last_tablebase,  --上期底数
          (select max(id) maxid from t_handplan ths with(nolock)
          where ths.f_userfiles_id=th.f_userfiles_id and ths.id<th.id
          and f_hand_state='有效' and f_meter_state='已抄表'
          ) maxid,
         th.f_hand_date,
         th.f_orgid,
         th.f_orgname
      from
      t_handplan th with(nolock)
      left join t_userinfo tui with(nolock) on tui.f_userinfo_id = th.f_userinfo_id
      left join t_userfiles tuf with(nolock) on tuf.f_userfiles_id = th.f_userfiles_id
      left join t_gasbrand tgs with(nolock) on tgs.id = tuf.f_gasbrand_id
      left join t_user_address tua with(nolock) on tua.id = tuf.f_useraddress_id
      where tui.f_user_state='正常' and th.f_hand_date>='{startDate}' and th.f_hand_date<='{endDate}'
      and th.f_hand_state='有效' and th.f_meter_state='已抄表'
  ) t left join t_handplan hand on t.maxid = hand.id
) t1
where
  {condition}
order by f_userinfo_code
