SELECT
    files.f_userfiles_id,
    files.f_meternumber,
    info.f_userinfo_code,
    files.version,
    info.f_user_name,
    files.f_user_type,
    files.f_gasproperties,
    ab.f_adjustable_id,
    a.f_address,
    info.f_user_phone,
    gb.f_meter_brand,
    gb.f_manufacturers,
    gm.f_meter_style,
    sp.f_price_name
FROM
    t_userfiles files
        LEFT JOIN t_userinfo info ON info.f_userinfo_id = files.f_userinfo_id
        LEFT JOIN t_user_address a ON a.id = files.f_useraddress_id
        LEFT JOIN t_gasbrand gb ON gb.id = files.f_gasbrand_id
        LEFT JOIN t_gasmodel gm ON gm.id = files.f_gasmodel_id
        LEFT JOIN (select * from t_stairprice ss,
                                 (select f_price_id priceid,max(f_version) fversion from  t_stairprice s  group by s.f_price_id) sss
                   where ss.f_price_id=sss.priceid and ss.f_version=sss.fversion) sp ON sp.f_price_id = files.f_price_id
        LEFT JOIN t_adjustablebox ab ON ab.id = files.f_adjustable_id
WHERE
	( files.f_meter_book_num IS NULL OR files.f_meter_book_num = '' )
	AND files.f_table_state = '正常'
	AND {condition}
ORDER BY
	files.f_userfiles_id
