select * from (
select
  i.f_userinfo_code,
  i.f_userinfo_id,
  i.f_user_state,
  i.f_user_name,
  i.f_user_phone,
  u.f_user_id,
  u.f_userfiles_id,
  u.f_table_state,
  u.f_meternumber,
  u.f_gasbrand_id,
  u.f_gasmodel_id,
  u.f_user_type,
  u.f_gasproperties,
  u.f_operatorid,
  u.f_filialeid,
  u.f_orgid,
  u.f_orgname,
  u.f_depid,
  u.f_depname,
  address.f_address,
  address.f_residential_area,
  address.f_street,
  address.f_unit,
  address.f_building,
  address.f_floor,
  address.f_room,
  address.f_slice_area,
  gb.id as brand_id,
  gb.f_meter_type,
  gb.f_meter_brand,
  gm.f_meter_style,
  isnull(up.f_price_id, u.f_price_id) f_price_id,
  isnull(up.id, sp.id) f_stairprice_id,
  isnull(up.f_price_type, sp.f_price_type) f_price_type,
  isnull(up.f_price_name, sp.f_price_name) f_price_name,
  isnull(up.f_version, sp.f_version) f_version,
  case when isnull(l.id,'') != '' then '已限购' else '未限购' end limit_state,
  l.id
from t_userfiles u
  LEFT JOIN  t_userinfo i
    on u.f_userinfo_id = i.f_userinfo_id
    LEFT JOIN (select f_bank_name,f_bank_accopen,f_bank_pay_number,f_userinfo_id  from t_infobank) k
    on i.f_userinfo_id=k.f_userinfo_id
  LEFT JOIN t_user_address address
    on u.f_useraddress_id = address.id
  LEFT JOIN t_gasbrand gb
    on u.f_gasbrand_id = gb.id
  LEFT JOIN t_gasmodel gm
    on u.f_gasmodel_id = gm.id
  left join (select  * from t_limit_gas where isnull(f_state,'') != '无效') l on l.f_userinfo_id = u.f_userinfo_id
  LEFT JOIN
  (select * from  t_stairprice
  where getdate()>=f_perform_date and getdate()<=f_end_date
        and f_state = '有效'
  ) sp on u.f_price_id = sp.f_price_id and u.f_filialeid = sp.f_filialeid
  left join
  (
      select * from (
        select
            {entity.findDialect() == $SqlServer$:
            $ DATEDIFF(day,getdate(),f_parameter_value) days$,
            $ floor( to_date(f_parameter_value,'yyyy-mm-dd hh24:mi:ss') - sysdate) days$},
            b.f_userinfo_id,b.f_userfiles_id,sp.*
        from t_userproperties p left join t_basicliving b on p.f_userinfo_id = b.f_userinfo_id
        LEFT JOIN
        (select * from  t_stairprice where getdate()>=f_perform_date and getdate()<=f_end_date and f_state = '有效')
        sp on b.f_price_id = sp.f_price_id
        where p.f_state='有效' and p.f_parameter_key = 'dibaohu_endDate' and b.f_state = '有效'
    ) up where days > 0
  ) up on u.f_userinfo_id = up.f_userinfo_id
) t
where {condition} and (f_user_state = '正常' or f_user_state='预备'or f_user_state='销户') and f_table_state != '换表' and f_table_state != '无效'
order by f_userfiles_id desc
