SELECT
 *
FROM (
	SELECT
		h.f_price_id,
		ui.f_input_date,
		mr.f_user_id hpid,
		a.f_address,
		u.f_userinfo_code,
    case when h.f_price is null then pf.f_price else h.f_price end f_price,
		mr.id,
		mr.f_userinfo_id,
		mr.f_user_name,
		mr.f_user_id,
		mr.f_meternumber,
		{entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(mr.f_tablebase,0) f_tablebase,
		{entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(mr.f_last_tablebase,0) f_last_tablebase,
		mr.f_insert_date,
		mr.f_signal,
		mr.f_batterylevel,
		mr.f_valvestate,
		mr.f_magneticinterference,
		mr.f_alarmshutvalve,
		mr.f_cycleshutvalue,
		mr.f_overcurrentprotection,
		mr.f_leakageflag,
		mr.f_splitalarm,
		mr.f_XTIpllStopFlag,
		mr.f_software_version,
		mr.f_table_msg,
		mr.f_last_meter_state_msg,
		mr.f_hand_date,
		mr.f_last_hand_date,
		mr.f_upload_type,
		mr.f_jval,
		ui.f_user_type,
		ui.f_gasproperties,
		gb.f_meter_brand,
		gm.f_meter_style,
		ui.f_orgstr,
		u.f_filialeids,
		ui.f_gas_date,
		ui.f_table_state,
		h.f_balance f_balance_amount,
		{entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(h.f_oughtamount,0) f_oughtamount,
		{entity.findDialect()==$SqlServer$: $isnull$,$NVL$}(h.f_oughtfee,0) f_oughtfee,
		h.f_curbalance,
		h.f_balance,
		h.id hid,
		ui.f_filiale,
		gb.f_alias,                                         --表厂别名
		p.f_parameter_date,
		--mr.f_nsturalgas_data,                               --24小时用气量
	    --mr.f_snr,                                           --信噪比
		case when p.f_parameter_state is null then '未标记' else f_parameter_state end f_parameter_state
	FROM
		t_meteread mr
		--left join t_handplan h on h.f_meteread_id=mr.id
		LEFT JOIN t_userfiles ui ON (ui.f_user_id = mr.f_user_id and ui.f_meternumber = mr.f_meternumber)
		LEFT JOIN t_user_address a on ui.f_useraddress_id=a.id
		LEFT JOIN t_userinfo u ON (u.f_userinfo_id = ui.f_userinfo_id)
		left join t_gasbrand gb on ui.f_gasbrand_id = gb.id
		left join t_gasmodel gm on ui.f_gasmodel_id = gm.id
		left join (select f_user_id,'已标记' f_parameter_state,max(f_parameter_date) f_parameter_date
		        from t_userparameter where f_parameter_state='待处理' GROUP BY f_user_id
						having COUNT(*)>0) p
		    on ui.f_user_id=p.f_user_id
		left join (
				select
			  f_price_id,
			 (select CAST(f_price as varchar)+' ' from t_detailprice d where  d.f_stairprice_id=p.id for XML path('')) f_price
			from t_stairprice p where f_state='有效'
		)  pf on pf.f_price_id= ui.f_price_id
		left join (
			select
				f_price_id,
				f_meteread_id,
				f_curbalance,
				f_oughtamount,
				f_oughtfee,
				f_balance,
				id,
				cast((select cast(f_price as varchar)+' ' from t_chargeprice where f_hand_id = h1.id for xml path('')) as varchar) f_price
			from t_handplan h1
		) h on h.f_meteread_id=mr.id
WHERE
    ui.f_gasbrand_id =256 and {condition}
) A
ORDER BY
	A.f_hand_date DESC