SELECT
	*
FROM
	(
	SELECT
		isnull( s.f_change_price, 0 ) f_change_price,
		isnull( s.f_real_amount, 0 ) f_real_amount,
		isnull( s.f_surplus_fee, 0 ) f_surplus_fee,
		s.id,
		s.f_state,
		s.f_whether_pay,
		s.f_operate_date,
		s.f_operator,
		s.f_depname,
		s.f_orgname,
		s.f_orgid,
		s.f_depid,
		s.f_operatorid,
		s.f_old_price,
		s.f_new_price,
		info.f_userinfo_code,
		info.f_userinfo_id,
		info.f_user_phone,
		info.f_user_name,
		files.f_hand_date last_hand_date,
		gb.f_meter_brand,
		ua.f_address,
		s.f_start_date,
		s.f_end_date,
		ua.f_slice_area AS f_zones,
		h.f_hand_date,
		h.f_last_tablebase,
		h.f_tablebase,
		h.f_inputtor,
		h.f_surplus_gas,
	    ts.f_operate_date as f_sfjl,
		SUBSTRING ( CONVERT ( VARCHAR ( 100 ), s.f_start_date, 23 ), 0, 11 ) + '至' + SUBSTRING ( CONVERT ( VARCHAR ( 100 ), s.f_end_date, 23 ), 0, 11 ) f_qujian
	FROM
		t_surplus_detail s
		LEFT JOIN t_userinfo info ON s.f_userinfo_id = info.f_userinfo_id
		LEFT JOIN t_user_address ua ON info.f_userinfo_id= ua.f_userinfo_id
		LEFT JOIN t_userfiles files ON s.f_userfiles_id = files.f_userfiles_id
		left join t_gasbrand gb on files.f_gasbrand_id = gb.id
		LEFT JOIN t_handplan h ON s.f_handplan_id= h.id
	    left join t_sellinggas ts on s.f_sell_id = ts.id
	) t
WHERE
	{ condition }
	AND f_state != '无效'
ORDER BY
	f_operate_date DESC
