-- 收费记录数据sql 示例 

-- 添加收费信息（用户用户信息，气量到表中）
-- 程序循环读取这些数据进行收费

drop table t_user_sell;
create table t_user_sell
(
    f_userinfo_id    varchar(255) not null
        constraint t_user_sell_pk
            primary key,
    f_card_id  varchar(255), -- 卡号 没有留空
    f_price_id varchar(255), -- 气价id  t_userfiles.f_price_id
    f_userfiles_id        varchar(255),
    f_pre_gas       numeric(19, 2), -- 单次购气量
    f_collection      numeric(19, 2), -- 单次购气量金额 默认取一阶购气量进行计算
    isgasvalue varchar(20), -- 是否按照气量 收费 1/0
    f_type  varchar(255), -- 收费类型 卡表收费/物联网收费/发卡售气
    months           varchar(255), --收费记录所在年月  注意：字符串类型  如2月请赋值为 '2022-02'
    day              numeric(5), --随机在此天数区间内进行收费  比如28 此条记录将会在 1号到28号随机取时间进行收费
    f_comments varchar(255) -- 备注 自定义
);
insert into  t_user_sell
select info.f_userinfo_id,uf.f_card_id, uf.f_price_id,uf.f_userfiles_id,
       100,100*sp.f_price,
       case  when gb.f_collection_type like'%气%' then 1 else 0 end ,
       case  when gb.f_meter_type like '%卡表%' then '卡表收费' else '物联网收费' end ,
       '2022-01',28,
      '备注：wenbuzhang'
from t_userinfo info
    left join t_userfiles uf on uf.f_userinfo_id = info.f_userinfo_id
left join (
    select sp.f_price_id,td.f_price,f_filialeid from t_stairprice sp left join t_detailprice td on sp.id = td.f_stairprice_id
    where sp.f_end_date > getdate() and f_state ='有效' and td.f_price_name = 1
) sp on sp.f_price_id = uf.f_price_id and sp.f_filialeid = uf.f_filialeid
left join t_gasbrand gb on gb.id = uf.f_gasbrand_id
where  info.f_comments ='wenbuzhang';

-- 添加操作员站点信息到表中
-- 程序随机获取这些数据进行收费操作

drop table t_oper_info;
create table t_oper_info
(
    f_payment             varchar(20),
    f_orgid               varchar(20),
    f_orgname             varchar(50),
    f_depid               varchar(20),
    f_depname             varchar(50),
    f_operatorid          varchar(20),
    f_operator            varchar(50),
    f_bill_style          varchar(50),
    f_bank_name           varchar(20),
    f_terminal_num        varchar(50)
);
insert into t_oper_info
select f_payment, f_orgid, f_orgname, f_depid, f_depname, f_operatorid, f_operator, f_bill_style, f_bank_name, f_terminal_num
from t_sellinggas
where f_depid is not null and f_depname is not null and f_operator is not null and f_operatorid is not null
group by f_payment, f_orgid, f_orgname, f_depid, f_depname, f_operatorid, f_operator, f_bill_style, f_bank_name, f_terminal_num;
