select *
from (
SELECT sum(hd.f_oughtfee)                                                      f_oughtfee,    --结算金额
       sum(hd.f_oughtamount)                                                   f_oughtamount, --结算气量
       sum(case when hd.f_whether_pay = '是' then hd.f_oughtfee else 0 end)    f_preamount,   --已结算金额
       sum(case when hd.f_whether_pay = '是' then hd.f_oughtamount else 0 end) f_pregas,      --已结算气量
       sum(case
               when hd.f_surplus_id is null and hd.f_whether_pay = '是'
                   then hd.f_oughtamount * isnull(sp.f_add_price, 0)
               else 0 end)                                                     f_refund_fee,  --待退费金额
       sum(case
               when hd.f_surplus_id is null then 0
               else hd.f_oughtamount * isnull(sp.f_add_price, 0) end)          f_refunded_fee --已退费金额
FROM t_handplan hd
         LEFT JOIN t_stairprice sp ON sp.id = hd.f_stairprice_id
WHERE hd.f_hand_state = '有效'
  and hd.f_meter_state = '已抄表'
  AND sp.f_state = '有效'
  AND sp.f_perform_date <= GETDATE()
  AND sp.f_end_date >= GETDATE()
  and {condition}
union all
SELECT sum(hd.f_oughtfee)                                                                                  f_oughtfee,    --结算金额
       sum(hd.f_oughtamount)                                                                               f_oughtamount, --结算气量
       sum(hd.f_oughtfee)                                                                                  f_preamount,   --已结算金额
       sum(hd.f_oughtamount)                                                                               f_pregas,      --已结算气量
       sum(case
               when hd.f_surplus_id is null then hd.f_oughtamount * isnull(sp.f_add_price, 0)
               else 0 end)                                                                                 f_refund_fee,  --待退费金额
       sum(case
               when hd.f_surplus_id is null then 0
               else hd.f_oughtamount * isnull(sp.f_add_price, 0) end)                                      f_refunded_fee --已退费金额
FROM t_web_handplan hd
         LEFT JOIN t_stairprice sp ON sp.id = hd.f_stairprice_id
WHERE hd.f_hand_state = '有效'
  and hd.f_meter_state = '已抄表'
  AND sp.f_state = '有效'
  AND sp.f_perform_date <= GETDATE()
  AND sp.f_end_date >= GETDATE()
  and {condition}
) g  order by  f_oughtamount desc