 select * from (
 select
       f_cost_type,                 --付款方式
       f_userinfo_code,
       f_userinfo_id,          		--用户编号
       f_user_name,            		--用户姓名
       f_user_phone,           		--用户电话
       f_residential_area,				--小区
       f_building,               		--楼号
       f_balance,          	 		--用户账户结余
       f_contract_id,          	 	--合同编号
       f_orgid,                   --分公司
       f_user_type,          --用户类型
       min(f_last_tablebase) f_last_tablebase,		 		--上次抄表底数
       max(f_tablebase) f_tablebase,			     		--本次抄表底数
       min(f_input_date) f_input_date,
       case when min(f_hand_date)=max(f_hand_date) then  cast(year(min(f_hand_date)) as varchar)+'年'+cast(MONTH(min(f_hand_date)) as varchar)+'月'
       else  cast(year(min(f_hand_date)) as varchar)+'年'+cast(MONTH(min(f_hand_date)) as varchar)+'月到'
       + cast(year(max(f_hand_date)) as varchar)+'年'+cast(MONTH(max(f_hand_date)) as varchar)+'月' end f_hand_date,
       sum(f_oughtamount) f_oughtamount,			 		--应交气量
       sum(f_oughtfee) f_oughtfee, 		     	 		--应交金额
       case when sum(f_oughtfee)=0 then 0 else sum(f_oughtfee)-f_balance - sum(f_debt_money) end qianfei,--欠费金额
       sum(isnull(overdue,0)) overdue,					 		--滞纳金
       min(f_end_date) f_end_date				 		--截止日期
  from
  (
   select
         u.f_cost_type,
         u.f_userinfo_code,
         f_debt_money,
		 handplan_id,											--抄表记录id
		 f_last_tablebase,										--上期指数
		 f_tablebase,											--本期指数
		 h.f_input_date,											--抄表日期
		 convert(decimal(18,2),f_oughtamount) f_oughtamount,	--应交气量
		 convert(decimal(18,2),f_oughtfee) f_oughtfee,			--应交金额
		 f_whether_pay,											--是否缴费
		 f_end_date,											--截止日期
		 h.f_hand_date,
		 overduedays,											--滞纳天数
		 h.f_user_id,                                           --用户编号
		 u.f_userinfo_id,          		--用户编号
         u.f_user_name,            		--用户姓名
         u.f_user_phone,           		--用户电话
         ua.f_residential_area,              		--小区
         u.f_balance,          	 		--用户账户结余
         u.f_contract_id,          	 	--合同编号
         ua.f_building,						--楼号
         u.f_orgid,					--分公司
          u.f_orgname,
	  u1.f_meter_classify,
	 u1.f_user_type,
      convert(decimal(18,2),
      CASE WHEN overduedays<=0 THEN
      isnull(f_latefee_ought,0)
      ELSE
      --滞纳金天数大于0，若应交金额小于0
      CASE WHEN overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -(case when mh.minid is null  then 0 else isnull(u.f_balance,0) end))<=0
      THEN
      isnull(f_latefee_ought,0)
      ELSE
      --判断应交金额是否小于0
      (CASE WHEN overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -case when mh.minid is null   then 0 else isnull(u.f_balance,0) end)+isnull(zhengchang,0)>=
      f_oughtfee-f_debt_money -(case when mh.minid is null  then 0 else isnull(u.f_balance,0) end)
      THEN
      CASE WHEN f_oughtfee-f_debt_money -(case when mh.minid is null  then 0 else isnull(u.f_balance,0) end)<0
      THEN 0
      ELSE
      case when f_oughtfee-f_debt_money -(case when mh.minid is null  then 0 else isnull(u.f_balance,0) end)-isnull(jianmian,0)<=0
      then 0
      else f_oughtfee-f_debt_money -(case when mh.minid is null  then 0 else u.f_balance end)-isnull(jianmian,0)
      end
      END
      ELSE
      overduedays*zhinajinbilv*(f_oughtfee-f_debt_money -(case when mh.minid is null  then 0 else isnull(u.f_balance,0) end))+isnull(f_latefee_ought,0)
      END)
      END
      END) overdue
   from(
		  select
		  h.id as handplan_id,
		  h1.last_tablebase,
		  f_last_tablebase,
		  f_userinfo_code,
		  f_tablebase,
		  f_input_date,
		  h.f_hand_date,
		  f_oughtamount,
		  f_oughtfee,
		  f_whether_pay,
		  f_end_date,
		  h.f_user_id,
		  f_userinfo_id,
          lr.f_latefee_ought,
          lr.zhengchang,
          lr.jianmian,
          isnull(f_debt_money,0) f_debt_money,
          isnull(f_charge_money,0) f_charge_money,
          isnull(f_selloverdue,0) f_selloverdue,
		  DATEDIFF(dd,f_end_date,getdate()) overduedays, --滞纳天数
          CASE WHEN h.f_user_type='民用'
          THEN isnull((SELECT cast(value as float) FROM  t_singlevalue WHERE name='民用违约金' and f_filialeids=h.f_orgid),(SELECT cast(value as float) FROM  t_singlevalue WHERE name='民用违约金'))
          ELSE
          isnull((SELECT cast(value as float) FROM  t_singlevalue WHERE name='非民用违约金' and f_filialeids=h.f_orgid),(SELECT cast(value as float) FROM  t_singlevalue WHERE name='非民用违约金'))
          END zhinajinbilv   			   --滞纳金比率
          from
			 (
                 select * from t_handplan
                 where f_whether_pay='否' and f_meter_state = '已抄表' and f_hand_state = '有效'
			 ) h
              LEFT JOIN (
                  SELECT
                  f_hand_id,SUM(f_debt_money) f_debt_money,
                  SUM(f_charge_money) f_charge_money,SUM(f_overdue) f_selloverdue
                  FROM t_sellinghand
                  WHERE f_state = '有效'
                  GROUP BY f_hand_id
              ) sh on h.id = sh.f_hand_id
              left join (
                  select f_hand_id,min(f_start_date) f_start_date,sum(f_latefee_ought) f_latefee_ought,sum(jianmian) jianmian,sum(zhengchang) zhengchang
                  from (
                      select f_hand_id,
                      f_latefee_ought,
                      f_start_date,
                      case when f_latefee_ought<0 then 0-f_latefee_ought else 0 end jianmian,
                      case when f_latefee_ought>0 then f_latefee_ought else 0 end zhengchang
                      from t_latefee_record where f_state='有效'
                  ) l group by f_hand_id
              ) lr on h.id = lr.f_hand_id
			 left join
			 (
			  select MIN(f_last_tablebase) last_tablebase,f_user_id from t_handplan
			  group by f_user_id
			 ) h1 on h.f_user_id=h1.f_user_id
		 ) h
	   left join
	   t_userinfo u on h.f_userinfo_id=u.f_userinfo_id
	   left join
	   t_user_address ua on ua.f_userinfo_id=u.f_userinfo_id
           left join
	   t_userfiles u1 on h.f_user_id=u1.f_user_id
          left join (
          select min(id) minid,f_userfiles_id
          from t_handplan
          where  f_hand_state = '有效' and f_meter_state = '已抄表'
          AND f_oughtfee>0 and f_whether_pay='否' group by f_userfiles_id
          ) mh on h.handplan_id = mh.minid and mh.f_userfiles_id = u1.f_userfiles_id
	 ) u
	 where  {condition}
	 group by  f_userinfo_id,f_user_name,f_user_phone,f_building,f_balance,f_contract_id,f_residential_area,f_orgid,f_userinfo_code,f_cost_type,f_user_type
	 ) t
	 where t.qianfei>0
	 order by f_hand_date desc
