select * from (
  select
	(isnull(p.f_type,'')) { entity.findDialect() == $SqlServer$: $+$,$||$} (isnull(p.f_print_state,'')) as print_stats,
    p.f_type,
    p.f_print_state,
    p.f_print_time as f_printdate,
    p.f_print_id id,
    p.f_print_id_number,
    u.f_user_nature,
    u.f_userinfo_code,
    u.f_olduserinfo_code,
    u.f_userinfo_id,
    u.version,
    u.f_user_name,
    u.f_filialeid,
    u.f_createfile_date,
    u.f_user_phone,
    a.id addressid,
    a.f_address,
    a.f_street,
    a.f_residential_area,
    a.f_small_area,
    case when tuf.f_open_date is null then '否' else '是' END openaccount,
    a.f_pcd,
    u.f_user_state,
    u.f_balance,
    u.f_book_no,
    u.f_user_level,
    u.f_contract_id,
    u.f_send_usegas_card,
    u.f_ins_stop_date,
    u.f_print_lc,
    u.f_email,
    u.f_contact_user,
    p.f_print_id_number f_print_ID,
    p.f_type as f_print_dh,
    tuf.f_user_type,
    tuf.f_userfiles_id,
    tuf.version file_version,
    tuf.f_gasproperties,
    tuf.f_adjustable_id,
    tuf.f_whether_hairpin,
    tuf.f_userfiles_address,
    tuf.f_usetype,
    tuf.f_meter_classify,
    tuf.f_gongye_type,
    tuf.f_meter_base,
    tuf.f_meternumber,
    tuf.f_user_id,
    tuf.f_price_id,
    tuf.f_card_id,
    gb.f_meter_brand,
    tuf.f_table_state,
    tuf.f_total_gas,
    case up.f_parameter_state when '正常' then '是' else '否' end f_blacklist_state,
    tuf.f_open_date,
    tuf.f_operator,
    tuf.f_depid,
    tuf.f_orgid,
    tuf.f_orgname,
    tuf.f_operatorid,
    tuf.f_gasproperties_second,
    tuf.f_feed_method,
    tuf.f_box_number,
    tuf.f_defendcard,
    tuf.f_defendcard_two,
    tuf.f_balance_amount,
    sp.f_price_name,
    dev.f_devices_type
  from
    t_userinfo u
    LEFT JOIN t_user_address a on u.f_userinfo_id = a.f_userinfo_id
		left join t_userfiles tuf on tuf.f_userinfo_id = u.f_userinfo_id
    left join t_userparameter up on u.f_userinfo_id = up.f_userinfo_id and f_parameter_key ='backlist' and f_parameter_state ='正常'
		LEFT JOIN t_print_sheet p on p.f_userinfo_id =  u.f_userinfo_id and p.f_state = '有效'
    LEFT JOIN t_gasbrand gb on gb.id=tuf.f_gasbrand_id
    left join (select f_devices_type,f_userinfo_id from t_devices ) dev on dev.f_userinfo_id=u.f_userinfo_id
  left join t_stairprice sp
    on tuf.f_price_id = sp.f_price_id and tuf.f_filialeid = sp.f_filialeid and sp.f_state = '有效' and getdate()>=f_perform_date and getdate()<= sp.f_end_date
) u
where {condition} and (f_table_state = '待开通' or f_table_state = '正常' or f_table_state = '停用' or f_table_state = '拆表'  or f_table_state is null)
and f_createfile_date is not null
ORDER by f_userinfo_id desc
