/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;
import javax.xml.bind.DatatypeConverter;

public class RsaUtil {
    private static final String KEY_RSA = "RSA";
    private static final String KEY_RSA_SIGNATURE = "MD5withRSA";
    private static final String KEY_RSA_PUBLICKEY = "RSAPublicKey";
    private static final String KEY_RSA_PRIVATEKEY = "RSAPrivateKey";
    private static final int MAX_ENCRYPT_BLOCK = 117;
    private static final int MAX_DECRYPT_BLOCK = 128;
    private static final int MAX_DECRYPT_BLOCK_256 = 256;

    public static void main(String[] args) {
        try {
            String publicKey = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCK/EPVRxc4JBDaJ2/d6By7ZE3EofHISFilwd3/iQUmCOuFdxjI4pK6uh5kwKPeYecT1Wfsi7aDC4b5xw0xEY+0nFOBLv3Gn4j6E7YVCDONkicqlCfdX57v5pGlYWP1ySueQp8iLPM3goKUHros9VAHD+0/utUsaWqo/DbdhCzaawIDAQAB";
            String context = "\u4f60\u662f\u4e2a\u72d7\u5427";
            String jsonParam = "";
            try {
                jsonParam = URLEncoder.encode(context, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            String encryptParam = RsaUtil.encryptByPublicKey(publicKey, jsonParam);
            System.out.println("\u52a0\u5bc6\u7ed3\u679c====== \n" + encryptParam);
            String privateKey = "MIICdgIBADAN========BgkqhkiG9w0BAQEFAASCAmAwggJcAgEAAoGBAIr8Q9VHFzgkENonb93oHLtkTcSh8chIWKXB3f+JBSYI64V3GMjikrq6HmTAo95h5xPVZ+yLtoMLhvnHDTERj7ScU4Eu/cafiPoTthUIM42SJyqUJ91fnu/mkaVhY/XJK55CnyIs8zeCgpQeuiz1UAcP7T+61Sxpaqj8Nt2ELNprAgMBAAECgYAneIT7KPlbJEL08YY/iw+92DqNwUAdFQ635Frbm1ou9xGMEcqkIlRxWzIOgvcGzN8HLvAYqYTnqnpmrTT93nLk94P2m25YJyEkMI9n2CCLw0bgWPdOdfJsZTEt5t/jGnYFBlfcrs+40c6sz5Td1pZUJp8j3sst901VK5RnVqEegQJBAN3PCfZMPHw4zKS+1CFQ/dlWbwoj1l2/+YKMLmFw5DkFPIrR8EXSXP9yUtAd6DRchFjRnyy2Z2AAAvSmppE0rlECQQCgaN9TCL/QxJsBpm0WhoRyFKFaQ78UyPpbeMusE7jld8LD5LN9Nm0BLB0E3OU/4EWFmeoysWIGWGBA+xMzVaH7AkEAo8ZpbqifyIEP6VzVuLvak41Uc8I+V/6VtqTW4i++87NAHqggpw1KiXraVryeZXsiZYpx40vTTHj1tbsPJgwl4QJAXM3Pxp5dO09DzqSWoF2a6tV8tFhViJTuI1WzoA6Y/klXaTY7kcmXLwJyl4mlKFt8XVs637E4YStoJLAd36k/WQJAetQocVfzvyr7BHDQc4DlzYS87wMeMei1sKppm+qPXwUOaPd238j3QWrPT5jAuF/bdTgVJ5w5gv7gAK6ZSVCo2g==";
            RsaUtil.decodeByPrivateKey(encryptParam, privateKey);
        }
        catch (Exception ex) {
            System.out.print("");
        }
    }

    public static String decodeByPrivateKey(String encryptParam, String privateKey, String errorMessage) {
        String signVerify = "";
        try {
            signVerify = URLDecoder.decode(RsaUtil.decryptByPrivateKey(privateKey, encryptParam), "UTF-8");
            System.out.println(signVerify);
            return signVerify;
        }
        catch (Exception er) {
            return errorMessage;
        }
    }

    public static String decodeByPrivateKey(String encryptParam, String privateKey) {
        String signVerify = "";
        try {
            signVerify = URLDecoder.decode(RsaUtil.decryptByPrivateKey(privateKey, encryptParam), "UTF-8");
            System.out.println(signVerify);
            return signVerify;
        }
        catch (Exception er) {
            return "\u6570\u636e\u975e\u6cd5\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458\u7533\u8bf7\u83b7\u53d6\u6b63\u786e\u7684key\uff01";
        }
    }

    public static Map<String, Object> generateKey() {
        HashMap<String, Object> map = null;
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance(KEY_RSA);
            generator.initialize(1024);
            KeyPair keyPair = generator.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
            map = new HashMap<String, Object>(2);
            map.put(KEY_RSA_PUBLICKEY, publicKey);
            map.put(KEY_RSA_PRIVATEKEY, privateKey);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        return map;
    }

    public static String sign(String privateKey, byte[] data) {
        String str = "";
        try {
            byte[] bytes = RsaUtil.decryptBase64(privateKey);
            PKCS8EncodedKeySpec pkcs = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(KEY_RSA);
            PrivateKey key = factory.generatePrivate(pkcs);
            Signature signature = Signature.getInstance(KEY_RSA_SIGNATURE);
            signature.initSign(key);
            signature.update(data);
            str = RsaUtil.encryptBase64(signature.sign());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static String sign(String privateKey, String dataStr) {
        String str = "";
        try {
            byte[] data = dataStr.getBytes("UTF-8");
            return RsaUtil.sign(privateKey, data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String signPublicKey(String publicKey, String dataStr) {
        String str = "";
        try {
            byte[] data = dataStr.getBytes("UTF-8");
            return RsaUtil.signPublicKey(publicKey, data);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String signPublicKey(String publicKey, byte[] data) {
        String str = "";
        try {
            byte[] bytes = RsaUtil.decryptBase64(publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(KEY_RSA);
            PublicKey publicKey2 = factory.generatePublic(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static boolean verify(String publicKey, byte[] data, String sign) {
        boolean flag = false;
        try {
            byte[] bytes = RsaUtil.decryptBase64(publicKey);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(KEY_RSA);
            PublicKey key = factory.generatePublic(keySpec);
            Signature signature = Signature.getInstance(KEY_RSA_SIGNATURE);
            signature.initVerify(key);
            signature.update(data);
            flag = signature.verify(RsaUtil.decryptBase64(sign));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return flag;
    }

    public static boolean verify(String publicKey, String dataStr, String sign) {
        try {
            byte[] data = dataStr.getBytes("UTF-8");
            return RsaUtil.verify(publicKey, data, sign);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] encryptByPublicKey(String key, byte[] data) {
        Object result = null;
        try {
            byte[] bytes = RsaUtil.decryptBase64(key);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(KEY_RSA);
            PublicKey publicKey = factory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            cipher.init(1, publicKey);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return encryptedData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptByPublicKey(String key, String dataStr) {
        try {
            byte[] result = RsaUtil.encryptByPublicKey(key, dataStr.getBytes("UTF-8"));
            return RsaUtil.encryptBase64(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] decryptByPrivateKey(String key, byte[] data, int maxDecryptBlock) {
        Object result = null;
        try {
            byte[] bytes = RsaUtil.decryptBase64(key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(KEY_RSA);
            PrivateKey privateKey = factory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            cipher.init(2, privateKey);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > maxDecryptBlock ? cipher.doFinal(data, offSet, maxDecryptBlock) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * maxDecryptBlock;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return decryptedData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptByPrivateKey256(String key, String dataStr) {
        try {
            byte[] result = RsaUtil.decryptByPrivateKey(key, RsaUtil.decryptBase64(dataStr), 256);
            return new String(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String decryptByPrivateKey(String key, String dataStr) {
        try {
            byte[] result = RsaUtil.decryptByPrivateKey(key, RsaUtil.decryptBase64(dataStr), 128);
            return new String(result, StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] encryptByPrivateKey(String key, byte[] data) {
        Object result = null;
        try {
            byte[] bytes = RsaUtil.decryptBase64(key);
            PKCS8EncodedKeySpec keySpec = new PKCS8EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(KEY_RSA);
            PrivateKey privateKey = factory.generatePrivate(keySpec);
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            cipher.init(1, privateKey);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 117 ? cipher.doFinal(data, offSet, 117) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 117;
            }
            byte[] encryptedData = out.toByteArray();
            out.close();
            return encryptedData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String encryptByPrivateKey(String key, String dataStr) {
        try {
            byte[] result = RsaUtil.encryptByPrivateKey(key, dataStr.getBytes("UTF-8"));
            return RsaUtil.encryptBase64(result);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static byte[] decryptByPublicKey(String key, byte[] data) {
        Object result = null;
        try {
            byte[] bytes = RsaUtil.decryptBase64(key);
            X509EncodedKeySpec keySpec = new X509EncodedKeySpec(bytes);
            KeyFactory factory = KeyFactory.getInstance(KEY_RSA);
            PublicKey publicKey = factory.generatePublic(keySpec);
            Cipher cipher = Cipher.getInstance(factory.getAlgorithm());
            cipher.init(2, publicKey);
            int inputLen = data.length;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            int offSet = 0;
            int i = 0;
            while (inputLen - offSet > 0) {
                byte[] cache = inputLen - offSet > 128 ? cipher.doFinal(data, offSet, 128) : cipher.doFinal(data, offSet, inputLen - offSet);
                out.write(cache, 0, cache.length);
                offSet = ++i * 128;
            }
            byte[] decryptedData = out.toByteArray();
            out.close();
            return decryptedData;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String decryptByPublicKey(String key, String dataStr) {
        try {
            byte[] result = RsaUtil.decryptByPublicKey(key, RsaUtil.decryptBase64(dataStr));
            return new String(result, "UTF-8");
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    public static String getPublicKey(Map<String, Object> map) {
        String str = "";
        try {
            Key key = (Key)map.get(KEY_RSA_PUBLICKEY);
            str = RsaUtil.encryptBase64(key.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static String getPrivateKey(Map<String, Object> map) {
        String str = "";
        try {
            Key key = (Key)map.get(KEY_RSA_PRIVATEKEY);
            str = RsaUtil.encryptBase64(key.getEncoded());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return str;
    }

    public static byte[] decryptBase64(String key) {
        return DatatypeConverter.parseBase64Binary((String)key);
    }

    public static String encryptBase64(byte[] key) {
        return DatatypeConverter.printBase64Binary((byte[])key);
    }
}

