/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChargePriceCalculator {
    public static JSONObject calculate(JSONObject chargeprice) {
        JSONArray jsonArray = chargeprice.getJSONArray("chargeprice");
        for (Object element : jsonArray) {
            JSONObject jsonObject = (JSONObject)element;
            double f_price = jsonObject.optDouble("f_price", 0.0);
            if (f_price == Math.floor(f_price * 100.0) / 100.0) {
                jsonObject.put("correction_amount", 0);
                continue;
            }
            double f_gas = jsonObject.optDouble("f_gas", 0.0);
            double f_money = jsonObject.optDouble("f_money", 0.0);
            double correctionAmount = f_money - f_gas * Math.floor(f_price * 100.0) / 100.0;
            jsonObject.put("correction_amount", (Object)new BigDecimal(correctionAmount).setScale(4, RoundingMode.HALF_UP));
        }
        double totalCorrectionAmount = 0.0;
        for (Object element : jsonArray) {
            JSONObject jsonObject = (JSONObject)element;
            chargeprice.put("total_correction_amount", (Object)new BigDecimal(totalCorrectionAmount += jsonObject.optDouble("correction_amount", 0.0)).setScale(4, RoundingMode.HALF_UP));
        }
        return chargeprice;
    }

    public static void main(String[] args) {
        String jsonStr = "{\"f_stair_gas4\":0,\"f_stair_gas2\":12.0012,\"f_stair_gas3\":0,\"f_stair_price3\":4,\"f_stair_money4\":0,\"f_stair_price2\":3.7213,\"f_stair_money3\":0,\"f_stair_money2\":44.66,\"f_stair_money1\":0,\"f_stair_price4\":0,\"f_stair_price1\":2.7229,\"f_stair_gas1\":0}";
        System.out.println(ChargePriceCalculator.calculate(new JSONObject(jsonStr)));
    }
}

