package util;

import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;
import java.util.Random;
public class RanDomUtil {

  private static final Random random = new Random();

  public static int getNum(int start, int end) {
    return (int) (Math.random() * (end - start + 1) + start);
  }

  public static int getNum(Integer start, Integer end) {
    return (int) (Math.random() * (end - start + 1) + start);
  }

  public static int getNum(String start, String end) {
    return (int)
        (Math.random() * (Integer.parseInt(end) - Integer.parseInt(start) + 1)
            + Integer.parseInt(start));
  }

  // 随机取JSONArray中的某一项
  public static JSONObject getRandom(String str) {
    JSONArray array = new JSONArray(str);
    return array.getJSONObject(random.nextInt(array.length()));
  }

  // 随机姓名
  private static String FIRST_NAME =
      "赵钱孙李周吴郑王冯陈褚卫蒋沈韩杨朱秦尤许何吕施张孔曹严华金魏陶姜戚谢邹喻柏水窦章云苏潘葛奚范彭郎鲁韦昌马苗凤花方俞任袁柳酆鲍史唐费廉岑薛雷贺倪汤滕殷罗毕郝邬安常乐于时傅皮卞齐康伍余元卜顾孟平黄和穆萧尹姚邵湛汪祁毛禹狄米贝明臧计伏成戴谈宋茅庞熊纪舒屈项祝董梁杜阮蓝闵席季麻强贾路娄危江童颜郭梅盛林刁钟徐邱骆高夏蔡田樊胡凌霍虞万支柯咎管卢莫经房裘缪干解应宗宣丁贲邓郁单杭洪包诸左石崔吉钮龚程嵇邢滑裴陆荣翁荀羊於惠甄魏加封芮羿储靳汲邴糜松井段富巫乌焦巴弓牧隗山谷车侯宓蓬全郗班仰秋仲伊宫宁仇栾暴甘钭厉戎祖武符刘姜詹束龙叶幸司韶郜黎蓟薄印宿白怀蒲台从鄂索咸籍赖卓蔺屠蒙池乔阴郁胥能苍双闻莘党翟谭贡劳逄姬申扶堵冉宰郦雍却璩桑桂濮牛寿通边扈燕冀郏浦尚农温别庄晏柴瞿阎充慕连茹习宦艾鱼容向古易慎戈廖庚终暨居衡步都耿满弘匡国文寇广禄阙东殴殳沃利蔚越夔隆师巩厍聂晁勾敖融冷訾辛阚那简饶空曾毋沙乜养鞠须丰巢关蒯相查后江红游竺权逯盖益桓公万俟司马上官欧阳夏侯诸葛闻人东方赫连皇甫尉迟公羊澹台公冶宗政濮阳淳于仲孙太叔申屠公孙乐正轩辕令狐钟离闾丘长孙慕容鲜于宇文司徒司空亓官司寇仉督子车颛孙端木巫马公西漆雕乐正壤驷公良拓拔夹谷宰父谷粱晋楚阎法汝鄢涂钦段干百里东郭南门呼延归海羊舌微生岳帅缑亢况后有琴梁丘左丘东门西门商牟佘佴伯赏南宫墨哈谯笪年爱阳佟第五言福百家姓续";
  private static String GIRL =
      "秀娟英华慧巧美娜静淑惠珠翠雅芝玉萍红娥玲芬芳燕彩春菊兰凤洁梅琳素云莲真环雪荣爱妹霞香月莺媛艳瑞凡佳嘉琼勤珍贞莉桂娣叶璧璐娅琦晶妍茜秋珊莎锦黛青倩婷姣婉娴瑾颖露瑶怡婵雁蓓纨仪荷丹蓉眉君琴蕊薇菁梦岚苑婕馨瑗琰韵融园艺咏卿聪澜纯毓悦昭冰爽琬茗羽希宁欣飘育滢馥筠柔竹霭凝晓欢霄枫芸菲寒伊亚宜可姬舒影荔枝思丽 ";
  private static String BOY =
      "伟刚勇毅俊峰强军平保东文辉力明永健世广志义兴良海山仁波宁贵福生龙元全国胜学祥才发武新利清飞彬富顺信子杰涛昌成康星光天达安岩中茂进林有坚和彪博诚先敬震振壮会思群豪心邦承乐绍功松善厚庆磊民友裕河哲江超浩亮政谦亨奇固之轮翰朗伯宏言若鸣朋斌梁栋维启克伦翔旭鹏泽晨辰士以建家致树炎德行时泰盛雄琛钧冠策腾楠榕风航弘";

  public String getRandomName(Integer ratio) {
    char firstName = FIRST_NAME.toCharArray()[random.nextInt(FIRST_NAME.toCharArray().length)];
    String lastName;
    int sex = random.nextInt(9);
    if (sex < ratio) {
      lastName = getBOYlName();
    } else {
      lastName = getGirlName();
    }
    return firstName + lastName;
  }

  private String getBOYlName() {
    String lastName = "";
    int num = getNum(1, 2); // 随机获取2字姓名和3字姓名
    if (num == 1) {
      lastName = String.valueOf(BOY.charAt(random.nextInt(BOY.toCharArray().length)));
    } else if (num == 2) {
      for (int i = 0; i < 2; i++) {
        lastName += BOY.charAt(random.nextInt(BOY.toCharArray().length));
      }
    }
    return lastName;
  }

  private String getGirlName() {
    String lastName = "";
    int num = getNum(1, 2); // 随机获取2字姓名和3字姓名
    if (num == 1) {
      lastName = String.valueOf(GIRL.charAt(random.nextInt(GIRL.toCharArray().length)));
    } else if (num == 2) {
      for (int i = 0; i < 2; i++) {
        lastName += GIRL.charAt(random.nextInt(GIRL.toCharArray().length));
      }
    }
    return lastName;
  }

  // 随机手机号
  private static String[] telFirst =
      "134,135,136,137,138,139,150,151,152,157,158,159,130,131,132,155,156,133,153".split(",");

  public String getTel() {
    int index = getNum(0, telFirst.length - 1);
    String first = telFirst[index];
    String second = String.valueOf(getNum(1, 888) + 10000).substring(1);
    String third = String.valueOf(getNum(1, 9100) + 10000).substring(1);
    return first + second + third;
  }

  // 根据楼栋单元楼层房间号生成
  public JSONArray getAddressList(JSONObject json) {
    JSONArray addressarry = new JSONArray();
    // 获取漏洞区间
    int building_min = json.getInt("building_min");
    int building_max = json.getInt("building_max");
    // 得到单元区间
    int unit_min = json.getInt("unit_min");
    int unit_max = json.getInt("unit_max");
    // 得到楼层区间
    int floor_min = json.getInt("floor_min");
    int floor_max = json.getInt("floor_max");
    // 得到房间区间
    int room_min = json.getInt("room_min");
    int room_max = json.getInt("room_max");
    // 开始生成地址列表
    for (int i = building_min; i <= building_max; i++) {
      for (int j = unit_min; j <= unit_max; j++) {
        for (int m = floor_min; m <= floor_max; m++) {
          for (int n = room_min; n <= room_max; n++) {
            addressarry.put(new JSONObject().put("f_building",i)
                    .put("f_building_suffix","号楼")
                    .put("f_unit",j)
                    .put("f_unit_suffix","单元")
                    .put("f_floor",m)
                    .put("f_floor_suffix","层")
                    .put("f_room",n)
                    .put("f_room_suffix","室")
            );
          }
        }
      }
    }
    return addressarry;
  }

  @Test
  public void getAddressList(){
//    JSONObject address = new JSONObject();
//    address.put("building_min",1);
//    address.put("building_max",2);
//    address.put("unit_min",1);
//    address.put("unit_max",3);
//    address.put("floor_min",1);
//    address.put("floor_max",3);
//    address.put("room_min",1);
//    address.put("room_max",3);
//    System.out.println(getAddressList(address));
  }
}
