package util;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Objects;
import java.util.Random;

/**
 * @author 张振宇
 * @email 809534382@qq.com
 * @createTime 2021年08月14日
 */
public class Invoice {

    /**
     * String转换为bigDecimal
     *
     * @param num 数字字符串
     * @return bigDecimal类型
     */
    public static BigDecimal Scale(String num, int scale) {
        return new BigDecimal(num).setScale(scale, RoundingMode.HALF_UP);
    }

    public static String updateJSon(String json, JSONObject josnobj) {
        JSONObject jsonstr = new JSONObject(json);
        for (String str : josnobj.keySet()) {
            jsonstr.put(str, josnobj.getString(str));
        }
        return jsonstr.toString();
    }

    public static JSONObject removeKey(String key, JSONObject jsonObject) {
        jsonObject.remove(key);
        return jsonObject;
    }

    public static String arrToConditionString(String[] strings) {
        return ("(" + String.join(",", strings) + ")").replace("\"", "'");
    }

    public static String arrToConditionString(int[] arr) {
        String[] strAry = Arrays.stream(arr).mapToObj(String::valueOf).toArray(String[]::new);
        return ("(" + String.join(",", strAry) + ")").replace("\"", "'");
    }

    public static String arrToConditionString(JSONArray jsonArray) {
        return ("(" + jsonArray.join(",") + ")").replace("\"", "'");
    }

    public static String getSerial(String f_operatorid) {
        Random random = new Random();
        LocalDateTime now = LocalDateTime.now();
        String SIGN = "QAZWSXEDCRFVTGBYHNUJMIKOLP";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2; i++) {
            sb.append(SIGN.charAt(random.nextInt(SIGN.toCharArray().length)));
        }
        return sb + now.format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + f_operatorid;
    }

    public static String getSerial(String encrypt, String length) {
        Random random = new Random();
        LocalDateTime now = LocalDateTime.now();
        String SIGN = "QAZWSXEDCRFVTGBYHNUJMIKOLP";
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 2; i++) {
            sb.append(SIGN.charAt(random.nextInt(SIGN.toCharArray().length)));
        }
        return (sb + now.format(DateTimeFormatter.ofPattern("yyyyMMddhhmmss")) + encrypt).substring(0, Integer.parseInt(length));
    }

    /**
     * 在字符串后面追加 0，示例：str 为 1, length 为 4, 则为 "1000"
     *
     * @param str    被处理的字符串
     * @param length 处理之后的位数
     * @return
     */
    public static String fillZero(String str, int length) {
        StringBuffer buffer = new StringBuffer(str);
        if (buffer.length() >= length) {
            return buffer.toString();
        } else {
            while (buffer.length() < length) {
                buffer.append("0");
            }
        }
        return buffer.toString();
    }

    /**
     * 字符串格式化指定小数位，不足小数位用0补全
     *
     * @param v     需要格式化的数字
     * @param scale 小数点后保留几位
     * @return
     */
    public static String roundByScale(String v, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException(
                    "The scale must be a positive integer or zero");
        }
        double str = Double.parseDouble(v);
        if (scale == 0) {
            return new DecimalFormat("0").format(str);
        }
        String formatStr = "0.";
        for (int i = 0; i < scale; i++) {
            formatStr = formatStr + "0";
        }
        return new DecimalFormat(formatStr).format(str);
    }

    public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
        int length = chargeInfo.length();

        BigDecimal sumamont = chargeInfo.getJSONObject(length - 1)
                .getBigDecimal("sumamount");
        BigDecimal sumamont1 = chargeInfo.getJSONObject(length - 1)
                .getBigDecimal("sumamount");

        BigDecimal[] stairPrice = new BigDecimal[length - 1];
        BigDecimal[] stairAmount = new BigDecimal[length - 2];
        BigDecimal[] stairFee = new BigDecimal[length - 1];
        BigDecimal[] stairNum = new BigDecimal[length - 1];
        BigDecimal[] stairSurplus = new BigDecimal[length - 2];

        JSONObject ret = new JSONObject();
        BigDecimal chargenum = new BigDecimal(0);
        BigDecimal oughtamount = new BigDecimal(0);

        for (int i = 0; i < length - 1; i++) {
            stairPrice[i] = new BigDecimal(0);
            stairFee[i] = new BigDecimal(0);
            stairNum[i] = new BigDecimal(0);
        }

        for (int i = 0; i < length - 2; i++) {
            stairAmount[i] = new BigDecimal(0);
            stairSurplus[i] = new BigDecimal(0);
        }

        int start = 0;
        int end = 0;
        int i = 0;
        for (; i < length - 2; i++) {
            stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");
            stairAmount[i] = chargeInfo.getJSONObject(i)
                    .getBigDecimal("amount");

            if (sumamont.compareTo(stairAmount[i]) >= 0) {
                start = i + 1;
            }
        }

        stairPrice[i] = chargeInfo.getJSONObject(i).getBigDecimal("price");

        for (i = start; i < stairAmount.length; i++) {
            if (stairAmount[i].subtract(sumamont).multiply(stairPrice[i])
                    .compareTo(fee) >= 0) {
                stairNum[i] = fee.divide(stairPrice[i], 10, 4);

                stairFee[i] = stairNum[i].multiply(stairPrice[i])
                        .setScale(4, 4);

                for (int j = 0; j < i; j++) {
                    stairSurplus[j] = BigDecimal.ZERO;
                    ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
                }

                stairSurplus[i] = stairAmount[i].subtract(stairNum[i])
                        .subtract(sumamont);

                ret.put("f_stair" + (i + 1) + "surplus", stairSurplus[i]);

                for (int j = i + 1; j < stairAmount.length; j++) {
                    stairSurplus[j] = stairAmount[j]
                            .subtract(stairAmount[(j - 1)]);

                    ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
                }

                break;
            }
            stairNum[i] = stairAmount[i].subtract(sumamont);
            stairFee[i] = stairNum[i].multiply(stairPrice[i]).setScale(4, 4);

            fee = fee.subtract(stairFee[i]);
            sumamont = stairAmount[i];
        }

        stairNum[i] = fee.divide(stairPrice[i], 10, 4);
        stairFee[i] = fee;

        JSONArray array = new JSONArray();
        for (i = 0; i < length - 1; i++) {
            chargenum = chargenum.add(stairFee[i]);
            oughtamount = oughtamount.add(stairNum[i]);
            ret.put("f_stair" + (i + 1) + "fee", stairFee[i]);
            ret.put("f_stair" + (i + 1) + "amount", stairNum[i]);
            ret.put("f_stair" + (i + 1) + "price", stairPrice[i]);

            JSONObject json = new JSONObject();
//            json.put("f_price_name", "阶梯" + (i + 1));
            json.put("f_price", stairPrice[i]);
            json.put("f_gas", stairNum[i]);
            json.put("f_money", stairFee[i]);
            array.put(json);
        }

        for (i = 0; i < stairAmount.length; i++) {
            ret.put("f_stair" + (i + 1) + "ceiling", stairAmount[i]);
        }
        int j;
        try {
            ret.get("f_stair1surplus");
        } catch (Exception e) {
            j = 0;
        }
        for (j = 0; j < stairSurplus.length; j++) {
            ret.put("f_stair" + (j + 1) + "surplus", stairSurplus[j]);
        }

        double chargeNumValue = formatNumber(chargenum);
        ret.put("chargenum", chargeNumValue);
        ret.put("sumamount", formatNumber(sumamont1));
        ret.put("gas", formatNumber(oughtamount));
        ret.put("chargeprice", array);

        return ret;
    }

    public double formatNumber(BigDecimal bigDecimal) {
        NumberFormat nf = NumberFormat.getInstance();
        nf.setGroupingUsed(false);
        nf.setMinimumFractionDigits(2);
        nf.setMaximumFractionDigits(8);
        String scoreStr = nf.format(bigDecimal.doubleValue());
        return Double.parseDouble(scoreStr);
    }

    /**
     * 根据阶梯名字返回发票用商品名字
     *
     * @param price 需要格转换得气价名称
     * @return 返回结果
     */
    public static String converPrice(String price) {
        if (Objects.equals(price, "阶梯一") || Objects.equals(price, "第一档") || Objects.equals(price, "阶梯1")) {
            return "阶梯气价一";
        } else if (Objects.equals(price, "阶梯二") || Objects.equals(price, "第二档") || Objects.equals(price, "阶梯2")) {
            return "阶梯气价二";
        } else if (Objects.equals(price, "固定气价")) {
            return "固定气价";
        } else if (Objects.equals(price, "滞纳金")) {
            return "滞纳金";
        } else {
            return "阶梯气价三";
        }
    }

    public JSONArray checkStair(JSONArray jsonArray) {
        JSONObject groupObj = new JSONObject();
        for (int i = 0; i < jsonArray.length(); i++) {
            if (groupObj.has(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString())) {
                // 如果有 获取气量金额
                BigDecimal gas = groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString()).getBigDecimal("f_gas");
                BigDecimal money = groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString()).getBigDecimal("f_money");
                //  气量金额与本次对象相加
                gas = gas.add(jsonArray.getJSONObject(i).getBigDecimal("f_gas"));
                money = money.add(jsonArray.getJSONObject(i).getBigDecimal("f_money"));
                // 新的金额气量push
                groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString())
                        .put("f_gas", gas);
                groupObj.getJSONObject(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString())
                        .put("f_money", money);
            } else {
                groupObj.put(jsonArray.getJSONObject(i).getBigDecimal("f_price").toString(), jsonArray.getJSONObject(i));
            }
        }
        // 遍历出来groupObj
        JSONArray result = new JSONArray();
        for (String str : groupObj.keySet()) {
            if (groupObj.getJSONObject(str).getBigDecimal("f_money").compareTo(BigDecimal.ZERO) == 0
                    && groupObj.getJSONObject(str).getBigDecimal("f_gas").compareTo(BigDecimal.ZERO) == 0) {
                continue;
            }
            groupObj.getJSONObject(str).put("f_gas", groupObj.getJSONObject(str).getBigDecimal("f_gas").setScale(8, RoundingMode.HALF_UP));
            result.put(groupObj.getJSONObject(str));
        }
        return result;
    }

    public static JSONObject getConfigValue(JSONObject config, String key) {
        Iterator<String> var2 = config.keySet().iterator();
        String keysItem;
        do {
            if (!var2.hasNext()) {
                return new JSONObject("{nosuch:true}");
            }
            keysItem = var2.next();
        } while (!keysItem.contains(key));
        return config.getJSONObject(keysItem);
    }

}
