package util;


import com.af.plugins.JsonTools;
import com.alibaba.druid.util.StringUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.log4j.Logger;
import org.json.JSONObject;

import java.io.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author llz
 * @ClassName FTPUtil
 * @Description FTP工具类  上传    下载
 * @date 2021/11/3014:13
 */
public class FTPUtil {
//    public static void main(String[] args) {
//        JSONObject json = new JSONObject();
//        json.put("ip", "127.0.0.1");
//        json.put("port", "21");
//        json.put("userName", "bank");
//        json.put("passWord", "000000");
//        String fileName = "1003.ICBC095588.20201211";
//        String dirPath = "/2/3/1";
//        try {
//            FileOutputStream out = new FileOutputStream("D:\\下载1003.ICBC095588.20201211");
////            FileInputStream in = new FileInputStream("D:\\Desktop\\bankTest\\2007.ICBC095588.20201213");
////            upLoad(json.toString(), fileName,dirPath,in);
//            //  filesName  下载的文件名    dirpath  文件所有FTP文件夹路径   文件存放路径 可指定文件名
////            downLoad( fileName,dirPath,out);
//        } catch (FileNotFoundException e) {
//            e.printStackTrace();
//        }
//    }


    /**
     * 日志对象
     */
    private static final Logger log = Logger.getLogger(FTPUtil.class);
    /**
     * 设置缓冲区大小
     */
    private static int BUFFER_SIZE = 1024 * 1024 * 4;
    /**
     * 本地字符编码
     */
    private static String LOCAL_CHARSET = "GBK";

    /**
     * UTF-8字符编码
     */
    private static final String CHARSET_CHARSET = "UTF-8";

    /**
     * OPTS UTF-8 字符串常量
     */
    private static final String OPTS_UTF8 = "OPTS UTF-8";

    /**
     * FTP协议里面规定文件名编码为iso-8859-1
     */
    private static final String SERVER_CHARSET = "ISO-8859-1";
    private static FTPClient ftpClient = null;

    /**
     * 获取FTP相关地址
     */
    private static final JSONObject PATH = JsonTools.readJsonFile("bankDown.json").getJSONObject("path");
    /**
     * 下载文件本地保存地址
     */
    private static final String FILE_LOCAL_SAVE_PATH = String.valueOf(PATH.get("fileLocalSavePath"));
    /**
     * ftp被下载文件放置目录
     */
    private static final String FTP_FILE_DIR_PATH = String.valueOf(PATH.get("ftpFileDirPath"));
    /**
     * 被上传文件放置目录
     */
    private static final String FTP_UP_FILE_DIR_PATH = String.valueOf(PATH.get("ftpUpFileDirPath"));


    /**
     * 连接ftp服务器
     *
     * @return
     */
    public static void login() {
        JSONObject ft = JsonTools.readJsonFile("bankDown.json").getJSONObject("FTPInfo");
        ftpClient = new FTPClient();
        try {
            //连接ftp服务
            ftpClient.connect(String.valueOf(ft.get("ip")), Integer.parseInt(String.valueOf(ft.get("port"))));
            //登录
            ftpClient.login(String.valueOf(ft.get("userName")), String.valueOf(ft.get("passWord")));
            ftpClient.setBufferSize(BUFFER_SIZE);
            ftpClient.setFileType(FTPClient.BINARY_FILE_TYPE);
            log.info("FTP服务连接成功！");
            int reply = ftpClient.getReplyCode();
            if (!FTPReply.isPositiveCompletion(reply)) {
                closeConnect();

            }

        } catch (Exception e) {
            log.error("连接FTP服务器失败,请检查连接环境。" + e);
            throw new RuntimeException(e);
        }


    }

    /**
     * 关闭FTP连接
     */
    public static void closeConnect() {
        if (ftpClient != null && ftpClient.isConnected()) {
            try {
                ftpClient.logout();
            } catch (Exception var) {
                log.error("FTP服务异常！", var);
            }
        }
    }

    /**
     * FTP 服务器路径转换
     *
     * @param ftpPath FTP服务器路径
     * @return String
     */
    public static String changeEncoding(String ftpPath) {
        String directory = null;
        try {
            if (FTPReply.isPositiveCompletion(ftpClient.sendCommand(OPTS_UTF8, "ON"))) {
                LOCAL_CHARSET = CHARSET_CHARSET;
            }
            directory = new String(ftpPath.getBytes(LOCAL_CHARSET), SERVER_CHARSET);
        } catch (Exception e) {
            log.error("", e);
        }
        return directory;
    }

    /**
     * 改变工作目录  如果没有  则创建工作目录
     *
     * @param path
     */
    public static void changeAndMakeWorkingDir(String path) {
        try {
            ftpClient.changeWorkingDirectory("/");
            path = path.replaceAll("\\\\", "/");
            String[] path_array = path.split("/");
            for (String s : path_array) {
                boolean b = ftpClient.changeWorkingDirectory(s);
                if (!b) {
                    ftpClient.makeDirectory(s);
                    ftpClient.changeWorkingDirectory(s);
                }
            }
        } catch (IOException e) {
            log.error("", e);
            throw new RuntimeException(e);
        }
    }

    /**
     * 上传
     *
     * @param fileName 上传的文件名
     * @param filePath 上传的文件路径
     */
    public static boolean upLoad(String fileName, String filePath) {
        //登录
        login();
        FileInputStream in = null;
        //如果连接断开
        if (!ftpClient.isConnected()) {
            return false;
        }
        //定义返回参数
        boolean isSuccess = false;

        if (ftpClient != null) {
            try {
                File file;
                in = new FileInputStream(filePath + "\\" + fileName);
                if (FTPReply.isPositiveCompletion(ftpClient.sendCommand("OPTS_UTF8", "ON"))) {
                    LOCAL_CHARSET = CHARSET_CHARSET;
                }
                ftpClient.setControlEncoding(LOCAL_CHARSET);
                String path = changeEncoding(FTP_UP_FILE_DIR_PATH);
                changeAndMakeWorkingDir(FTP_FILE_DIR_PATH);
                isSuccess = ftpClient.storeFile(new String(fileName.getBytes(), SERVER_CHARSET), in);
            } catch (Exception var) {
                log.error("文件上传失败", var);
            } finally {
                closeConnect();
            }
        }
        return isSuccess;

    }


    /**
     * 下载
     *
     * @param filename 下载的文件名
     */
    public static void downLoad(String filename) {
        //登录
        login();
        FileOutputStream out = null;
        if (ftpClient != null) {
            try {
                out = new FileOutputStream(FILE_LOCAL_SAVE_PATH + "\\" + filename);
                String path = changeEncoding(FTP_FILE_DIR_PATH);
                if (!ftpClient.changeWorkingDirectory(path)) {
                    log.error("该目录不存在,filePath=" + FTP_FILE_DIR_PATH);
                }
                String[] fileNames = ftpClient.listNames();
                if (fileNames == null || fileNames.length == 0) {
                    return;
                }
                for (String fileName : fileNames) {
                    String ftpName = new String(fileName.getBytes(SERVER_CHARSET), LOCAL_CHARSET);
                    if (StringUtils.equals(ftpName, filename)) {
                        InputStream in = ftpClient.retrieveFileStream(fileName);
                        IOUtils.copy(in, out);
                    }
                }
            } catch (Exception var) {
                log.error("文件下载失败！", var);
            } finally {
                closeConnect();
            }
        }
    }

    /**
     * 通过字符串模糊查询文件名
     *
     * @param date
     * @return
     */
    public static String queryFile(String date) {
        FTPFile[] files = null;
        String fileName = "";
        try {
            login();
            if (!ftpClient.changeWorkingDirectory(FTP_FILE_DIR_PATH)) {
                log.error("该目录不存在,filePath=" + FTP_FILE_DIR_PATH);
            }
            ftpClient.enterLocalPassiveMode();
            files = ftpClient.listFiles();
            for (int i = 0; i < files.length; i++) {
                if (files[i].getName().contains(date)) {
                    fileName = files[i].getName();
                }
            }

        } catch (Exception e) {
            log.error("读取FTP对账文件失败！", e);


        } finally {
            closeConnect();
        }
        return fileName;


    }


}
