package util;

import com.alibaba.excel.EasyExcel;
import org.json.JSONArray;
import com.aote.rs.mapper.WebException;
import java.util.List;
import java.util.Map;

/**
 *
 * @create 2022-09-15 14:07:54
 **/
public class ExcelReadUtil {
    public JSONArray read(String filepath) {
        //判断路径
        filepath = filepath.replace("\\", "/");
        String fileName = filepath.split("/")[filepath.split("/").length - 1];

        List<Map> data = null;
        if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
            data = EasyExcel.read(filepath).sheet(0).doReadSync();
        } else {
            throw new WebException(500, "非excel文件暂时未作处理.如有需求,请联系开发人员!!!!");
        }
        return new JSONArray(data);
    }
}
