package util;

import org.json.JSONArray;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAdjusters;

public class DateProcess {

    /**
     * 判断是否在时间之后
     * @param date
     * @param add
     * @param forMate
     * @return
     */
    public boolean isAfter(String date,Integer add,String forMate){
        if(date == null || add == null){
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);

        return LocalDateTime.now().isAfter(parse.plusMonths(add));
    }

    /**
     * 判断时间是否是今天
     * @param date
     * @param forMate
     * @return
     */
    public boolean isToday(String date,String forMate){
        if(date.equals("null")){
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDate parse = LocalDateTime.parse(date, dtf).toLocalDate();

        return LocalDate.now().isEqual(parse);
    }

    /**
     * 判断是否在时间之后
     * @param oneDate  yyyy-MM-dd HH:mm:ss
     * @param twoDate  yyyy-MM-dd
     * @return
     */
    public boolean isAfter(String oneDate,String twoDate){
        DateTimeFormatter df1 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        DateTimeFormatter df2 = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        LocalDate one = LocalDateTime.parse(oneDate, df1).toLocalDate();
        LocalDate two = LocalDate.parse(twoDate, df2);
        return one.isAfter(two);
    }

    public int getOne(String date,String key){
        LocalDateTime dateTime = LocalDateTime.parse(date,DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        int res = -1;
        switch (key){
            case "year":
                res = dateTime.getYear();
                break;
            case "month":
                res = dateTime.getMonthValue();
                break;
            case "day":
                res = dateTime.getDayOfMonth();
                break;
            case "hour":
                res = dateTime.getHour();
                break;
            case "minute":
                res = dateTime.getMinute();
                break;
            case "second":
                res = dateTime.getSecond();
                break;
            default:
                res = -1;
        }
        return res;
    }



    /**
     * 传入时间 返回增加后的时间
     * @param date
     * @param add
     * @param forMate
     * @return
     */
    public String addDate(String date,Integer add,String forMate){
        if (date==null){
            return null;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return parse.plusMonths(add).format(dtf);

    }

    /**
     * 判断传入时间加上周期是否是本月
     * @param date  传入时间
     * @param period  周期
     * @param forMate  时间格式
     * @return
     */
    public boolean isDoIt(String date,String period,String forMate){
        if(date == null || period == null){
            return false;
        }
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern(forMate);
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        LocalDateTime now = LocalDateTime.now();
        parse = parse.plusMonths(Integer.parseInt(period));
        return now.getYear() == parse.getYear() && now.getMonth() == parse.getMonth() && now.getDayOfMonth() == parse.getDayOfMonth();
    }

    /**
     * 获取本月第一天(数据库格式)
     * @return
     */
    public String getNowMonthFirst(){
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
    /**
     * 获取本月最后一天(数据库格式)
     * @return
     */
    public String getNowMonthLast(){
        return LocalDateTime.of(LocalDateTime.now().with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    /**
     * 获取昨天月第一天(数据库格式)
     * @return
     */
    public String getYesterdayMonthFirst(){
        return LocalDateTime.of(LocalDateTime.now().plusDays(-1).with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }
    /**
     * 获取昨天月最后一天(数据库格式)
     * @return
     */
    public String getYesterdayMonthLast(){
        return LocalDateTime.of(LocalDateTime.now().plusDays(-1).with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }


    /**
     * 获取传入时间第一天(数据库格式)
     * @return
     */
    public String getMonthFirst(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.firstDayOfMonth()).toLocalDate(), LocalTime.MIN).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    public String getMonthLast(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, dtf);
        return LocalDateTime.of(parse.with(TemporalAdjusters.lastDayOfMonth()).toLocalDate(), LocalTime.MAX).format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
    }

    /**
     * 获取传入月份的事件转为正常时间格式
     * @param date
     * @return
     */
    public String yearMonthFormatterDate(String date){
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM");
        DateTimeFormatter ove = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDate.parse(date, dtf).atStartOfDay();
        return parse.format(ove);
    }
    /**
     * 获取当天开始的时间
     * @return
     */
    public String getTodayStart(){
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now(),LocalTime.MIN);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    /**
     * 获取当天最后的时间
     * @return
     */
    public String getTodayEnd(){
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now(),LocalTime.MAX);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    /**
     * 获取昨天开始的时间
     * @return
     */
    public String getYesterdayStart(){
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now().plusDays(-1),LocalTime.MIN);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    /**
     * 获取昨天最后的时间
     * @return
     */
    public String getYesterdayEnd(){
        LocalDateTime today_start = LocalDateTime.of(LocalDate.now().plusDays(-1),LocalTime.MAX);
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(today_start);
    }

    /**
     * 获取当前时间
     * @return
     */
    public String now(){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        return df.format(LocalDateTime.now());
    }

    /**
     * 获取当天年份的第一天
     * @return
     */
    public String getNowYearStart(){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate firstDayOfYear = LocalDate.now().with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime firstDateOfYear = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return df.format(firstDateOfYear);
    }
    /**
     * 获取当天年份的最后一天
     * @return
     */
    public String getNowYearEnd(){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate lastDayOfYear = LocalDate.now().with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime lastDateOfYear = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return df.format(lastDateOfYear);
    }



    /**
     * 获取昨天年份的第一天
     * @return
     */
    public String getYesterdayYearStart(){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate firstDayOfYear = LocalDate.now().plusDays(-1).with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime firstDateOfYear = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return df.format(firstDateOfYear);
    }
    /**
     * 获取昨天年份的最后一天
     * @return
     */
    public String getYesterdayYearEnd(){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDate lastDayOfYear = LocalDate.now().plusDays(-1).with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime lastDateOfYear = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return df.format(lastDateOfYear);
    }

    /**
     * 获取传入时间年份的第一天
     * @return
     */
    public String getYearStart(String date){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, df);
        LocalDate firstDayOfYear = parse.toLocalDate().with(TemporalAdjusters.firstDayOfYear());
        LocalDateTime firstDateOfYear = LocalDateTime.of(firstDayOfYear, LocalTime.MIN);
        return df.format(firstDateOfYear);
    }
    /**
     * 获取传入时间年份的最后一天
     * @return
     */
    public String getYearEnd(String date){
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        LocalDateTime parse = LocalDateTime.parse(date, df);
        LocalDate lastDayOfYear = parse.toLocalDate().with(TemporalAdjusters.lastDayOfYear());
        LocalDateTime lastDateOfYear = LocalDateTime.of(lastDayOfYear, LocalTime.MAX);
        return df.format(lastDateOfYear);
    }


}
