package util;

import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * @Classname ChargePriceCalculator
 * @Description TODO 闻喜差额计算
 * @Date 2023/3/29 15:55
 * @Created by 张振宇
 */


public class ChargePriceCalculator {

    public static JSONObject calculate(JSONObject chargeprice) {
        JSONArray jsonArray = chargeprice.getJSONArray("chargeprice");

        // 计算补差金额并插入到每个JSON对象中
        for (Object element : jsonArray) {
            JSONObject jsonObject = (JSONObject) element;
            double f_price = jsonObject.optDouble("f_price", 0);
            if (f_price == Math.floor(f_price * 100) / 100) {
                // f_price不是四位小数
                jsonObject.put("correction_amount", 0);
            } else {
                // f_price是四位小数
                double f_gas = jsonObject.optDouble("f_gas", 0);
                double f_money = jsonObject.optDouble("f_money", 0);
                double correctionAmount = f_money - (f_gas * Math.floor(f_price * 100) / 100);
                jsonObject.put("correction_amount", new BigDecimal(correctionAmount).setScale(4, RoundingMode.HALF_UP));
            }
        }

        // 计算补差金额的合并并插入到JSON对象中
        double totalCorrectionAmount = 0;
        for (Object element : jsonArray) {
            JSONObject jsonObject = (JSONObject) element;
            totalCorrectionAmount += jsonObject.optDouble("correction_amount", 0);
            chargeprice.put("total_correction_amount", new BigDecimal(totalCorrectionAmount).setScale(4, RoundingMode.HALF_UP));
        }
        return chargeprice;
    }

    public static void main(String[] args) {
        String jsonStr = "{\"f_stair_gas4\":0,\"f_stair_gas2\":12.0012,\"f_stair_gas3\":0,\"f_stair_price3\":4,\"f_stair_money4\":0,\"f_stair_price2\":3.7213,\"f_stair_money3\":0,\"f_stair_money2\":44.66,\"f_stair_money1\":0,\"f_stair_price4\":0,\"f_stair_price1\":2.7229,\"f_stair_gas1\":0}";
        System.out.println(calculate(new JSONObject(jsonStr)));
    }

}
