package util;
import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;

import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;

import java.io.*;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @description:
 * @author: 唐梓烨
 * @time: 2022/11/9 18:18
 */
public class Base64ToFile {
    private static final Logger LOGGER = Logger.getLogger(Base64ToFile.class);

    public static void main(String[] args) throws IOException {
        String proPath = System.getProperty("user.dir");
        System.out.println(proPath);
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "/file.properties");
        pro.load(in);
        String path = pro.getProperty("uploadFilepath");
        System.out.println(path);
        in.close();
    }

    public JSONArray upload(JSONObject paramDate) {
        JSONArray fileArray = paramDate.getJSONArray("files");
        JSONArray filepathArray = new JSONArray();
        if (fileArray.length() > 0) {
            for (int i = 0; i < fileArray.length(); i++) {
                try {
                    JSONObject jsonObject = fileArray.getJSONObject(i);
                    String postResult = RestTools.post("http://111.22.143.171:8400/DockingAPI/EstateInterface/GetFileStream?fileId="+jsonObject.get("fileId"));
                    if (postResult != null && !"".equals(postResult)) {
                        JSONObject resultData = new JSONObject(postResult);
                        DateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
                        Date date = new Date();
                        String updateDate = dateFormat.format(date);
                        System.out.println("返回值："+resultData);
                        boolean isSuccessed = resultData.getBoolean("IsSuccessed");
                        if (isSuccessed) {
                            try {
                                //真实路径
                                JSONObject fileParam = new JSONObject();
                                String message = resultData.getString("Message");
                                String username = paramDate.getString("f_newuser_name");
                                String fileName = jsonObject.getString("filename");
                                String suffix = jsonObject.getString("filetype");
                                fileName += "_" + username + "_" + updateDate + "." + suffix;
                                if (paramDate.has("f_userinfo_id")) {
                                    fileParam.put("f_blobid", paramDate.get("f_userinfo_id"));
                                }
                                if (paramDate.has("f_businessid")) {
                                    if (paramDate.get("f_businessid") != null && !"".equals(((String) paramDate.get("f_businessid")).trim())) {
                                        fileParam.put("f_businessid", paramDate.get("f_businessid"));
                                    }
                                }
                                if (paramDate.has("f_newuser_name")) {
                                    fileParam.put("f_username", paramDate.get("f_newuser_name"));
                                }
                                try {
                                    base64ToFile(message, fileName);
                                } catch (Exception e) {
                                    LOGGER.error("解析保存附件出错", e);
                                }
                                String realPath = getPath("uploadFilepath") + File.separator + getNowDate();
                                String downloadpath = realPath + File.separator + fileName;
                                fileParam.put("f_filename", fileName);
                                fileParam.put("f_filetype", suffix);
                                fileParam.put("f_downloadpath", downloadpath);
                                fileParam.put("f_realpath", getPath("uploadFilepath"));
                                filepathArray.put(fileParam);
                            } catch (Exception e) {
                                LOGGER.error("获取Base64资源文件错误", e);
                            }
                        }
                    }
                } catch (Exception e) {
                    LOGGER.error("解析文件出错", e);
                }

            }

        }
        return filepathArray;

    }

    /**
     * 文件流转换成Base4
     */
    public static String fileToBase64(String path) {
        String base64 = null;
        InputStream in = null;
        try {
            File file = new File(path);
            in = new FileInputStream(file);
            byte[] bytes = new byte[(int) file.length()];
            in.read(bytes);
            base64 = Base64.getEncoder().encodeToString(bytes);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (in != null) {
                try {
                    in.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return base64;
    }

    /**
     * Base64解码成File文件
     */
    public void base64ToFile(String base64, String fileName) {
        File file = null;
        String realPath = "";
        try {
            realPath = getPath("uploadFilepath") + File.separator + getNowDate();
        } catch (IOException e) {
            LOGGER.error("找不到路径", e);
        }
        File dir = new File(realPath);
        if (!dir.exists() && !dir.isDirectory()) {
            dir.mkdirs();
        }
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        byte[] bytes = Base64.getDecoder().decode(base64);
        file = new File(realPath + File.separator + fileName);
        try {
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        } catch (Exception e) {
            e.printStackTrace();
        } finally {
            if (bos != null) {
                try {
                    bos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getPath(String pathname) throws IOException {
        String proPath = System.getProperty("user.dir");
        System.out.println(proPath);
        Properties pro = new Properties();
        FileInputStream in = new FileInputStream(proPath + "/file.properties");
        pro.load(in);
        String path = pro.getProperty(pathname);
        System.out.println(path);
        in.close();
        return path;
    }

    private String getNowDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        return sdf.format(new Date());
    }
    public static  String doPost(String url, JSONObject param) throws IOException, URISyntaxException {
        // 创建Httpclient对象
        CloseableHttpClient httpclient = HttpClients.createDefault();
        // 创建http POST请求
        // 设置post参数
        ArrayList<NameValuePair> parameters = new ArrayList<>();
        Iterator<String> keys = param.keys();
        if (keys.hasNext()){
            System.out.println(keys.next());
            System.out.println("是多少"+param.getInt(keys.next()));
            parameters.add(new BasicNameValuePair(keys.next(),""+param.getInt(keys.next())));
        }
        URI uri = new URIBuilder(url).setParameters(parameters).build();
        HttpPost httpPost = new HttpPost(uri);

        // 构造一个form表单式的实体
        //UrlEncodedFormEntity formEntity = new UrlEncodedFormEntity(parameters);
        // 将请求实体设置到httpPost对象中
        //httpPost.setEntity(formEntity);
        //伪装浏览器
        httpPost.setHeader("User-Agent",
                "Mozilla/5.0 (Windows NT 6.1; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/56.0.2924.87 Safari/537.36");
        CloseableHttpResponse response = null;
        try {
            // 执行请求
            response = httpclient.execute(httpPost);
            // 判断返回状态是否为200
            if (response.getStatusLine().getStatusCode() == 200) {
                String content = EntityUtils.toString(response.getEntity(), "UTF-8");
                System.out.println(content);
                return content;
            }
        } finally {
            if (response != null) {
                response.close();
            }
            httpclient.close();
        }
        return "";
    }
}
