package timer;

import com.af.plugins.RestTools;
import com.aote.rs.LogicService;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;

public class UpdateHandplanByPhoneHand {

    @Autowired
    private LogicService logicService;

    public  void updateNew() throws Exception {
//        代理转发请求进行事务隔离，每次500条，通过SQL控制
        String str = RestTools.post("/rs/sql/updateHandTotalData",
                        new JSONObject().put("data",new JSONObject()));
        JSONArray  handstr =new JSONArray(str);
        handstr.forEach(hand -> {
            try {
                RestTools.post("/rs/logic/UpdateHandplanByPhoneHandOneUser", hand.toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
    public  void update() throws Exception {
        // 获取前一天的时间并组织条件
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("dateCondition",getDateCondition("day"));
        logicService.xtSave("UpdateHandplanByPhoneHand", new JSONObject().put("data",jsonObject).toString());
    }

    public static String getDateCondition(String type) {
        StringBuilder sb = new StringBuilder();
        Date date = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        Calendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        sb.append(" between ").append("'");
        if ("day".equals(type)) {
            calendar.add(Calendar.DATE, -1);//把日期往前减少一天，若想把日期向后推一天则将负数改为正数
            sb.append(df.format(calendar.getTime())).append(" 00:00:00").append("'")
                    .append(" and ").append("'");
            // 解除注释即昨天致今天得
            calendar.add(Calendar.DATE, 0);
            sb.append(df.format(calendar.getTime()));
        } else if ("year".equals(type)) {
            String Vbatchcode = String.valueOf(Calendar.getInstance().get(Calendar.YEAR));
            return Vbatchcode;
        } else if ("month".equals(type)) {
            calendar.set(Calendar.DAY_OF_MONTH, 0);
            sb.append(df.format(calendar.getTime()).substring(0, 8)).append("01").append(" 00:00:00").append("'")
                    .append(" and ").append("'").append(df.format(calendar.getTime()));
        }
        sb.append(" 23:59:59").append("'");
        return sb.toString();
    }
}
