package product;

import java.math.BigDecimal;

import org.json.JSONArray;
import org.json.JSONObject;

public class ReCharge {
	/**
	 * 判断重新抄表时未使用的气量在各收费中占多少
	 * @param arr
	 * @param realgas
	 * @return
	 */
	public JSONArray checkRecharge(JSONArray arr, BigDecimal realgas) {
		BigDecimal calgas = realgas;
		for (int i = 0; i < arr.length(); i++) {
			JSONObject o = arr.getJSONObject(i);
			BigDecimal realsurgas = calgas.subtract(o.getBigDecimal("f_pregas"));
			if (realsurgas.compareTo(BigDecimal.ZERO) > 0) {
				o.put("f_surplus_gas", o.getBigDecimal("f_pregas"));
				calgas = calgas.subtract(o.getBigDecimal("f_pregas"));
			} else {
				o.put("f_surplus_gas", calgas);
				calgas = BigDecimal.ZERO;
			}
		}
		return arr;
	}
	/**
	 * 重新进行划价
	 * @param sell
	 * @param chargearr
	 * @param pricearr
	 * @return
	 */
	public JSONObject reChargeDetail(JSONObject sell, JSONArray chargearr, JSONArray pricearr) {
		// 判断现价和旧价哪个阶梯高，固定算一阶
		if (chargearr.length() > pricearr.length() && pricearr.length() == 1) {
			for (int i = pricearr.length(); i < chargearr.length(); i++) {
				pricearr.put(pricearr.getJSONObject(0));
			}
		} else if (chargearr.length() < pricearr.length() && chargearr.length() == 1) {
			//旧价阶梯低，补齐，即为固定换阶梯
			JSONObject charge = chargearr.getJSONObject(0);
			charge.put("f_gas", BigDecimal.ZERO);
			for (int i = chargearr.length(); i < pricearr.length(); i++) {
				chargearr.put(charge);
			}
		} else {
			// 相等不处理
		}
		// 将新价格插入就划价明细中
		for (int i = 0; i < chargearr.length(); i++) {
			JSONObject charge = chargearr.getJSONObject(i);
			charge.put("f_old_price", charge.getBigDecimal("f_price"));
			charge.put("f_old_money", charge.getBigDecimal("f_money"));
			for (int j = 0; j < pricearr.length(); j++) {
				if (i == j) {
					charge.put("f_new_price", pricearr.getJSONObject(j).getBigDecimal("f_price"));
				}
			}
		}
		
		// 重新进行划价
		JSONObject result = new JSONObject();
		BigDecimal calgas = sell.getBigDecimal("f_surplus_gas");
		BigDecimal surfee = BigDecimal.ZERO;
		for (int i = 0; i < chargearr.length(); i++) {
			JSONObject o = chargearr.getJSONObject(i);
			if (calgas.subtract(o.getBigDecimal("f_gas")).compareTo(BigDecimal.ZERO) >= 0) {
				// 插入要进行计算的气量
				o.put("f_surplus_gas", o.getBigDecimal("f_gas"));
				// 如果补差气量大于等于当时的划价气量，全部按新价格进行重新划价，并插入最后结果
				BigDecimal realsurfee = o.getBigDecimal("f_gas").multiply(o.getBigDecimal("f_new_price"));
				o.put("f_new_money", realsurfee);
				// 重新计算补差气量
				calgas = calgas.subtract(o.getBigDecimal("f_gas"));
				surfee = surfee.add(realsurfee.subtract(o.getBigDecimal("f_money")));
				o.put("f_sur_money", realsurfee.subtract(o.getBigDecimal("f_money")));
			} else {
				// 插入要进行计算的气量
				if (calgas.compareTo(BigDecimal.ZERO) > 0) {
					o.put("f_surplus_gas", calgas);
					// 如果补差气量大于等于当时的划价气量，全部按新价格进行重新划价，并插入最后结果
					BigDecimal realsurfee = ((o.getBigDecimal("f_gas").subtract(calgas)).multiply(o.getBigDecimal("f_old_price")).add(calgas.multiply(o.getBigDecimal("f_new_price"))));
					o.put("f_new_money", realsurfee);
					// 补差气量已经计算完毕 ,置零
					calgas = BigDecimal.ZERO;
					surfee = surfee.add(realsurfee.subtract(o.getBigDecimal("f_money")));
					o.put("f_sur_money", realsurfee.subtract(o.getBigDecimal("f_money")));
				}
			}
		}
		result.put("chargearr", chargearr);
		result.put("surfee", surfee);
		return result;
	}
}
