package product;

import java.sql.Types;

import org.hibernate.dialect.SQLServerDialect;
import org.hibernate.type.StandardBasicTypes;

public class MySqlServerDialect2 extends SQLServerDialect {
	public MySqlServerDialect2() {
		super();
		//对应hbibernate里面的数据类型，否则映射不正确！
		registerHibernateType(Types.NCHAR, StandardBasicTypes.CHARACTER.getName());
		registerHibernateType(Types.NCHAR, 1, StandardBasicTypes.CHARACTER.getName());
		registerHibernateType(Types.NCHAR, 255, StandardBasicTypes.STRING.getName());
		registerHibernateType(Types.NVARCHAR, StandardBasicTypes.STRING.getName());
		registerHibernateType(Types.LONGNVARCHAR, StandardBasicTypes.TEXT.getName());
		registerHibernateType(Types.NCLOB, StandardBasicTypes.CLOB.getName());
	}

	static int getLastIndexOfOrderBy(String sql){
		return sql.toLowerCase().lastIndexOf("order by ");
	}

	public String getLimitString(String querySelect, int offset, int limit ){
		int lastIndexOfOrderBy = getLastIndexOfOrderBy(querySelect);
		//　没有 order by 或第一页的情况下
		if(lastIndexOfOrderBy<0 || querySelect.endsWith(")") || offset==0) {
			return super.getLimitString(querySelect, 0, limit);
		} else {
			//取出 order by 语句
			String orderby = querySelect.substring(lastIndexOfOrderBy);
			//取出 from 前的内容
			int indexOfFrom = querySelect.toLowerCase().indexOf("from");
			String selectFld = querySelect.substring(0,indexOfFrom);
			//取出 from 语句后的内容
			String selectFromTableAndWhere = querySelect.substring(indexOfFrom, lastIndexOfOrderBy);
			String sql = "SELECT * FROM (" +
					selectFld +
					",ROW_NUMBER() OVER(" + orderby + ") AS _page_row_num_hb " +
					selectFromTableAndWhere + " ) temp " +
					" WHERE _page_row_num_hb BETWEEN " +
					(offset + 1) + " AND " + limit;
			return sql;
		}
	}
	//使offset 参数生效
	public boolean supportsLimitOffset(){
		return true;
	}
}
