package pay;

import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


import ccb.pay.api.util.CCBPayUtil;
import org.apache.http.client.methods.HttpPost;
import org.json.JSONObject;
import org.json.XML;
import org.springframework.stereotype.Component;
import org.xml.sax.InputSource;

import javax.ws.rs.WebApplicationException;
import java.io.*;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.*;
import com.af.plugins.RestTools;
import java.util.regex.Matcher;
import java.util.regex.Pattern;


public class CcbPay {
    public static void main(String[] args) {

        String appId = "8a81c1be7a81842a017a83a48aec0000";
        String appKey = "23a264d8b615479fbff6b4be9f378d57";
        String url = "https://api-mop.chinaums.com/v1/token/access";
        CcbPay c= new CcbPay();
        JSONObject payResult = c.getAccessToken(appId,appKey,url);

        JSONObject refund = new JSONObject();
        refund.put("url","https://api-mop.chinaums.com/v1/netpay/bills/refund");
        refund.put("Authorization","OPEN-ACCESS-TOKEN AccessToken=\""+payResult.getString("accessToken")+"\"");
        refund.put("requestTimestamp","2021-09-24 14:30:55");
        refund.put("mid","89837104900010M");
        refund.put("tid","86707116");
        refund.put("instMid","QRPAYDEFAULT");
        refund.put("refundAmount",280);
        refund.put("billNo","30SX202109141217530152636451");
        refund.put("billDate","2021-09-14");

        JSONObject payResult2 = c.getRefund(refund);
    }
    public static JSONObject getRefund(JSONObject refund){
        JSONObject data = new JSONObject();
        data.put("requestTimestamp",refund.getString("requestTimestamp"));
        data.put("mid",refund.getString("mid"));
        data.put("tid",refund.getString("tid"));
        data.put("instMid",refund.getString("instMid"));
        data.put("refundAmount",refund.getInt("refundAmount"));
        data.put("billNo",refund.getString("billNo"));
        data.put("billDate",refund.getString("billDate"));
        JSONObject Header = new JSONObject();
        Header.put("Authorization",refund.getString("Authorization"));
        System.out.println("1====:");
        System.out.println(data);
        System.out.println("2====:");
        System.out.println(Header);
        String response = RestTools.post(refund.getString("url"), data, Header);
        JSONObject jo = null;
        try{
            jo = new JSONObject(response);
        }catch(Exception e){
            throw new RuntimeException("未正常响应");
        }
        System.out.println(jo);
        return jo;
    }

    public static JSONObject getAccessToken(String appId,String appKey,String url) {
        String timestamp = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String nonce = getRandomStringWithLen(128);
        String signMethod = "SHA256";
        String plainText = appId+timestamp+nonce+appKey;
        String signature = SHA_256(plainText);
        JSONObject data = new JSONObject();
        data.put("appId",appId);
        data.put("timestamp",timestamp);
        data.put("nonce",nonce);
        data.put("signMethod",signMethod);
        data.put("signature",signature);
        System.out.println(data);
        String response = RestTools.post(url, data);
        JSONObject jo = null;
        try{
            jo = new JSONObject(response);
        }catch(Exception e){
            throw new RuntimeException("未正常响应");
        }
        System.out.println(jo);
        return jo;
    }
    private static  String SHA_256(String plainText)
    {
        MessageDigest messageDigest;
        try  {
            messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(plainText.getBytes());
            byte[] outputDigest_sign = messageDigest.digest();

            return HexStringUtil.bytetoHexString(outputDigest_sign);
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256编码异常");
        }
    }

    public static String getRandomStringWithLen(int len) {
        String base = "abcdefghijklmnopqrstuvwxyz0123456789";
        Random random = new Random();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < len; i++) {
            int number = random.nextInt(base.length());
            sb.append(base.charAt(number));
        }
        return sb.toString();
    }
    public static JSONObject urlPay(String url,JSONObject param){
        JSONObject payResult = null;
        try{
            payResult = new JSONObject();
            String useurl = "http://"+url;
            String response = RestTools.post(useurl, param);
            JSONObject jo = null;
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("未正常响应");
            }
            if(jo.isNull("result_msg") || jo.getString("result_msg").equals("支付确认失败")){
                // 支付失败不需要验签，直接返回失败即可
                throw new RuntimeException("支付失败，返回信息:" + jo.getString("err_msg"));
            }
            else if(jo.getString("result_msg").equals("支付结果未知")){
                payResult.put("code", 501);
                payResult.put("msg","支付状态待查询");
            }
            // 组织支付方式
            if(jo.getString("qrcodetype").equals("1")){
                payResult.put("f_bank_type","龙支付");
            }else if(jo.getString("qrcodetype").equals("2")){
                payResult.put("f_bank_type","微信");
            }else if(jo.getString("qrcodetype").equals("3")){
                payResult.put("f_bank_type","支付宝");
            }else{
                payResult.put("f_bank_type","未知");
            }
            payResult.put("qrcodetype",jo.getString("qrcodetype"));
            if(jo.getString("result_msg").equals("支付结果未知")){
                // 如果支付状态是待查询，此时直接返回即可
                payResult.put("f_out_trade_no",jo.getString("f_out_trade_no"));
                System.out.println("被扫支付结束，返回待查询或不确定:" + payResult.toString());
                return payResult;
            }else{
                payResult.put("code",200);
                payResult.put("f_out_trade_no",jo.getString("f_out_trade_no"));
                payResult.put("msg","支付确认成功");
            }
        }catch (Exception e) {
            System.out.println("被扫支付异常,异常信息:" + e.getMessage());
            payResult.put("code",500);
            payResult.put("msg",e.getMessage());
        }
        System.out.println("被扫支付结束，返回信息:" + payResult.toString());
        return payResult;
    }
    /**
     * 被扫支付轮询,调用微信的接口
     * @return
     */

    public static JSONObject urlqueryPay(String url,JSONObject param){
        JSONObject result = null;
        try{
            result = new JSONObject();
            String useurl = "http://"+url;
            String response = RestTools.post(useurl, param);
            JSONObject jo = null;
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("获取支付结果未正常响应");
            }
            result.put("code", 200);
            if (jo.getString("result_msg").equals("支付结果未知")){
                result.put("RESULT", "Q");
            }else if (jo.getString("result_msg").equals("支付确认成功")){
                result.put("RESULT", "Y");
            }else if (jo.getString("result_msg").equals("支付确认失败")){
                result.put("RESULT", "N");
            }
        }catch (Exception e) {
            System.out.println("轮询查询PAY101支付结果异常,异常信息:" + e.getMessage());
            result.put("code", 500);
            result.put("msg",e.getMessage());
        }
        System.out.println("轮询查询PAY101支付结果结束，返回信息:" + result.toString());
        return result;
    }
    public static String getNow(String format) {
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        return formatter.format(new Date());
    }
    public static String getNow2() {
        return getNow("yyyy-MM-dd");
    }
    /**
     * 被扫支付请求
     * @return
     */

    public JSONObject sweptPay(JSONObject config,JSONObject data) {
        JSONObject payResult = null;
        try {
            payResult = new JSONObject();
            Pattern pattern = Pattern.compile("\\d+(\\.\\d{1,2})?");// 金额正则,可以没有小数,小数最多不超过两位
            Matcher matcher = pattern.matcher(data.getDouble("amount") + "");
            if(!matcher.matches()){
                throw new RuntimeException("金额格式不正确，无法进行交易");
            }else if(data.getDouble("amount") <= 0){
                throw new RuntimeException("支付金额必须大于0");
            }
            String MERCHANTID = config.getString("MERCHANTID");// 商户号
            String POSID = config.getString("POSID");// 柜台号
            String BRANCHID = config.getString("BRANCHID");//分行号
            //  商户订单号,最长30位,建议按以下规则生成订单号：商户代码后9位+自定义字符串（不超21位）
            String ORDERID = data.getString("orderId");
            String AMOUNT= data.getDouble("amount") + "";// 付款金额，16位（带2位小数）
            String TXCODE="PAY100";// 交易码 固定值PAY100
            String MERFLAG = "1";// 商户类型 1：线上商户
            if(data.isNull("auth_code") || "".equals(data.getString("auth_code"))){
                throw new RuntimeException("付款码不能为空!");
            }
            String QRCODE = data.getString("auth_code"); // 付款码

            StringBuffer merInfo=new StringBuffer();
            merInfo.append("MERCHANTID=");
            merInfo.append(MERCHANTID);
            merInfo.append("&POSID=");
            merInfo.append(POSID);
            merInfo.append("&BRANCHID=");
            merInfo.append(BRANCHID);
            String merinfo = merInfo.toString();
            System.out.println(merinfo);

            StringBuffer tmp = new StringBuffer(); //验签字段
            tmp.append("MERFLAG=");
            tmp.append(MERFLAG);
            tmp.append("&TERMNO1=");
            tmp.append("");
            tmp.append("&TERMNO2=");
            tmp.append("");
            tmp.append("&ORDERID=");
            tmp.append(ORDERID);
            tmp.append("&QRCODE=");
            tmp.append(QRCODE);
            tmp.append("&AMOUNT=");
            tmp.append(AMOUNT);
            tmp.append("&TXCODE=");
            tmp.append(TXCODE);
            // 待加密字符串
            String tmp1 = tmp.toString();
            System.out.println(tmp1);
            String param = merinfo+'&'+tmp1;
            System.out.println(param);
            // 创建加密对象，向构造函数传入密钥
            String signKey = config.getString("Pub");
            //String PUB32TR2 = signKey.substring(signKey.length()-30);// PUB字段为对应柜台的公钥后30位
            CCBPayUtil ccbPayUtil = new CCBPayUtil();
            String ccbParam = ccbPayUtil.makeCCBParam(param, signKey);
            System.out.println(ccbParam);
            String url ="https://"+ config.getString("payUrl") + "?MERCHANTID=" + MERCHANTID
                    + "&POSID=" + POSID + "&BRANCHID=" + BRANCHID + "&ccbParam=" + ccbParam;

            Map map = new HashMap();
            map.put("MERCHANTID",MERCHANTID);
            map.put("POSID",POSID);
            map.put("BRANCHID",BRANCHID);
            map.put("ccbParam",ccbParam);
            map.put("ORDERID",ORDERID);
            map.put("AMOUNT",AMOUNT);
            map.put("TXCODE",TXCODE);
            map.put("MERFLAG",MERFLAG);
            map.put("QRCODE",QRCODE);


            String response = HttpRequestUtil.sendPost(url, map,"UTF-8");
            System.out.println(response);
            JSONObject jo = null;
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("建行未正常响应");
            }
            if(jo.isNull("RESULT") || jo.getString("RESULT").equals("N")){
                // 支付失败不需要验签，直接返回失败即可
                throw new RuntimeException("支付失败，银行返回信息:" + jo.getString("ERRMSG"));
            }
            else if(jo.getString("RESULT").equals("Q") || jo.getString("RESULT").equals("U")){
                payResult.put("code", 501);
                payResult.put("msg","支付状态待查询");
            }
            // 组织支付方式
            if(jo.getString("QRCODETYPE").equals("1")){
                payResult.put("f_bank_type","龙支付");
            }else if(jo.getString("QRCODETYPE").equals("2")){
                payResult.put("f_bank_type","微信");
            }else if(jo.getString("QRCODETYPE").equals("3")){
                payResult.put("f_bank_type","支付宝");
            }else{
                payResult.put("f_bank_type","未知");
            }
            if(jo.getString("RESULT").equals("Q") || jo.getString("RESULT").equals("U")){
                // 如果支付状态是待查询，此时直接返回即可
                payResult.put("f_out_trade_no",ORDERID);
                System.out.println("被扫支付结束，返回待查询或不确定:" + payResult.toString());
                return payResult;
            }else{
                payResult.put("code",200);
                payResult.put("f_out_trade_no",ORDERID);
                payResult.put("msg","支付确认成功");
            }
        } catch (Exception e) {
            System.out.println("被扫支付异常,异常信息:" + e.getMessage());
            payResult.put("code",500);
            payResult.put("msg",e.getMessage());
        }
        System.out.println("被扫支付结束，返回信息:" + payResult.toString());
        return payResult;
    }
    /**
     * 轮询查询PAY101
     * @return
     *
     */
    public JSONObject queryPay(JSONObject config,JSONObject data) {
        JSONObject result = null;
        try {
            System.out.println("轮询查询PAY101支付结果传入参数=>订单号:" + data.getString("f_out_trade_no") + ",付款方式:" + data.getString("f_bank_type"));
            result = new JSONObject();

            String MERFLAG = "1";
            String MERCHANTID = config.getString("MERCHANTID");// 商户号
            String POSID = config.getString("POSID");// 柜台号
            String BRANCHID = config.getString("BRANCHID");//分行号
            String BANKTYPE = null;
            if(data.getString("f_bank_type") == null){
                BANKTYPE = "2";// 如果不传，默认为微信
            }else if(data.getString("f_bank_type").equals("微信")){
                BANKTYPE = "2";
            }else {
                BANKTYPE = "3";
            }
            String TXCODE= "PAY101";
            String QRYTIME = null;
            if(data.isNull("f_query_times") ){
                QRYTIME = "1";
            }else{
                int times = data.getInt("f_query_times") + 1;
                QRYTIME = times + "";
            }
            result.put("TIMES", QRYTIME);

            StringBuffer merInfo=new StringBuffer();
            merInfo.append("MERCHANTID=");
            merInfo.append(MERCHANTID);
            merInfo.append("&POSID=");
            merInfo.append(POSID);
            merInfo.append("&BRANCHID=");
            merInfo.append(BRANCHID);
            String merinfo = merInfo.toString();
            System.out.println(merinfo);

            StringBuffer tmp = new StringBuffer(); //验签字段
            tmp.append("&MERFLAG=");
            tmp.append(MERFLAG);
            tmp.append("&TERMNO1=");
            tmp.append("");
            tmp.append("&TERMNO2=");
            tmp.append("");
            tmp.append("&ORDERID=");
            tmp.append(data.getString("f_out_trade_no"));
            tmp.append("&QRYTIME=");
            tmp.append(QRYTIME);
            tmp.append("&QRCODETYPE=");
            tmp.append(BANKTYPE);
            tmp.append("&TXCODE=");
            tmp.append(TXCODE);

            // 待加密字符串
            String strSrcParas = tmp.toString();
            System.out.println(strSrcParas);
            String param = merinfo+strSrcParas;
            System.out.println(param);

            // 创建加密对象，向构造函数传入密钥
            String signKey = config.getString("Pub");
            //String PUB32TR2 = signKey.substring(signKey.length()-30);// PUB字段为对应柜台的公钥后30位
            CCBPayUtil ccbPayUtil = new CCBPayUtil();
            String ccbParam = ccbPayUtil.makeCCBParam(param, signKey);
            System.out.println(ccbParam);

            Map map = new HashMap();
            map.put("MERFLAG",MERFLAG);
            map.put("TXCODE",TXCODE);

            map.put("TERMNO1","");
            map.put("TERMNO2","");
            map.put("ORDERID",data.getString("f_out_trade_no"));
            map.put("QRYTIME",QRYTIME);
            map.put("QRCODETYPE",BANKTYPE);
            map.put("QRCODE","");
            map.put("REMARK1","");
            map.put("REMARK2","");
            map.put("SUB_APPID","");
            map.put("RETURN_FIELD","");

            map.put("ccbParam",ccbParam);
            String url = "https://"+  config.getString("payUrl") + "?MERCHANTID=" + MERCHANTID
                    + "&POSID=" + POSID + "&BRANCHID=" + BRANCHID + "&ccbParam=" + ccbParam;
            System.out.println("即将发起轮询查询请求，url:" + url + ",参数map:" + map.toString());
            String response = HttpRequestUtil.sendPost(url, map,"UTF-8");
            System.out.println("轮询查询响应结果:" + response);
            JSONObject jo = null;
            try{
                jo = new JSONObject(response);
            }catch(Exception e){
                throw new RuntimeException("获取支付结果建行未正常响应");
            }
            result.put("code", 200);
            result.put("RESULT", jo.getString("RESULT"));
            result.put("ORDERID", jo.getString("ORDERID"));
        }catch (Exception e) {
            System.out.println("轮询查询PAY101支付结果异常,异常信息:" + e.getMessage());
            result.put("code", 500);
            result.put("msg",e.getMessage());
        }
        System.out.println("轮询查询PAY101支付结果结束，返回信息:" + result.toString());
        return result;
    }
}
