package filiale.guangxi;

import com.af.plugins.calculate.ISettlementInterface;
import org.json.JSONArray;
import org.json.JSONObject;

import java.math.BigDecimal;
import java.math.RoundingMode;

/**
 * caption
 * 			单价计算方法。
 * 			费用 = 单价* 数量
 * @author Lyf
 *
 */
public class UnitpriceSettlement implements ISettlementInterface {

	@Override
	public JSONObject calcCharge(JSONArray chargeInfo, BigDecimal gas) {
		// 单价
		BigDecimal unitprice = chargeInfo.getJSONObject(0).getBigDecimal("f_unitprice");
		//费用 = 单价* 气量
		BigDecimal chargenum = unitprice.multiply(gas);
		JSONArray array = new JSONArray();
		JSONObject json = new JSONObject();
		json.put("f_price_name", "固定气价");
		json.put("f_price", unitprice);
		json.put("f_gas", gas);
		json.put("f_money", chargenum);
		array.put(json);
		
		JSONObject ret = new JSONObject();
		ret.put("chargeprice", array);
		ret.put("chargenum", chargenum);
		ret.put("gas", gas);
		ret.put("money", chargenum);
		System.out.println(ret.toString());
		return ret;
	}

	@Override
	public JSONObject calcAmount(JSONArray chargeInfo, BigDecimal fee) {
		//单价
		BigDecimal unitprice = chargeInfo.getJSONObject(0).getBigDecimal("f_unitprice");
		BigDecimal amount = fee.divide(unitprice, 4, RoundingMode.HALF_UP);
		
		JSONArray array = new JSONArray();
		JSONObject json = new JSONObject();
		json.put("f_price_name", "固定气价");
		json.put("f_price", unitprice);
		json.put("f_gas", amount);
		json.put("f_money", fee);
		array.put(json);
		
		JSONObject ret = new JSONObject();
		ret.put("chargeprice", array);
		ret.put("gas", amount);
		ret.put("money", fee);
		ret.put("chargenum", fee);
		System.out.println(ret.toString());
		return ret;
	}
}