package com.aote.rs;

import com.aote.plugin.NewImage;
import com.aote.sql.SqlServer;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.UUID;


/**
 * @author yyc
 */
@Component
@EnableScheduling
@Lazy(false)
public class NewImageTimer {

    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private LogicService logicService;
    static Logger log = Logger.getLogger(LogicService.class);
    public NewImageTimer() {
    }

    @Scheduled(
            cron = "0 0 0/2 * * ?"
    )
    @Transactional(readOnly=true)
    public void doJob() throws Exception {

        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("获取到的执行配置为---》"+conf.get("NewImage"));


        if ((boolean) conf.get("NewImage")) {
            System.out.println("定时器执行+++++");
            JSONArray query = sqlServer.query("SELECT\n" +
                    "\tthp.id,\n" +
                    "\tf_user_name,\n" +
                    "\tf_userinfo_code,\n" +
                    "\tf_hand_date,\n" +
                    "\tf_price,\n" +
                    "\tf_oughtfee,\n" +
                    "\tf_last_tablebase,\n" +
                    "\tf_oughtamount,\n" +
                    "\tf_tablebase,\n" +
                    "\ttf.f_downloadpath,\n" +
                    "\tf_inputtor,\n" +
                    "\t[dbo].[f_num_chn] ( f_oughtfee ) AS bigmoney \n" +
                    "FROM\n" +
                    "\tt_handplan thp\n" +
                    "\tLEFT JOIN t_detailprice tsp ON thp.f_stairprice_id = tsp.f_stairprice_id\n" +
                    "\tLEFT JOIN t_files tf ON thp.f_sign_path= tf.f_filename \n" +
                    "WHERE\n" +
                    "\tf_price_name = '1' \n" +
                    "\tAND f_hand_path IS  NULL \n" +
                    "\tAND f_filename IS NOT NULL");
            query.forEach(res->{
                JSONObject o=(JSONObject)res;
                //单价
                String f_price = o.getBigDecimal("f_price").toString();
                //应交金额
                String f_oughtfee = o.getBigDecimal("f_oughtfee").toString();
                //上期表底数
                String f_last_tablebase = o.getBigDecimal("f_last_tablebase").toString();
                //本月用气量
                String f_oughtamount = o.getBigDecimal("f_oughtamount").toString();
                //本期表底数
                String f_tablebase = o.getBigDecimal("f_tablebase").toString();
                String f_downloadpath = o.getString("f_downloadpath");
                String bigmoney = o.getString("bigmoney");
                String f_user_name = o.getString("f_user_name");
                String f_userinfo_code = o.getString("f_userinfo_code");
                String f_hand_date = o.getString("f_hand_date");
                String f_inputtor = o.getString("f_inputtor");
                int handplanid = o.getInt("id");

                NewImage cg = new NewImage();
                String table[][] = {
                        {"上次气表底数", "本次气表底数", "本月用气量", "单价（元/立方）", "应交金额"},
                        {f_last_tablebase, f_tablebase, f_oughtamount, f_price, f_oughtfee},
                        {"气费金额（大写）", bigmoney},
                        {"抄表人", f_inputtor, "用户签名"},
                        {"请于本月28日前到营业厅缴费,逾期未缴费的，将采取停气措施，本月底前仍未交费"},
                        {"的，每天将按欠费金额的千分之五收取滞纳金"}
                };
                String uuid = UUID.randomUUID().toString();
                String user="用户姓名:"+f_user_name+"     用户编号:"+f_userinfo_code+"     抄表日期:"+f_hand_date;
                cg.myGraphicsGeneration(table, "E:\\readmeter\\" + uuid + ".jpg", f_downloadpath,user);
                JSONObject savedata = new JSONObject();
                savedata.put("f_hand_path",uuid + ".jpg");
                savedata.put("handplanid",handplanid);
                savedata.put("imgpath","E:\\readmeter\\" + uuid + ".jpg");
                try {
                    //回调执行
                    logicService.xtSave("backtohandplan","{data:"+savedata.toString()+"}");
                } catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
    }
}
