package com.aote.rs;

import com.aote.plugin.ReadExcel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
/*
 * 富瑞克物料导出后台
 */
@Path("material")
@Component
public class MaterialService {
    private static final Logger logger = Logger.getLogger(MaterialService.class);
    @Autowired
    private ReadExcel readExcel;

    @POST
    @Path("/importExcel")
    @Produces(MediaType.TEXT_PLAIN + ";charset=utf-8")
    public String importExcelInDB(String data) throws Exception {
        try{
            return readExcel.readExcelData(data).toString();
        }catch (Exception exception){
            logger.debug(exception.getMessage(),exception);
            return readExcel.readExcelData(data).toString();
        }
    }
}
