package com.aote.rs;

import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.transaction.SessionPool;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import java.io.IOException;

/**
 * 铜川电子票
 */
@Path("invoice")
//@Singleton
@Component
public class InvoiceService {
    static Logger log = Logger.getLogger(InvoiceService.class);
    static String invoice_url;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
  @Autowired
    private EntityServer entityServer;

    /**
     *
     * @param jsonstr f_userinfo_code或者f_card_id
     * @return
     */
    @POST
    @Path("GetEticketQuery")
  public String searchUser(String jsonstr){

        // TODO 定义返回参数
        JSONObject json = new JSONObject(jsonstr);
        JSONObject info = new JSONObject();
        JSONObject result = new JSONObject();
      // TODO 如果传进来的参数有误，返回
     try {


        if(json.isEmpty()){
             result.put("code","9999");
             result.put("errMsg","传入json有误");
             return result.toString();
         }
        //TODO 获取userinfoid
        String userinfo="";
        if(json.has("f_userinfo_code")){
            userinfo=json.getString("f_userinfo_code");
            System.out.println("客户编号"+userinfo+json);
            String sqls =
                    "select isnull(F_USER_NAME, F_PAPER_NAME)   f_buy_name" +
                            "     , isnull(F_TAXPAYER_ID, F_IDNUMBER)                                 f_pay_id" +
                            "     , isnull(F_ADDRESS_PHONE, address.F_ADDRESS+ F_USER_PHONE) f_buy_address,f_user_phone,address.f_address" +
                            "     , isnull(F_PAPER_ACCOUNT,'')                                             f_buy_openbank" +
                            "     , isnull(uf.F_USER_TYPE,'')                                                 f_user_type" +
                            " from T_USERINFO info left join T_USERFILES uf on uf.F_USERINFO_ID = info.F_USERINFO_ID and F_TABLE_STATE ='正常'" +
                            "         left join T_USER_ADDRESS address on address.F_USERINFO_ID = info.F_USERINFO_ID" +
                            " where info.f_userinfo_code ='" +userinfo+"'"
            ;
            JSONObject sqlJson=new JSONObject();
            sqlJson.put("sql",sqls);

            JSONArray users=(JSONArray) logicServer.run("sqlquery",sqlJson);
            log.debug("查询到的数据是：" + users);
            if(users.length()>0){
                System.out.println(result+""+users);
                info.put("successful","1");
                info.put("f_buy_name",users.getJSONObject(0).getString("f_buy_name"));
                info.put("f_pay_id",users.getJSONObject(0).getString("f_pay_id"));
                info.put("f_phone",users.getJSONObject(0).getString("f_user_phone"));
                info.put("f_address",users.getJSONObject(0).getString("f_address"));
                info.put("f_buy_openbank",users.getJSONObject(0).getString("f_buy_openbank"));
                info.put("f_user_type",users.getJSONObject(0).getString("f_user_type"));
                result.put("code","0000");
                result.put("info",info);
                System.out.println(result+""+users);
            }else{
                result.put("code","9999");
                result.put("errMsg","查询不到该用户信息");
            }
        }else if(json.has("f_card_id")){
            userinfo=json.getString("f_card_id");
            System.out.println("卡号"+userinfo);
            String sqls =
                    "select isnull(F_USER_NAME, F_PAPER_NAME)   f_buy_name" +
                            "     , isnull(F_TAXPAYER_ID, F_IDNUMBER)                                 f_pay_id" +
                            "     , isnull(F_ADDRESS_PHONE, address.F_ADDRESS+ F_USER_PHONE) f_buy_address,f_user_phone,address.f_address" +
                            "     , isnull(F_PAPER_ACCOUNT,'')                                             f_buy_openbank" +
                            "     , isnull(uf.F_USER_TYPE,'')                                                 f_user_type" +
                            " from T_USERINFO info left join T_USERFILES uf on uf.F_USERINFO_ID = info.F_USERINFO_ID and F_TABLE_STATE ='正常'" +
                            "         left join T_USER_ADDRESS address on address.F_USERINFO_ID = info.F_USERINFO_ID" +
                            " where uf.f_card_id ='" +userinfo+"'"
            ;
            JSONObject sqlJson=new JSONObject();
            sqlJson.put("sql",sqls);
            JSONArray users=(JSONArray) logicServer.run("sqlquery",sqlJson);
            log.debug("查询到的数据是：" + users);
            if(users.length()>0){
                info.put("successful","1");
                info.put("f_buy_name",users.getJSONObject(0).getString("f_buy_name"));
                info.put("f_pay_id",users.getJSONObject(0).getString("f_pay_id"));
                info.put("f_phone",users.getJSONObject(0).getString("f_user_phone"));
                info.put("f_address",users.getJSONObject(0).getString("f_address"));
                info.put("f_buy_openbank",users.getJSONObject(0).getString("f_buy_openbank"));
                info.put("f_user_type",users.getJSONObject(0).getString("f_user_type"));
                result.put("code","0000");
                result.put("info",info);
                System.out.println(result);
            }else{
                result.put("code","9999");
                result.put("errMsg","查询不到该用户信息");
            }
        }
        log.debug("result"+result);
        return result.toString();
     }catch (Exception e){
         result.put("code", 500);
         result.put("errmsg", e.getMessage());
         return result.toString();
     }
  }
    private void init() throws IOException {
    }

    /**
     * 根据流水号开票
     *
     * @param jsonAr 收费id数组 json
     */
    @POST
    @Path("OpenEticket")
    public String openInvoice(String jsonAr){

        JSONObject result=new JSONObject();
        JSONObject json=new JSONObject(jsonAr);

        JSONObject entity=new JSONObject();
        try {
            JSONObject configJson = new JSONObject(
                    ResourceHelper.getString("config.json"));
            invoice_url = configJson.getString("invoiceurl");
            //TODO 验证收费记录是否同一个id
            String sqls = "select cast(id as varchar)id, cast(f_userinfo_id as varchar)f_userinfo_id,f_type,f_operator,f_operatorid,f_depname,f_depid,f_orgid,f_orgname from t_sellinggas where f_serial_id = '" + json.getString("serial_id")+ "' and f_state = '有效'";

            JSONObject sqlJson=new JSONObject();
            sqlJson.put("sql",sqls);
            JSONArray sell_result=(JSONArray) logicServer.run("sqlquery",sqlJson);
            System.out.println("sell_result"+sell_result.length());
            if(sell_result.length()==0){
                result.put("code", "9999");
                result.put("msg", "该条订单记录未找到");
                return result.toString();
            }
            //TODO 验证用户信息是否完善
            String sqls2 = "select isnull(F_USER_NAME, F_PAPER_NAME)                                 f_buy_name\n" +
                    "     , isnull(F_TAXPAYER_ID, F_IDNUMBER)                                 f_pay_id\n" +
                    "     , isnull(F_ADDRESS_PHONE, address.F_ADDRESS + ' ' + F_USER_PHONE) f_buy_address\n" +
                    "     , F_PAPER_ACCOUNT                                                f_buy_openbank\n" +
                    "     , uf.F_USER_TYPE                                                 f_user_type\n" +
                    "     , case\n" +
                    "           when uf.F_USER_TYPE = '非民用' and (F_PAPER_ACCOUNT is not null\n" +
                    "               and isnull(F_ADDRESS_PHONE, address.F_ADDRESS + ' ' + F_USER_PHONE) is not null\n" +
                    "               and isnull(F_TAXPAYER_ID, F_IDNUMBER) is not null\n" +
                    "               and isnull(F_USER_NAME, F_PAPER_NAME) is not null) then 1\n" +
                    "           when uf.F_USER_TYPE = '民用' and (isnull(F_ADDRESS_PHONE, address.F_ADDRESS + ' ' + F_USER_PHONE) is not null\n" +
                    "               and isnull(F_TAXPAYER_ID, F_IDNUMBER) is not null\n" +
                    "               and isnull(F_USER_NAME, F_PAPER_NAME) is not null) then 1\n" +
                    "           else 0 end                                             checkmsg\n" +
                    "from T_USERINFO info\n" +
                    "         left join T_USERFILES uf on uf.F_USERINFO_ID = info.F_USERINFO_ID and F_TABLE_STATE ='正常'\n" +
                    "         left join T_USER_ADDRESS address on address.F_USERINFO_ID = info.F_USERINFO_ID\n" +
                    "where info.F_USERINFO_ID = '"+sell_result.getJSONObject(0).getString("f_userinfo_id")+"'";
            JSONObject sqlJson2=new JSONObject();
            sqlJson2.put("sql",sqls2);
            JSONArray userinfo=(JSONArray) logicServer.run("sqlquery",sqlJson2);
            System.out.println("sell_result"+sell_result.length());
            userinfo.getJSONObject(0).put("id",sell_result);
            JSONArray sell_id=new JSONArray();
            sell_id.put(sell_result.getJSONObject(0).getString("id"));
            log.debug("sell_id"+sell_id);
            userinfo.getJSONObject(0).put("id",sell_id);
            userinfo.getJSONObject(0).put("f_charge_type",sell_result.getJSONObject(0).getString("f_type"));
            userinfo.getJSONObject(0).put("f_operator",sell_result.getJSONObject(0).getString("f_operator"));
            userinfo.getJSONObject(0).put("f_operatorid",sell_result.getJSONObject(0).getString("f_operatorid"));
            userinfo.getJSONObject(0).put("f_depname",sell_result.getJSONObject(0).getString("f_depname"));
            userinfo.getJSONObject(0).put("f_orgid",sell_result.getJSONObject(0).getString("f_orgid"));
            userinfo.getJSONObject(0).put("f_pay_id",json.getString("f_pay_id"));
            userinfo.getJSONObject(0).put("f_address",json.getString("f_address"));
            userinfo.getJSONObject(0).put("f_buy_name",json.getString("f_buy_name"));
            userinfo.getJSONObject(0).put("f_buy_openbank",json.has("f_buy_openbank")?json.getString("f_buy_openbank"):"");
            userinfo.getJSONObject(0).put("f_ghf_sj",json.has("f_ghf_sj")?json.getString("f_ghf_sj"):"");
            userinfo.getJSONObject(0).put("f_ghf_gh",json.getString("f_ghf_gh"));
            userinfo.getJSONObject(0).put("f_asphone",json.has("asphone")?json.getBoolean("asphone"):"");
            System.out.println("userinfo"+userinfo);
            String eticket_id = (String) logicServer.run("TCcombineData", userinfo.getJSONObject(0).toString());
            entity.put("id", eticket_id);
            JSONObject openjson = new JSONObject(RestTools.post(invoice_url
                    + "/invoice/rs/tongchuan/getInvoice", new JSONObject("{eticket_id: " + eticket_id + "}")));
            System.out.println("openjson开票数据是"+openjson);
            if (openjson.getJSONObject("RESPONSE_FPXX").getString("RETURN_CODE").equals("0000")) {
                entity.put("f_bill_state", "等待查询");
                // 休眠三秒再去查询
                Thread.sleep(3000);
                JSONObject serchjosn = new JSONObject(RestTools.post(invoice_url
                        + "/invoice/rs/tongchuan/queryInvoice", new JSONObject("{eticket_id: " + eticket_id + "}")));
                if (!serchjosn.has("RESPONSE_FPXXXZ")) {
                    entity.put("f_sign_result", "查询超时，请前往发票记录页面重新查询");
                    result.put("code", "0011");
                    result.put("msg", "查询超时，请前往发票记录页面重新查询");
                } else {
                    serchjosn = serchjosn.getJSONObject("RESPONSE_FPXXXZ");
                    if (serchjosn.getString("RETURN_CODE").equals("0000")) {
                        entity.put("f_bill_code", String.valueOf(serchjosn.get("FPDM")));
                        entity.put("f_bill_number", String.valueOf(serchjosn.get("FPHM")));
                        entity.put("f_jym", String.valueOf(serchjosn.get("INVOICE_CHECK_CODE")));
                        entity.put("f_bill_url", String.valueOf(serchjosn.get("PDF_URL")));
                        entity.put("f_sign_result", String.valueOf(serchjosn.get("RETURN_MESSAGE")));
                        entity.put("f_bill_state", "开票成功");
                        result.put("code", "0000");
                        result.put("pdf_url", String.valueOf(serchjosn.get("PDF_URL")));
                    } else {
                        entity.put("f_sign_result", String.valueOf(serchjosn.get("RETURN_MESSAGE")));
                        entity.put("f_bill_state", "等待查询");
                        result.put("code", "0011");
                        result.put("msg", "查询超时，请前往发票记录页面重新查询,"+String.valueOf(serchjosn.get("RETURN_MESSAGE")));
                    }
                }
            } else {
                entity.put("f_bill_state", "开票失败");
                entity.put("f_sign_result", "开票失败,需要查询日志。");
                result.put("code", "9999");
                result.put("code", "开票失败,需要查询日志。");
            }
            entityServer.partialSave("t_eticket", entity);
            return result.toString();
        } catch (Exception e) {
            log.error(ExceptionHelper.stackToString(e));
            result.put("code", "9999");
            result.put("msg", e.getMessage());
            return result.toString();
        }
    }
    /**
     * 流水号查询
     *
     * @param serial_id
     */
    @POST
    @Path("SearchEticket")
    public String searchEticket(String serial_id){
        JSONObject param=new JSONObject(serial_id);
        JSONObject result = new JSONObject();
        JSONObject entity = new JSONObject();
        try {
            JSONObject configJson = new JSONObject(
                    ResourceHelper.getString("config.json"));
            invoice_url = configJson.getString("invoiceurl");
            //TODO  查找所属收费记录所属得发票编码
            String sqls =
                    "select f_eticket_id from t_sellinggas A " +
                            " left join t_ticketrelated B on A.id=B.f_sell_id"+
                            " left join t_eticket C on C.id = B.f_eticket_id where f_serial_id = '" +param.getString("serial_id")+ "' and C.f_bill_state != '开票失败'";
            JSONObject sqlJson2=new JSONObject();
            sqlJson2.put("sql",sqls);
            JSONArray sell_result=(JSONArray) logicServer.run("sqlquery",sqlJson2);
            System.out.println("sell_result"+sell_result.length());
            log.debug("sell_result"+sell_result);
            if (sell_result.length() != 1) {
                result.put("code", "9999");
                result.put("msg", sell_result.length() > 1 ? "数据异常请检查！" : "该条记录没有对应的发票记录！");
                return result.toString();
            }
            String eticket_id = sell_result.getJSONObject(0).getString("f_eticket_id");
            entity.put("id", eticket_id);
            log.debug("eticket_id"+eticket_id);
            JSONObject serchjosn = new JSONObject(RestTools.post(invoice_url
                    + "/invoice/rs/tongchuan/queryInvoice", new JSONObject("{eticket_id: " + eticket_id + "}")));
            log.debug("serchjosn"+serchjosn);
            log.debug(serchjosn.has("RESPONSE_FPXXXZ"));
            if (!serchjosn.has("RESPONSE_FPXXXZ")) {
                entity.put("f_sign_result", "查询超时，请前往发票记录页面重新查询");
                result.put("code", "0011");
                result.put("msg", "查询超时，请前往发票记录页面重新查询");
            } else {
                serchjosn = serchjosn.getJSONObject("RESPONSE_FPXXXZ");
                if (serchjosn.getString("RETURN_CODE").equals("0000")) {
                    entity.put("f_bill_code", String.valueOf(serchjosn.get("FPDM")));
                    entity.put("f_bill_number", String.valueOf(serchjosn.get("FPHM")));
                    entity.put("f_jym", String.valueOf(serchjosn.get("INVOICE_CHECK_CODE")));
                    entity.put("f_bill_url", String.valueOf(serchjosn.get("PDF_URL")));
                    entity.put("f_sign_result", String.valueOf(serchjosn.get("RETURN_MESSAGE")));
                    entity.put("f_bill_state", "开票成功");
                    result.put("code", "0000");
                    result.put("pdf_url", String.valueOf(serchjosn.get("PDF_URL")));
                } else {
                    entity.put("f_sign_result", String.valueOf(serchjosn.get("RETURN_MESSAGE")));
                    entity.put("f_bill_state", "等待查询");
                    result.put("code", "0011");
                    result.put("msg", "查询超时，请前往发票记录页面重新查询,"+String.valueOf(serchjosn.get("RETURN_MESSAGE")));
                }
            }
            entityServer.partialSave("t_eticket", entity);
            log.debug("result"+result);
            return result.toString();
        } catch (Exception e) {
            log.error(ExceptionHelper.stackToString(e));
            result.put("code", "9999");
            result.put("msg", e.getMessage());
            return result.toString();
        }
    }
}
