package com.aote.rs;

import com.af.plugins.RestTools;
import com.aote.entity.EntityServer;
import com.aote.logic.LogicServer;
import com.aote.sql.SqlServer;
import com.aote.util.ExceptionHelper;
import com.aote.util.ResourceHelper;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import java.io.IOException;

/**
 * 广西电子票
 */
@Path("gxinvoice")
//@Singleton
@Component
public class GXInvoiceService {
    static Logger log = Logger.getLogger (GXInvoiceService.class);
    static String invoice_url;
    static Integer waiting_time ;
    @Autowired
    private LogicServer logicServer;
    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private EntityServer entityServer;

    private void init() throws IOException {
    }

    /**
     * 根据流水号开票
     *
     * @param jsonAr 收费id数组 json
     */
    @POST
    @Path("OpenEticket")
    public String openInvoice(String jsonAr) {

        JSONObject result = new JSONObject ();
        JSONObject entity = new JSONObject ();
        try {
            JSONObject configJson = new JSONObject (
                    ResourceHelper.getString ("config.json"));
            invoice_url = configJson.getString ("invoiceurl");
            Integer waiting_time = Integer.parseInt (configJson.getString ("waitingtime"));
            String eticket_id = (String) logicServer.run ("combineData_new", jsonAr);
            entity.put ("id", eticket_id);
            JSONObject openjson = new JSONObject (RestTools.post (invoice_url
                    + "/invoice/rs/logic/GXGetInvoice", new JSONObject ("{eticket_id: " + eticket_id + "}")));
            System.out.println ("openjson开票数据是" + openjson);
            if (openjson.getString ("code").equals ("E0000")) {
                entity.put ("f_bill_state", "等待查询");
                // 休眠三秒再去查询
                Thread.sleep (waiting_time*1000);
                JSONObject serchjosn = new JSONObject (RestTools.post (invoice_url
                        + "/invoice/rs/logic/GXQueryInvoice", new JSONObject ("{eticket_id: " + eticket_id + "}")));
                if (!serchjosn.getString ("code").equals ("E0000")) {
                    entity.put ("f_sign_result", "查询超时，请前往发票记录页面重新查询");
                    result.put ("code", "0011");
                    result.put ("msg", "查询超时，请前往发票记录页面重新查询");
                } else {
                    serchjosn = serchjosn.getJSONObject ("data");
                    if (serchjosn.getString ("status").equals ("2")) {
                        entity.put ("f_bill_code", String.valueOf (serchjosn.get ("invoiceCode")));
                        entity.put ("f_bill_number", String.valueOf (serchjosn.get ("invoiceNo")));
                        entity.put ("f_jym", String.valueOf (serchjosn.get ("checkCode")));
                        entity.put ("f_bill_url", String.valueOf (serchjosn.get ("pdfUrl")));
                        entity.put ("f_sign_result", String.valueOf (serchjosn.get ("statusMsg")));
                        entity.put ("f_bill_state", "开票成功");
                        result.put ("code", "0000");
                        result.put ("pdf_url", String.valueOf (serchjosn.get ("pdfUrl")));
                    } else {
                        entity.put ("f_sign_result", String.valueOf (serchjosn.get ("statusMsg")));
                        entity.put ("f_bill_state", "等待查询");
                        result.put ("code", "0011");
                        result.put ("msg", "查询超时，请前往发票记录页面重新查询," + String.valueOf (serchjosn.get ("statusMsg")));
                    }
                }
            } else {
                entity.put ("f_bill_state", "开票失败");
                entity.put ("f_sign_result", "开票失败,需要查询日志。");
                result.put ("code", "9999");
                result.put ("code", "开票失败,需要查询日志。");
            }
            entityServer.partialSave ("t_eticket", entity);
            return result.toString ();
        } catch (Exception e) {
            log.error (ExceptionHelper.stackToString (e));
            result.put ("code", "9999");
            result.put ("msg", "系统繁忙请重试！");
            return result.toString ();
        }
    }

    /**
     * 通过收费记录id查询发票状态
     *
     * @param sell_id
     */
    @POST
    @Path("SearchEticket")
    public String searchEticket(String sell_id) {
        JSONObject param = new JSONObject (sell_id);
        JSONObject result = new JSONObject ();
        JSONObject entity = new JSONObject ();
        JSONObject sqlJson2 = new JSONObject ();
        String charge_type =  param.optString ("f_charge_type");
        try {
            JSONObject configJson = new JSONObject (
            ResourceHelper.getString ("config.json"));
            invoice_url = configJson.getString ("invoiceurl");
            //TODO  查找所属收费记录所属得发票编码
            if (charge_type.equals ("报建收费")){
                String sqls =
                        "select f_eticket_id from t_charge_record A " +
                                " left join t_ticketrelated B on A.id=B.f_sell_id" +
                                " left join t_eticket C on C.id = B.f_eticket_id " +
                                "where A.id = '" + param.getString ("sell_id") +
                                "' and C.f_bill_state != '开票失败' and B.f_business_type = '报建收费'";
                sqlJson2.put ("sql", sqls);
            }else {
                String sqls =
                        "select f_eticket_id from t_sellinggas A " +
                                " left join t_ticketrelated B on A.id=B.f_sell_id" +
                                " left join t_eticket C on C.id = B.f_eticket_id " +
                                "where A.id = '" + param.getString ("sell_id") +
                                "' and C.f_bill_state != '开票失败'";
                sqlJson2.put ("sql", sqls);
            }
            JSONArray sell_result = (JSONArray) logicServer.run ("sqlquery", sqlJson2);
            System.out.println ("sell_result" + sell_result.length ());
            log.debug ("sell_result" + sell_result);
            if (sell_result.length () != 1) {
                result.put ("code", "9999");
                result.put ("msg", sell_result.length () > 1 ? "数据异常请检查！" : "该条记录没有对应的发票记录！");
                return result.toString ();
            }
            String eticket_id = sell_result.getJSONObject (0).getString ("f_eticket_id");
            entity.put ("id", eticket_id);
            log.debug ("eticket_id" + eticket_id);
            JSONObject serchjosn = new JSONObject (RestTools.post (invoice_url
                    + "/invoice/rs/logic/GXQueryInvoice", new JSONObject ("{eticket_id: " + eticket_id + "}")));
            if (!serchjosn.getString ("code").equals ("E0000")) {
                entity.put ("f_sign_result", "查询超时，请前往发票记录页面重新查询");
                result.put ("code", "0011");
                result.put ("msg", "查询超时，请前往发票记录页面重新查询");
            } else {
                serchjosn = serchjosn.getJSONObject ("data");
                if (serchjosn.getString ("status").equals ("2")) {
                    entity.put ("f_bill_code", String.valueOf (serchjosn.get ("invoiceCode")));
                    entity.put ("f_bill_number", String.valueOf (serchjosn.get ("invoiceNo")));
                    entity.put ("f_jym", String.valueOf (serchjosn.get ("checkCode")));
                    entity.put ("f_bill_url", String.valueOf (serchjosn.get ("pdfUrl")));
                    entity.put ("f_sign_result", String.valueOf (serchjosn.get ("statusMsg")));
                    entity.put ("f_bill_state", "开票成功");
                    result.put ("code", "0000");
                    result.put ("pdf_url", String.valueOf (serchjosn.get ("pdfUrl")));
                } else {
                    entity.put ("f_sign_result", String.valueOf (serchjosn.get ("statusMsg")));
                    entity.put ("f_bill_state", "等待查询");
                    result.put ("code", "0011");
                    result.put ("msg", "查询超时，请前往发票记录页面重新查询," + String.valueOf (serchjosn.get ("statusMsg")));
                }
            }
            entityServer.partialSave ("t_eticket", entity);
            log.debug ("result" + result);
            return result.toString ();
        } catch (Exception e) {
            log.error (ExceptionHelper.stackToString (e));
            result.put ("code", "9999");
            result.put ("msg", e.getMessage ());
            return result.toString ();
        }
    }
}
