package com.aote.rs;

import com.aote.plugin.FuGuReadExcel;
import com.aote.plugin.ReadExcel;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

@Component
@Path("FuGuBlackListUsers")
public class FuGuBlackListUsersService {
    private static final Logger logger = Logger.getLogger(FuGuBlackListUsersService.class);
    @Autowired
    private FuGuReadExcel fuGuReadExcel;

    @POST
    @Path("/importExcel")
    @Produces(MediaType.TEXT_PLAIN + ";charset=utf-8")
    public String importExcelInDB(String data) throws Exception {
        try{
            return fuGuReadExcel.readExcelData(data).toString();
        }catch (Exception exception){
            logger.debug(exception.getMessage(),exception);
            return fuGuReadExcel.readExcelData(data).toString();
        }
    }
}
