package com.aote.rs;


import com.aote.rs.mapper.WebException;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

@Transactional
@Component
@Path("downloadfile")
public class DownloadService {
    @Autowired
    private SqlServer sqlServer;

    private Logger logger = Logger.getLogger(DownloadService.class);

    @GET
    @Path("file")
    public void downfiles(@Context HttpServletRequest request,
                          @Context HttpServletResponse response) {

        //获取当前公司所属组织
        JSONArray useOrgArr = new JSONArray();
        String download_orgId = "";
        int size = 0;
        try {
            //查询部门信息
            useOrgArr = sqlServer.query("select value from  t_singlevalue where name='所属公司'");
        } catch (Exception e) {
            e.printStackTrace();
        }
        //存在
        if (useOrgArr.length() > 0) {
            //获取部门id
            download_orgId = ((JSONObject) useOrgArr.get(0)).getString("value");
            //不为空
            if (!download_orgId.equals("")) {
                download_orgId = "_" + download_orgId;
            }
        }
        try {
            //获取request参数
            Map paramMap = request.getParameterMap();
            //转为Json对象
            JSONObject params = new JSONObject(paramMap);
            System.out.println(params);
            //如果存在这个值
            if (!params.has("filename")) {
                throw new WebException(708, "请传输下载文件名！");
            }
            String downname = "";
            try {
                JSONArray filenames = (JSONArray) params.get("filename");
                downname = (String) filenames.get(0);
            } catch (Exception e) {
                throw new WebException(708, "下载文件名不能为空！");
            }
            String url = "/excel/" + downname + download_orgId + ".xlsx";
            String filename = downname + download_orgId + ".xlsx";
            byte[] buffer = null;
            logger.debug("组装好的下载文件路径:" + url);
            // 取得文件名。
            logger.debug("获取到的文件名:" + filename);
            // 以流的形式下载文件。
            InputStream is = this.getClass().getResourceAsStream(url);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(is);
            int available = bufferedInputStream.available();
            buffer = new byte[available];
            logger.debug("开始下载:" + filename);
            while ((size = bufferedInputStream.read(buffer)) != -1) {
                logger.debug("当前buffer的大小为:" + buffer.length);
            }
            bufferedInputStream.close();
            is.close();
            // 清空response
            response.reset();
            // 设置response的Header
            response.addHeader("Content-Disposition", "attachment;filename=" + new String(filename.getBytes("UTF-8"), "ISO-8859-1"));
            response.addHeader("Content-Length", "" + size);
            OutputStream toClient = new BufferedOutputStream(response.getOutputStream());
            response.setContentType("application/octet-stream");
            toClient.write(buffer);
            toClient.flush();
            toClient.close();
        } catch (Exception ex) {
            logger.debug("下载模板异常:", ex);
            throw new WebException(709, "下载文件不存在！");
        }
    }
}
