package com.aote.rs;


import com.af.plugins.JsonTools;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import util.DateUtil;
import util.FTPUtil;

import javax.ws.rs.POST;
import javax.ws.rs.Path;

/**
 * @author llz
 * @ClassName downAmountFiles
 * @Description 下载对账文件
 * @date 2021/11/3013:55
 */
@Component
@Path("/downAmount")
public class DownAmountFiles {
    public static void main(String[] args) {
        String ss = "{\"startDate\":\"20201212\",\"endDate\":\"20201215\"}";
        String ret = downFile(ss);
        System.out.println(ret);
    }
    /**
     * log对象
     */
    static Logger LOGGER = Logger.getLogger(DownAmountFiles.class);
    /**
     * logic 对象
     */
    @Autowired
    LogicService logicService;

    /**
     * 获取本地保存位置
     */
    static JSONObject path = JsonTools.readJsonFile("bankDown.json").getJSONObject("path");
    /**
     * 获取解析方法地址
     */
    static JSONObject bank = JsonTools.readJsonFile("bankDown.json").getJSONObject("bank");

    /**
     * @param json {"startDate":"","endDate":"",}
     * @return ""
     * @author llz
     */
    @POST
    @Path("/downFile")
    public static String downFile(String json) {
        LOGGER.info("开始下载对账文件！");
        JSONObject ob = new JSONObject(json);
        //定义返回报文
        JSONObject ret = new JSONObject();
        //获取下载时间节点
        String startDate = String.valueOf(ob.get("startDate"));
        String endDate = String.valueOf(ob.get("endDate"));
        //文件名
        String fileName = "";
        try {
            //判断下载当天还是批量
            if (startDate.equals(endDate)) {
                //如果相同   则是单次下载
                //用日期模糊查询   获取文件名
                LOGGER.info("下载当天对账文件！");
                fileName = FTPUtil.queryFile(startDate);
                //下载文件到本地
                FTPUtil.downLoad(fileName);
                LOGGER.info("文件成功下载到本地！");
//                File file = new File(String.valueOf(path.get("fileLocalSavePath")) + "\\" + fileName);
//                //调用解析方法将对账文件存入数据库
//                String res = RestTools.post(String.valueOf(bank.get("parseFileUrl")), new JSONObject().toString());
//                if ("0000".equals(String.valueOf(new JSONObject(res).get("code")))) {
                    ret.put("code", "0000");
//                } else {
//                    ret.put("code", "9999");
//                }

            } else {
                LOGGER.info("开始批量下载对账文件！");
                JSONArray arr = DateUtil.betweenDate(startDate, endDate);
                String fileNames = "";
                for (int i = 0; i < arr.length(); i++) {
                    //获取文件名
                    fileNames = FTPUtil.queryFile(String.valueOf(arr.get(i)));
                    FTPUtil.downLoad(fileNames);

//                    File files = new File(path.getString("fileLocalSavePath") + "\\" + fileName);
//                    //调用解析方法将对账文件存入数据库
//                    String res = RestTools.post(String.valueOf(bank.get("parseFileUrl")), new JSONObject().toString());
//                    if ("0000".equals(String.valueOf(new JSONObject(res).get("code")))) {
                        ret.put("code", "0000");
//                    } else {
//                        ret.put("code", "9999");
//                    }
                }
            }
        } catch (Exception e) {
            LOGGER.error("文件下载失败！", e);
        }

        return ret.toString();
    }
}
