package com.aote.rs;

import com.af.plugins.CommonTools;
import com.af.plugins.RestTools;
import com.af.plugins.timeoutReturn.TimeCache;
import com.aote.sql.SqlMapper;
import com.aote.util.Util;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Context;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;

/**
 * 通用业务批处理服务
 * 用于避免批量业务处理时间长导致整个事务过大的问题
 *
 * @author Mrriver
 * @date 2022/8/3
 */
@Path("business")
@Component
public class BatchBusinessBase {
    /**
     * 日志对象
     */
    private static final Logger LOGGER = Logger.getLogger(BatchBusinessBase.class);
    /**
     * SQL查询支持
     */
    @Autowired
    private SqlService sqlService;
    /**
     * Logic执行支持
     */
    @Autowired
    private LogicService logicService;

    /**
     * 进度条
     */
    @Autowired
    private TimeCache timeCache;
    /**
     * 核心数
     */
    private static final Integer processors = Runtime.getRuntime().availableProcessors();

    /**
     * 线程池
     */
    private static final ExecutorService executorService = Executors.newFixedThreadPool(4);
    public static void main(String[] args) {
        String str = "12";
        JSONObject param = new JSONObject(str);
        System.out.println(param);
        JSONObject jsonObject = param.getJSONObject("data");
        System.out.println("传过来的data数据:"+jsonObject);
        String inputcode =param.getString("inputcode");
        System.out.println("inputcode:"+inputcode);
        JSONObject address = jsonObject.getJSONObject("address");
        System.out.println("真正的address:"+address);
        JSONObject userinfo = jsonObject.getJSONObject("userinfo");
        System.out.println("真正的userinfo:"+userinfo);
    }
    /**
     * 根据已有结果集进行业务轮询
     *
     * @param logicName LOGIC名称
     * @param values    LOGIC参数，condition为结果集
     * @param request   HttpServletRequest
     */
    @POST
    @Path("batchRun/{logicName}")
    public Object batchRunByResult(@PathParam("logicName") String logicName, String values, @Context HttpServletRequest request) {
        LOGGER.debug("传来的数据:"+values);
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject batchParam = data.getJSONObject("batchParam");
        //打印一下
        LOGGER.info(batchParam);
        JSONObject jobParam = data.getJSONObject("jobParam");
        Object result = doBusinessBySqlResult(logicName, values, jobParam, batchParam, request);
        return result;
    }
    @POST
    @Path("batchRun/quickTimerExecute")
    public Object quickTimerExecute(){
        String updateResult = "0";
        try {
            LOGGER.debug("BatchJobTimer定时执行批量任务立即执行");
            String executeData = logicService.xtSave("getExecuteParam", "{data:{}}");
            if (executeData!=null){

                JSONObject jsonObject = new JSONObject(executeData);
                int code = jsonObject.getInt("code");
                if (code<2000){
                    int jobId = jsonObject.getInt("jobId");
                    Object o = leisureExecute(jsonObject);
                    if (o != "0"){
                        updateResult = logicService.xtSave("getExecuteParam", "{data:{"+"jobId:"+jobId+"}}");
                        LOGGER.debug("执行完毕"+updateResult);
                    }
                    logicService.xtSave("testLogicJob",jsonObject.toString());
                }
            }else {
                LOGGER.debug("没有可执行的任务数据"+updateResult);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
        return  updateResult;
    }
    /**
     * 根据SQL名称和参数进行业务轮询
     *
     * @param logicName LOGIC名称
     * @param sqlName   SQL名称
     * @param values    包含了LOGIC参数和SQL参数
     * @param request   HttpServletRequest
     */
    @POST
    @Path("batchRun/{logicName}/{sqlName}")
    public Object batchRunByName(@PathParam("logicName") String logicName, @PathParam("sqlName") String sqlName, String values, @Context HttpServletRequest request) {
        LOGGER.debug("传来的数据:"+values);
        //打印一下
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject) data.get("jobParam");
        JSONObject sqlParam = data.getJSONObject("sqlParam");
        Object result =doBusinessBySqlName(logicName, jobParam, sqlName, sqlParam, request);
        return result;
    }


    /**
     * 根据SQL名称和参数进行业务轮询
     *
     * @param logicName LOGIC名称
     * @param batchName   SQL名称
     * @param values    包含了LOGIC参数和SQL参数
     * @param request   HttpServletRequest
     */
    @POST
    @Path("batchRunNew/{logicName}/{batchName}")
    public Object batchRunByResultName(@PathParam("logicName") String logicName, @PathParam("batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug("传来的数据:"+values);
        //打印一下
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject) data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data",batchParam);
        Object result =doBusinessByLogicName(logicName, jobParam, batchName, params, request);
        return result;
    }
    @POST
    @Path("batchRunAudit/{logicName}/{batchName}")
    public Object batchRunByResultNameAudit(@PathParam("logicName") String logicName, @PathParam("batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug("传来的数据:"+values);
        //打印一下
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data",batchParam);
        Object result =doBusinessByLogicNameAudit(logicName, batchName, params);
        return result;
    }
    /**
     * 根据SQL名称和参数进行业务轮询
     *
     * @param logicName LOGIC名称
     * @param batchName   batch名称
     * @param values    包含了LOGIC参数和SQL参数
     * @param request   HttpServletRequest
     */
    @POST
    @Path("batchRunExcel/{logicName}/{batchName}")
    public Object batchRunByExcelImport(@PathParam("logicName") String logicName, @PathParam("batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug("传来的数据:"+values);
        //打印一下
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject) data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data",batchParam);
        Util util = new Util();
        if(batchParam.getString("uuid")!= null && !"".equals(batchParam.getString("uuid"))){
            Object result =doBusinessByExcel(logicName, jobParam, batchName, params, request);
            return result;
        }else {
            util.error(new JSONObject("{status:801,msg:\"无法获取uuid,请联系管理员\"}"));
            return null;
        }
    }
    @POST
    @Path("batchRunExcelDefault/{logicName}/{batchName}")
    public Object batchRunByExcelImportDefault(@PathParam("logicName") String logicName, @PathParam("batchName") String batchName, String values, @Context HttpServletRequest request) {
        LOGGER.debug("传来的数据:"+values);
        //打印一下
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject) data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data",batchParam);
        Object result =doBusinessByExcelDefault(logicName, jobParam, batchName, params, request);
        return result;
    }
    @POST
    @Path("batchRunExcelProgress/{logicName}/{batchName}")
    public Object batchRunByExcelImportProgress(@PathParam("logicName") String logicName, @PathParam("batchName") String batchName, String values, @Context HttpServletRequest request) {
        //打印一下
        JSONObject params = new JSONObject(values);
        JSONObject data = params.getJSONObject("data");
        JSONObject jobParam = (JSONObject) data.get("jobParam");
        JSONObject batchParam = data.getJSONObject("batchParam");
        params.put("data",batchParam);
        Object result =doBusinessByExcelProgress(logicName, jobParam, batchName, params, request);
        return result;
    }
    /**
     * 根据已有SQL结果集进行业务轮询
     *
     * @param logicName LOGIC名称
     * @param values    LOGIC参数
     * @param jobParam    任务参数
     * @param batchParam   批量执行参数
     * @param request   HttpServletRequest
     */
    private Object doBusinessBySqlResult(String logicName, String values,JSONObject jobParam, JSONObject batchParam, HttpServletRequest request) {
        JSONArray sqlResult = batchParam.getJSONArray("con");
        return doBusiness(logicName, batchParam,jobParam,sqlResult, null, null, request);
    }

    /**
     * 根据SQL名称和参数进行业务轮询
     *
     * @param logicName LOGIC名称
     * @param jobParam    LOGIC参数
     * @param sqlName   SQL名称
     * @param sqlParams SQL参数
     * @param request   HttpServletRequest
     */
    private Object doBusinessBySqlName(String logicName, JSONObject jobParam, String sqlName, JSONObject sqlParams, HttpServletRequest request) {
        return doBusiness(logicName, jobParam, null, sqlName, sqlParams, request);

    }

    /**
     * 根据SQL名称和参数进行业务轮询
     *
     * @param logicName LOGIC名称
     * @param jobParam    LOGIC参数
     * @param batchName   batch名称
     * @param batchParams batch参数
     * @param request   HttpServletRequest
     */
    private Object doBusinessByLogicName(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result= "{\"data\":{}}";
        try {
            result = logicService.xtSave(batchName, batchParams.toString());
        }catch (Exception e){
            LOGGER.error(e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        return doBusiness(logicName, batchParam,jobParam,logicResult, null, null, request);
    }
    private Object doBusinessByLogicNameAudit(String logicName,  String batchName, JSONObject batchParams) {
        String result= "{\"data\":{}}";
        try {
            result = logicService.xtSave(batchName, batchParams.toString());
        }catch (Exception e){
            LOGGER.error(e);
        }
        JSONObject batchParam = new JSONObject(result);
        return doBusinessAudit(logicName, batchParam);
    }
    private Object doBusinessSingleProgress(String logicName, JSONObject batchParam,JSONObject jobParam, JSONArray sqlResult, String sqlName, String sqlParams, HttpServletRequest request) {
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        JSONObject results;
        String operator = jobParam.getString("operator");
        String jobType =  jobParam.getString("jobType");
        jobData.put("operator",operator);
        jobData.put("jobType",jobType+"【立即执行】");
        //组织执行数据
        JSONObject data = new JSONObject();
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        //轮询执行依据
        JSONArray resultArray;
        if (sqlName != null) {
            // 通过SQL名称和参数执行SQL，然后将得到的SQL结果集作为轮询依据
            resultArray = getSqlResult(sqlName, sqlParams);
        } else {
            // 传入的SQL结果集作为轮询依据
            resultArray = sqlResult;
        }
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id",0);
            jobData.put("job_name",operator+jobType+resultArray.length());
            jobData.put("count",resultArray.length());
            jobData.put("operator_id",jobParam.get("f_operatorid"));
            jobData.put("content",batchParam);
            //当前进度
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress",1);
            try {
                endData.put("data",jobData);
                String result = logicService.xtSave("addJobBuniness", endData.toString());
                results = new JSONObject(result);
                int id = results.getInt("jobId");
                jobData.put("id",id);
            } catch (Exception e) {
                LOGGER.error(e);
            }
            for (Object o : resultArray) {
                try {
                    System.out.println(o);
                    //追加请求数据
                    batchParam.put("con",o);
                    batchParam.put("logicName",logicName);
                    //执行Logic
                    runLogic("batchjobtemplate", batchParam, request, countData);
                    /**
                     * 测试logic
                     * runLogic("testLogicJob", data.getJSONObject("object"), request, countData);
                     */
                    int progress = ai.getAndIncrement();
                    LOGGER.info("======业务流程[" + logicName + "]批量执行中：" +
                            "总数：" + countData.getInt("total") + ", 当前：" + progress + "=======");
                    jobData.put("progress",progress);
                    /**
                     * 每到三分之一执行一次
                     */
                    if (countData.getInt("total") == progress || countData.getInt("total") == 3 * progress || 2 * countData.getInt("total") == 3 * progress){
                        endData.put("data",jobData);
                        String result = logicService.xtSave("addJobBuniness", endData.toString());
                        JSONObject inresults = new JSONObject(result);
                        int getId = inresults.getInt("jobId");
                        if (getId != 0){
                            jobData.put("id",getId);
                        }
                        LOGGER.info("更新jobData:"+jobData.toString());
                    }
                } catch (Exception e) {
                    LOGGER.error(e);
                }
            }
            LOGGER.info("======业务流程[" + logicName + "]批量执行结束，错误数：" + countData.getInt("errorCount") + "=======");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalsum",countData.getInt("total"));
            jsonObject.put("errorsum",countData.getInt("errorCount"));
            jsonObject.put("successnum",countData.getInt("total") - countData.getInt("errorCount"));
            return jsonObject.toString();
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
            return "0";
        }

    }

    /**
     *单线程加redis进度
     * @param logicName
     * @param jobParam
     * @param batchName
     * @param batchParams
     * @param request
     * @return
     */
    private Object doBusinessByExcel(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result= "{\"data\":{}}";
        try {
            result = logicService.xtSave(batchName, batchParams.toString());
        }catch (Exception e){
            LOGGER.error(e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        return doBusinessExcel(logicName, batchParam,jobParam,logicResult, null, batchParams.getJSONObject("data"), request);

    }

    /**
     * 单线程
     * @param logicName
     * @param jobParam
     * @param batchName
     * @param batchParams
     * @param request
     * @return
     */
    private Object doBusinessByExcelDefault(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result= "{\"data\":{}}";
        try {
            result = logicService.xtSave(batchName, batchParams.toString());
        }catch (Exception e){
            LOGGER.error(e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        int totalcount = batchParam.getInt("totalsum");
        return doBusinessExcelDefault(logicName, batchParam,jobParam,logicResult,totalcount, null, batchParams.getJSONObject("data"), request);

    }

    /**
     * 多线程excel导入
     * @param logicName
     * @param jobParam
     * @param batchName
     * @param batchParams
     * @param request
     * @return
     */
    private Object doBusinessByExcelProgress(String logicName, JSONObject jobParam, String batchName, JSONObject batchParams, HttpServletRequest request) {
        String result= "{\"data\":{}}";
        try {
            result = logicService.xtSave(batchName, batchParams.toString());
        }catch (Exception e){
            LOGGER.error(e);
        }
        JSONObject batchParam = new JSONObject(result);
        JSONArray logicResult = batchParam.getJSONArray("con");
        int totalcount = batchParam.getInt("totalsum");
        return doBusinessExcelProgress(logicName, batchParam,jobParam,logicResult,totalcount, null, batchParams.getJSONObject("data"), request);

    }
    /**
     * 执行单个业务
     *
     * @param logicName Logic名称
     */
    private Object doBusiness(String logicName, JSONObject jobParam, JSONArray sqlResult, String sqlName, JSONObject sqlParams, HttpServletRequest request) {
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        JSONObject results;
        String operator = jobParam.getString("operator");
        String jobType = jobParam.getString("jobType");
        jobData.put("operator", operator);
        jobData.put("jobType", jobType+"【闲时执行,将在夜间0-5点执行】");
        //轮询执行依据
        JSONArray resultArray;
        if (sqlName != null) {
            // 通过SQL名称和参数执行SQL，然后将得到的SQL结果集作为轮询依据
            resultArray = getSqlResult(sqlName,sqlParams.toString());
        } else {
            // 传入的SQL结果集作为轮询依据
            resultArray = sqlResult;
        }
        String auditPerson = sqlParams.getString("f_audit_person");
        JSONArray paramArray = new JSONArray();
        if (resultArray != null&&resultArray.length()>0){
            for (int i = 0; i < resultArray.length(); i++) {
                JSONObject jsonObject = (JSONObject) resultArray.get(i);
                JSONObject newParam = new JSONObject();
                newParam.put("f_audit_person",auditPerson);
                newParam.put("f_hand_id",jsonObject.get("id"));
                newParam.put("f_tablebase",jsonObject.get("f_tablebase"));
                newParam.put("f_meter_classify",jsonObject.get("f_meter_classify"));
                newParam.put("f_meter_brand",jsonObject.get("f_meter_brand"));
                paramArray.put(newParam);
            }
        }
        int jobId = 0;
        String result = "";
        if (paramArray != null && paramArray.length() > 0) {
            jobData.put("job_name", operator + jobType + resultArray.length());
            jobData.put("count", resultArray.length());
            jobData.put("operator_id", jobParam.get("f_operatorid"));
            jobData.put("progress", 0);
            jobData.put("id", 0);
            jobData.put("content",paramArray);
            try {
                endData.put("data", jobData);
                result = logicService.xtSave("addJobBuniness", endData.toString());
                results = new JSONObject(result);
                jobId = results.getInt("jobId");
            } catch (Exception e) {
                LOGGER.error(e);
            }
            try {
                JSONObject batchParam =new JSONObject();
                batchParam.put("con",paramArray);
                batchParam.put("f_job_id",jobId);
                batchParam.put("logicName",logicName);
                endData.put("data",batchParam);
                result = logicService.xtSave("batchJobTimer", endData.toString());
            }catch (Exception e){
                LOGGER.error(e);
            }
            return result;
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
            return "0";
        }

    }
    private Object doBusiness(String logicName, JSONObject batchParam,JSONObject jobParam, JSONArray sqlResult, String sqlName, String sqlParams, HttpServletRequest request) {
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        JSONObject results;
        String operator = jobParam.getString("operator");
        String jobType =  jobParam.getString("jobType");
        jobData.put("operator",operator);
        jobData.put("jobType",jobType+"【立即执行】");
        //组织执行数据
        JSONObject data = new JSONObject();
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        //轮询执行依据
        JSONArray resultArray;
        if (sqlName != null) {
            // 通过SQL名称和参数执行SQL，然后将得到的SQL结果集作为轮询依据
            resultArray = getSqlResult(sqlName, sqlParams);
        } else {
            // 传入的SQL结果集作为轮询依据
            resultArray = sqlResult;
        }
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id",0);
            jobData.put("job_name",operator+jobType+resultArray.length());
            jobData.put("count",resultArray.length());
            jobData.put("operator_id",jobParam.get("f_operatorid"));
            jobData.put("content",batchParam);
            //当前进度
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress",1);
            try {
                endData.put("data",jobData);
                String result = logicService.xtSave("addJobBuniness", endData.toString());
                results = new JSONObject(result);
                int id = results.getInt("jobId");
                jobData.put("id",id);
            } catch (Exception e) {
                LOGGER.error(e);
            }
            resultArray.forEach(item -> executorService.execute(() ->{
                        try {
                            JSONObject exeParam = new JSONObject();
                            //追加请求数据
                            exeParam.put("con",item);
                            exeParam.put("logicName",logicName);
                            //执行Logic
                            runLogic("batchjobtemplate", exeParam, request, countData);
                            /**
                             * 测试logic
                             * runLogic("testLogicJob", data.getJSONObject("object"), request, countData);
                             */
                            int progress = ai.getAndIncrement();
                            LOGGER.info("======业务流程[" + logicName + "]批量执行中：" +
                                    "总数：" + countData.getInt("total") + ", 当前：" + progress + "=======");
                            jobData.put("progress",progress);
                            /**
                             * 每到三分之一执行一次
                             */
                            if (countData.getInt("total") == progress || countData.getInt("total") == 3 * progress || 2 * countData.getInt("total") == 3 * progress){
                                endData.put("data",jobData);
                                String result = logicService.xtSave("addJobBuniness", endData.toString());
                                JSONObject inresults = new JSONObject(result);
                                int getId = inresults.getInt("jobId");
                                if (getId != 0){
                                    jobData.put("id",getId);
                                }
                                LOGGER.info("更新jobData:"+jobData.toString());
                            }
                        } catch (Exception e) {
                            LOGGER.error(e);
                        }
                    })
            );
            LOGGER.info("======业务流程[" + logicName + "]批量执行结束，错误数：" + countData.getInt("errorCount") + "=======");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalsum",countData.getInt("total"));
            jsonObject.put("errorsum",countData.getInt("errorCount"));
            jsonObject.put("successnum",countData.getInt("total") - countData.getInt("errorCount"));
            return jsonObject.toString();
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
            return "0";
        }

    }
    private Object doBusinessAudit(String logicName, JSONObject batchParam) {
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        //轮询执行依据
        int total = batchParam.getInt("total");
        String cond = batchParam.getString("condition");
        String f_mark = batchParam.getString("f_mark");
        String tableName = batchParam.getString("tableName");
        batchParam.remove("f_mark");
        int size = total%1000>0?(total/1000)+1:total/1000;
        if (total>0){
            JSONObject countData = new JSONObject();
            countData.put("index", 1);
            countData.put("errorCount", 0);
            countData.put("total", total);
            AtomicInteger ai = new AtomicInteger(1000);
            JSONArray resultArray = new JSONArray();
            for (int i = 0; i < size; i++) {
                resultArray.put(ai.getAndAdd(1000));
            }
            batchParam.put("logicName",logicName);
            CountDownLatch latch = new CountDownLatch(size);
            resultArray.forEach(item->
                executorService.execute(() ->{
                    try {
                        JSONObject exeParam = new JSONObject();
                        exeParam.put("tableName",tableName);
                        exeParam.put("logicName",logicName);
                        exeParam.put("condition",cond);
                        exeParam.put("endNum",item);
                        runLogic("batchjobtemplate", exeParam,null,countData);
                    }catch (Exception e){
                        LOGGER.error(e);
                    }finally {
                        latch.countDown();
                    }
                })
            );
            try {
                latch.await();
                batchParam.put("f_mark",f_mark);
                String phoneSum = runLogic("batchjobtemplate", batchParam, null, countData);
            }catch (InterruptedException e){
                e.printStackTrace();
            }

            JSONObject jsonObject = new JSONObject();
            jsonObject.put("totalsum",countData.getInt("total"));
            jsonObject.put("errorsum",countData.getInt("errorCount"));
            jsonObject.put("successnum",countData.getInt("total") - countData.getInt("errorCount"));
            return jsonObject.toString();
        } else {
        LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
        return "0";
        }
    }

    /**
     * 多线程导入
     * @param logicName
     * @param batchParam
     * @param jobParam
     * @param sqlResult
     * @param totalCount
     * @param sqlName
     * @param batchParams
     * @param request
     * @return
     */
    private Object doBusinessExcelProgress(String logicName, JSONObject batchParam,JSONObject jobParam, JSONArray sqlResult,int totalCount, String sqlName, JSONObject batchParams, HttpServletRequest request){
        JSONObject result = new JSONObject();
        result.put("totalsum",0);
        result.put("successsum",0);
        result.put("errorsum",0);
        result.put("code",200);
        result.put("msg","导入完成");
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        JSONObject results;
        String operator = jobParam.getString("operator");
        String jobType =  jobParam.getString("jobType");
        jobData.put("operator",operator);
        jobData.put("jobType",jobType+"【立即执行】");
        //组织执行数据
        JSONObject data = new JSONObject();
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        //轮询执行依据
        JSONArray resultArray;
        if (sqlName != null) {
            // 通过SQL名称和参数执行SQL，然后将得到的SQL结果集作为轮询依据
            resultArray = null;
        } else {
            // 传入的SQL结果集作为轮询依据
            resultArray = sqlResult;
        }
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id",0);
            jobData.put("job_name",operator+jobType+resultArray.length());
            jobData.put("count",resultArray.length());
            jobData.put("operator_id",jobParam.get("f_operatorid"));
            jobData.put("content",logicName);
            //当前进度
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress",1);
            try {
                endData.put("data",jobData);
                String result1 = logicService.xtSave("addJobBuniness", endData.toString());
                results = new JSONObject(result1);
                int id = results.getInt("jobId");
                jobData.put("id",id);
            } catch (Exception e) {
                LOGGER.error(e);
            }
            CountDownLatch latch = new CountDownLatch(resultArray.length());
            resultArray.forEach(item->executorService.execute(()->{
                try {
                    JSONObject exeParam = new JSONObject();
                    //追加请求数据
                    exeParam.put("con",item);
                    exeParam.put("logicName",logicName);
                    //执行Logic
                    runLogic("batchjobtemplate", exeParam, request, countData);
                    /**
                     * 测试logic
                     * runLogic("testLogicJob", data.getJSONObject("object"), request, countData);
                     */
                    int progress = ai.getAndIncrement();
                    LOGGER.info("======业务流程[" + logicName + "]批量执行中：" +
                            "总数：" + countData.getInt("total") + ", 当前：" + progress + "=======");
                    jobData.put("progress",progress);
                    /**
                     * 每到三分之一执行一次
                     */
                    if (countData.getInt("total") == progress || countData.getInt("total") == 3 * progress || 2 * countData.getInt("total") == 3 * progress){
                        endData.put("data",jobData);
                        String result1 = logicService.xtSave("addJobBuniness", endData.toString());
                        JSONObject inresults = new JSONObject(result1);
                        int getId = inresults.getInt("jobId");
                        if (getId != 0){
                            jobData.put("id",getId);
                        }
                        LOGGER.info("更新jobData:"+jobData.toString());
                    }
                } catch (Exception e) {
                    LOGGER.error(e);
                }finally {
                    latch.countDown();
                }
            }));
            try {
                latch.await();
            }catch (InterruptedException e){
                LOGGER.error(e);
            }
            LOGGER.info("======业务流程[" + logicName + "]批量执行结束，错误数：" + countData.getInt("errorCount") + "=======");
            result.put("totalCount",totalCount);
            result.put("totalsum",countData.getInt("total"));
            result.put("errorsum",countData.getInt("errorCount"));
            result.put("successsum",countData.getInt("total") - countData.getInt("errorCount"));
            result.put("msg","导入完成");
            return result.toString();
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
            return "0";
        }

    }

    /**
     * 单线程excel导入
     * @param logicName
     * @param batchParam
     * @param jobParam
     * @param sqlResult
     * @param totalCount
     * @param sqlName
     * @param batchParams
     * @param request
     * @return
     */
    private Object doBusinessExcelDefault(String logicName, JSONObject batchParam,JSONObject jobParam, JSONArray sqlResult,int totalCount, String sqlName, JSONObject batchParams, HttpServletRequest request){
        JSONObject result = new JSONObject();
        result.put("speed",0);
        result.put("totalsum",0);
        result.put("successsum",0);
        result.put("errorsum",0);
        result.put("code",200);
        result.put("msg","导入完成");
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        JSONObject results;
        String operator = jobParam.getString("operator");
        String jobType =  jobParam.getString("jobType");
        jobData.put("operator",operator);
        jobData.put("jobType",jobType+"【立即执行】");
        //组织执行数据
        JSONObject data = new JSONObject();
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        //轮询执行依据
        JSONArray resultArray;
        if (sqlName != null) {
            // 通过SQL名称和参数执行SQL，然后将得到的SQL结果集作为轮询依据
            resultArray = null;
        } else {
            // 传入的SQL结果集作为轮询依据
            resultArray = sqlResult;
        }
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id",0);
            jobData.put("job_name",operator+jobType+resultArray.length());
            jobData.put("count",resultArray.length());
            jobData.put("operator_id",jobParam.get("f_operatorid"));
            jobData.put("content",batchParam);
            //当前进度
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress",1);
            try {
                endData.put("data",jobData);
                LOGGER.info("*************2");
                String result1 = logicService.xtSave("addJobBuniness", endData.toString());
                results = new JSONObject(result1);
                int id = results.getInt("jobId");
                jobData.put("id",id);
            } catch (Exception e) {
                LOGGER.error(e);
            }
            for (Object o : resultArray) {
                try {
                    System.out.println(o);
                    //追加请求数据
                    batchParam.put("con",o);
                    batchParam.put("logicName",logicName);
                    //执行Logic
                    runLogic("batchjobtemplate", batchParam, request, countData);
                    /**
                     * 测试logic
                     * runLogic("testLogicJob", data.getJSONObject("object"), request, countData);
                     */
                    int progress = ai.getAndIncrement();
                    BigDecimal total = CommonTools.mul(CommonTools.div(progress, countData.getInt("total")), 100, 0);
                    result.put("speed",total);
                    if( result.getBigDecimal("speed").compareTo(new BigDecimal(100))==0 || result.getBigDecimal("speed").compareTo(new BigDecimal(100)) >0){
                        result.put("speed",99);
                    }
                    LOGGER.info("======业务流程[" + logicName + "]批量执行中：" +
                            "总数：" + countData.getInt("total") + ", 当前：" + progress + "=======");
                    jobData.put("progress",progress);
                    /**
                     * 每到三分之一执行一次
                     */
                    if (countData.getInt("total") == progress || countData.getInt("total") == 3 * progress || 2 * countData.getInt("total") == 3 * progress){
                        endData.put("data",jobData);
                        String result1 = logicService.xtSave("addJobBuniness", endData.toString());
                        JSONObject inresults = new JSONObject(result1);
                        int getId = inresults.getInt("jobId");
                        if (getId != 0){
                            jobData.put("id",getId);
                        }
                        LOGGER.info("更新jobData:"+jobData.toString());
                    }
                } catch (Exception e) {
                    LOGGER.error(e);
                }
            }
            LOGGER.info("======业务流程[" + logicName + "]批量执行结束，错误数：" + countData.getInt("errorCount") + "=======");
            result.put("speed",100);
            result.put("totalCount",totalCount);
            result.put("totalsum",countData.getInt("total"));
            result.put("errorsum",countData.getInt("errorCount"));
            result.put("successsum",countData.getInt("total") - countData.getInt("errorCount"));
            result.put("msg","导入完成");
            return result.toString();
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
            return "0";
        }

    }

    /**
     * excel+redis进度
     * @param logicName
     * @param batchParam
     * @param jobParam
     * @param sqlResult
     * @param sqlName
     * @param batchParams
     * @param request
     * @return
     */
    private Object doBusinessExcel(String logicName, JSONObject batchParam,JSONObject jobParam, JSONArray sqlResult, String sqlName, JSONObject batchParams, HttpServletRequest request){
        Util util = new Util();
        JSONObject result = new JSONObject();
        result.put("speed",0);
        result.put("totalsum",0);
        result.put("successsum",0);
        result.put("errorsum",0);
        result.put("code",200);
        result.put("msg","导入完成");
        try{
            timeCache.setCahce(batchParams.getString("uuid"),result);
        }catch(Exception e){
            util.error(new JSONObject("{status:605,msg:\"导入失败,请联系管理员，redis未连接！\"}"));
        }
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        JSONObject results;
        String operator = jobParam.getString("operator");
        String jobType =  jobParam.getString("jobType");
        jobData.put("operator",operator);
        jobData.put("jobType",jobType+"【立即执行】");
        //组织执行数据
        JSONObject data = new JSONObject();
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        //轮询执行依据
        JSONArray resultArray;
        if (sqlName != null) {
            // 通过SQL名称和参数执行SQL，然后将得到的SQL结果集作为轮询依据
            resultArray = null;
        } else {
            // 传入的SQL结果集作为轮询依据
            resultArray = sqlResult;
        }
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id",0);
            jobData.put("job_name",operator+jobType+resultArray.length());
            jobData.put("count",resultArray.length());
            jobData.put("operator_id",jobParam.get("f_operatorid"));
            jobData.put("content",batchParam);
            //当前进度
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress",1);
            try {
                endData.put("data",jobData);
                LOGGER.info("*************2");
                String result1 = logicService.xtSave("addJobBuniness", endData.toString());
                results = new JSONObject(result1);
                int id = results.getInt("jobId");
                jobData.put("id",id);
            } catch (Exception e) {
                LOGGER.error(e);
            }
            for (Object o : resultArray) {
                try {
                    System.out.println(o);
                    //追加请求数据
                    batchParam.put("con",o);
                    batchParam.put("logicName",logicName);
                    //执行Logic
                    runLogic("batchjobtemplate", batchParam, request, countData);
                    /**
                     * 测试logic
                     * runLogic("testLogicJob", data.getJSONObject("object"), request, countData);
                     */
                    int progress = ai.getAndIncrement();
                    BigDecimal total = CommonTools.mul(CommonTools.div(progress, countData.getInt("total")), 100, 0);
                    result.put("speed",total);
                    if( result.getBigDecimal("speed").compareTo(new BigDecimal(100))==0 || result.getBigDecimal("speed").compareTo(new BigDecimal(100)) >0){
                        result.put("speed",99);
                    }
                    timeCache.setCahce(batchParams.getString("uuid"),result);
                    LOGGER.info("======业务流程[" + logicName + "]批量执行中：" +
                            "总数：" + countData.getInt("total") + ", 当前：" + progress + "=======");
                    jobData.put("progress",progress);
                    /**
                     * 每到三分之一执行一次
                     */
                    if (countData.getInt("total") == progress || countData.getInt("total") == 3 * progress || 2 * countData.getInt("total") == 3 * progress){
                        endData.put("data",jobData);
                        String result1 = logicService.xtSave("addJobBuniness", endData.toString());
                        JSONObject inresults = new JSONObject(result1);
                        int getId = inresults.getInt("jobId");
                        if (getId != 0){
                            jobData.put("id",getId);
                        }
                        LOGGER.info("更新jobData:"+jobData.toString());
                    }
                } catch (Exception e) {
                    LOGGER.error(e);
                }
            }
            LOGGER.info("======业务流程[" + logicName + "]批量执行结束，错误数：" + countData.getInt("errorCount") + "=======");
            result.put("speed",100);
            result.put("totalsum",countData.getInt("total"));
            result.put("errorsum",countData.getInt("errorCount"));
            result.put("successsum",countData.getInt("total") - countData.getInt("errorCount"));
            result.put("msg","导入完成");
            try{
                timeCache.setCahce(batchParams.getString("uuid"),result);
            }catch(Exception e){
                util.error(new JSONObject("{status:605,msg:\"导入失败,请联系管理员，redis未连接！\"}"));
            }
            return result.toString();
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
            return "0";
        }

    }

    /**
     * 获取业务执行所需SQL的结果集
     *
     * @param sqlName SQL名称
     * @param sqlData SQL请求参数
     * @return 结果集
     */
    private JSONArray getSqlResult(String sqlName, String sqlData) {
        if (SqlMapper.getSql(sqlName) == null) {
            LOGGER.info("未找到名为【" + sqlName + "】的SQL映射文件");
            return null;
        }
        //查询条件
        try {
            JSONObject params = new JSONObject();
            JSONObject conditionParam = new JSONObject(sqlData);
            params.put("data", conditionParam);
            LOGGER.info("sql组装data:"+params.toString());
            return new JSONArray(sqlService.txExecute(sqlName, 1, 9999999, params.toString()));
        } catch (Exception e) {
            LOGGER.error("出现异常：", e);
            return null;
        }
    }
    private String runLogic(String logicName, JSONObject data, HttpServletRequest request, JSONObject countData) {
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/auditConfig.json"));
        LOGGER.info("获取配置信息："+conf.toString());
        LOGGER.info("获取配置信息："+(boolean)conf.get("audit"));
        if ((boolean)conf.get("audit")){
            LOGGER.info("当前走的是调用audit服务");
            try {
                return RestTools.post(conf.get("auditUri")+"/rs/logic/"+logicName,data.toString());
            } catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        }else {
            try {
                return logicService.xtSave(logicName, data.toString());
            } catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        }
        return "0";
    }
    public void runLeiSureLogic(String logicName,JSONObject data, JSONObject countData) {
        ReadFile file = new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/auditConfig.json"));
        if ((boolean)conf.get("audit")){
            try {
                RestTools.post(conf.get("auditUri")+"/rs/logic/"+logicName,data.toString());
            } catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        }else {
            try {
                logicService.xtSave(logicName, data.toString());
            } catch (Exception e) {
                int errorCount = countData.getInt("errorCount") + 1;
                countData.put("errorCount", errorCount);
            }
        }
    }
    public void meterDownBatchAudit(String logicName, JSONObject batchParam){
        doBusinessAudit(logicName,batchParam);
    }
    public void meterDownBatch(JSONObject batchParam){
        String logicName = batchParam.getString("logicName");
        JSONArray executeParam = batchParam.getJSONArray("executeParam");
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        //轮询执行依据
        JSONArray resultArray;
        // 传入的SQL结果集作为轮询依据
        batchParam.remove("executeParam");
        resultArray = executeParam;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            AtomicInteger ai = new AtomicInteger(1);
            resultArray.forEach(item -> executorService.execute(() ->{
                        try {
                            JSONObject exeParam = new JSONObject();
                            //追加请求数据
                            exeParam.put("logicName",logicName);
                            exeParam.put("con",item);
                            //执行Logic
                            runLeiSureLogic("batchjobtemplate", exeParam, countData);
                            /**
                             * 测试logic
                             * runLeiSureLogic("testLogicJob", batchParam, countData);
                             */
                            LOGGER.info("======业务流程[" + logicName + "]批量执行中：" +
                                    "总数：" + countData.getInt("total") + ", 当前：" + ai.getAndIncrement() + "=======");
                        } catch (Exception e) {
                            LOGGER.error(e);
                        }
                    })
            );
            LOGGER.info("======业务流程[" + logicName + "]批量执行结束，错误数：" + countData.getInt("errorCount") + "=======");
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
        }
    }
    public Object leisureExecute(JSONObject batchParam){
        JSONObject jobData = new JSONObject();
        JSONObject endData = new JSONObject();
        new JSONObject();
        JSONObject results;
        String logicName = batchParam.getString("logicName");
        int jobId = batchParam.getInt("jobId");
        JSONArray executeParam = batchParam.getJSONArray("executeParam");
        //开始执行业务
        LOGGER.info("======开始执行批量[" + logicName + "]业务流程======");
        batchParam.remove("executeParam");
        //轮询执行依据
        JSONArray resultArray;
        // 传入的SQL结果集作为轮询依据
        resultArray = executeParam;
        if (resultArray != null && resultArray.length() > 0) {
            JSONObject countData = new JSONObject();
            countData.put("total", resultArray.length());
            jobData.put("count",resultArray.length());
            countData.put("index", 1);
            countData.put("errorCount", 0);
            jobData.put("id",jobId);
            //当前进度
            AtomicInteger ai = new AtomicInteger(1);
            jobData.put("progress",1);
            try {
                endData.put("data",jobData);
                String result = logicService.xtSave("addJobBuniness", endData.toString());
                results = new JSONObject(result);
                int id = results.getInt("jobId");
                jobData.put("id",id);
            } catch (Exception e) {
                LOGGER.error(e);
            }
            JSONArray paramArray = new JSONArray();
            for (int i = 0; i < resultArray.length(); i++) {
                JSONObject jsonObject = (JSONObject) resultArray.get(i);
                JSONObject executeContent = new JSONObject(jsonObject.getString("f_execute_content"));
                paramArray.put(executeContent);
            }
            LOGGER.info("组织数据:"+paramArray);
            paramArray.forEach(item -> executorService.execute(() ->{
                        try {
                            //追加请求数据
                            JSONObject exeParam = new JSONObject();
                            exeParam.put("con",item);
                            exeParam.put("logicName",logicName);
                            //执行Logic
                            runLeiSureLogic("batchjobtemplate", exeParam, countData);
                            /**
                             * 测试logic
                             * runLeiSureLogic("testLogicJob", batchParam, countData);
                             */
                            int progress = ai.getAndIncrement();
                            LOGGER.info("======业务流程[" + logicName + "]批量执行中：" +
                                    "总数：" + countData.getInt("total") + ", 当前：" + progress + "=======");
                            jobData.put("progress",progress);
                            /**
                             * 每到三分之一执行一次
                             */
                            if (countData.getInt("total") == progress || countData.getInt("total") == 3 * progress || 2 * countData.getInt("total") == 3 * progress){
                                endData.put("data",jobData);
                                String result = logicService.xtSave("addJobBuniness", endData.toString());
                                JSONObject inresults = new JSONObject(result);
                                int getId = inresults.getInt("jobId");
                                if (getId != 0){
                                    jobData.put("id",getId);
                                }
                                LOGGER.info("更新jobData:"+jobData.toString());
                            }
                        } catch (Exception e) {
                            LOGGER.error(e);
                        }
                    })
            );
            LOGGER.info("======业务流程[" + logicName + "]批量执行结束，错误数：" + countData.getInt("errorCount") + "=======");
            return ""+(countData.getInt("total") - countData.getInt("errorCount"));
        } else {
            LOGGER.info("======业务流程[" + logicName + "]批量执行未执行：没有需要轮询的数据");
            return "0";
        }
    }
}
