package com.aote.rs;

import com.af.plugins.CommonTools;
import com.af.plugins.DataSectionTools;
import com.af.plugins.DateTools;
import com.af.plugins.timeoutReturn.TimeCache;
import com.aote.logic.LogicServer;
import com.aote.plugins.impexp.FileManager;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import javax.ws.rs.POST;
import javax.ws.rs.Path;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;

/**
 * @Author: JoeCdy
 * @Description:
 * @Date: Created in 11:48 2022/4/22
 */
@Component
@Path("handPlanAudit")
public class BatchAuditMeterRead {
    static Logger log = Logger.getLogger(BatchAuditMeterRead.class);

    @Autowired
    private TimeCache timeCache;

    @Autowired
    private LogicServer logicServer;

    @Autowired
    private SqlService sqlService;

    @POST
    @Path("allAudit")
    public JSONObject allAudit(String values) throws Exception {
        log.debug("开始批量处理审核");
        JSONObject jsonObject = new JSONObject();
        JSONObject data = new JSONObject(values);
        String uuid = data.getString("uuid");
        try {
            log.debug("全部抄表审核" + data);
            timeCache.setCahce(uuid, jsonObject);
            JSONArray condition = data.getJSONArray("condition");
            int n = 0;
            int success = 0;
            int fail = 0;
            for (int i = 0; i < condition.length(); i++) {
                JSONObject row = condition.getJSONObject(i);
                JSONObject params = new JSONObject();
                params.put("f_hand_id", row.get("f_hand_id"));
                params.put("f_tablebase", row.get("f_tablebase"));
                params.put("f_meter_classify", row.get("f_meter_classify"));
                params.put("f_meter_brand", row.get("f_meter_brand"));
                params.put("f_audit_person", data.get("f_audit_person"));
                try {
                    logicServer.run("handPlanAudit", params);
                    success += 1;
                } catch (Exception e) {
                    fail += 1;
                    log.debug("单条抄表异常" + row.get("f_hand_id"), e);
                }
                n += 1;
                jsonObject.put("n", n);
                timeCache.setCahce(uuid, jsonObject);
            }
            jsonObject.put("n", n);
            jsonObject.put("sum", condition.length());
            jsonObject.put("success", success);
            jsonObject.put("fail", fail);
            jsonObject.put("msg", "抄表批量审核处理完成");
            timeCache.setCahce(uuid, jsonObject);
        } catch (Exception e) {
            log.debug("抄表批量审核处理异常", e);
            jsonObject.put("error", "抄表批量审核处理异常");
            timeCache.setCahce(uuid, jsonObject);
        }
        return jsonObject;
    }


    @POST
    @Path("cardBatchCommonEnter")
    public JSONObject cardBatchCommonEnter(String values) throws Exception {
        log.debug("卡表批量抄表");
        JSONObject jsonObject = new JSONObject();
        JSONObject data = new JSONObject(values);
        String uuid = data.getString("uuid");
        try {
            log.debug("卡表批量抄表开始:" + values);
            timeCache.setCahce(uuid, jsonObject);
            // 读取excel数据
            JSONArray datas = new FileManager().read(data.getString("filepath"), "batchCardEnter.json");
            // 数据分组
            JSONArray array = new DataSectionTools().get(datas.toString(), 1000);
            // 成功错误条数记录
            int n = 0;
            int success = 0;
            int fail = 0;
            ArrayList<Integer> failArr = new ArrayList<>();
            for (int i = 0; i < array.length(); i++) {
                JSONArray jsonArray = array.getJSONArray(i);
                HashMap<Integer, JSONObject> map = new HashMap<>();
                ArrayList<Integer> arr = new ArrayList<>();
                for (int j = 0; j < jsonArray.length(); j++) {
                    JSONObject row = jsonArray.getJSONObject(j).getJSONObject("batchCard");
                    arr.add(row.getInt("id"));
                    map.put(row.getInt("id"), row);
                }
                JSONObject sqlParam = new JSONObject();
                String ids = arr.toString().replace("[", "(").replace("]", ")");
                sqlParam.put("condition", "f_meter_state = '未抄表' and id in " + ids);
                sqlParam.put("orderitem", "id");
                // 待批量抄表的卡表数据
                JSONArray cardData = new JSONArray(sqlService.txExecute("getCardPlan", 1, 9999999, new JSONObject().put("data", sqlParam).toString()));
                for (int j = 0; j < cardData.length(); j++) {
                    try {
                        JSONObject row = cardData.getJSONObject(j);
                        JSONObject excelDate = map.get(row.getInt("id"));
                        String tablebase = excelDate.getString("f_tablebase");
                        String last_tablebase = String.valueOf(row.get("f_last_tablebase"));
                        String initial_base = String.valueOf(row.get("f_initial_base"));
                        if (!tablebase.matches("[0-9]+")) {
                            throw new RuntimeException("本期底数只能是整数");
                        }
                        if (CommonTools.sub(tablebase, last_tablebase).intValue() < 0) {
                            throw new RuntimeException("本期底数不能小于上期底数");
                        }
                        // 组织单条抄表数据
                        row.put("f_input_date", excelDate.getString("f_input_date"));
                        String f_last_input_date = String.valueOf(row.get("f_last_input_date"));
                        if ("".equals(f_last_input_date) || "null".equals(f_last_input_date)) {
                            row.put("f_last_input_date", excelDate.getString("f_input_date"));
                        }
                        row.put("f_operate_date", DateTools.getNow2());
                        row.put("f_orgid", data.getString("f_orgid"));
                        row.put("f_orgname", data.getString("f_orgname"));
                        row.put("f_depid", data.getString("f_depid"));
                        row.put("f_depname", data.getString("f_depname"));
                        row.put("f_operatorid", data.getString("f_operatorid"));
                        row.put("f_operator", data.getString("f_operator"));
                        row.put("f_meter_state", "已抄表");
                        String total_gas = String.valueOf(row.get("total_gas"));
                        row.put("f_total_gas", total_gas);
                        row.put("f_total_fee", row.get("total_fee"));
                        row.put("f_tablebase", tablebase);
                        BigDecimal shengyu_gas = CommonTools.sub(total_gas, CommonTools.sub(tablebase, initial_base), 2);
                        row.put("f_shengyu_gas", shengyu_gas);
                        logicServer.run("cardCommonEnter", row);
                        success += 1;
                    } catch (Exception e) {
                        fail += 1;
                        int id = cardData.getJSONObject(j).getInt("id");
                        failArr.add(id);
                        log.debug("单条卡表抄表异常:" + id, e);
                    }
                    n += 1;
                }
            }
            // 统一处理错误抄表 (暂留,先不处理)
//            if (failArr.size() > 0) {
//                String ids = failArr.toString().replace("[", "(").replace("]", ")");
//                sqlServer.runSQL("update t_cardhand set ");
//            }
            jsonObject.put("n", n);
            jsonObject.put("success", success);
            jsonObject.put("fail", fail);
            jsonObject.put("msg", "卡表抄表批量处理完成");
            timeCache.setCahce(uuid, jsonObject);
        } catch (Exception e) {
            log.debug("卡表批量抄表处理异常", e);
            jsonObject.put("error", "卡表批量抄表处理异常");
            timeCache.setCahce(uuid, jsonObject);
        }
        log.debug("卡表抄表批量返回:" + jsonObject);
        return jsonObject;
    }


}
