package com.aote.plugin;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import com.alibaba.excel.read.metadata.ReadSheet;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@Component
public class ReadExcel {
    private static final Logger logger = Logger.getLogger(ReadExcel.class);
    @Autowired
    private OperateMaterial operateMaterial;

    public JSONObject readExcelData(String data) throws Exception {
        JSONObject jsonObject = new JSONObject(data);
        ExcelReader excelReader = null;
        InputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(jsonObject.getString("filepath"));
            ModelDataListener modelDataListener = new ModelDataListener();
            excelReader = EasyExcel.read(fileInputStream, modelDataListener).build();
            ReadSheet readSheet = EasyExcel.readSheet(0).build();
            excelReader.read(readSheet);
            ReadSheet readDetailSheet = EasyExcel.readSheet(1).build();
            excelReader.read(readDetailSheet);
            List<Map<Integer, String>> headList = modelDataListener.getHeadList();
            List<Map<Integer, Object>> dataList = modelDataListener.getDataList();
            return operateMaterial.saveData(headList, dataList);
        } catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            JSONObject result = new JSONObject();
            result.put("code","500");
            result.put("msg","导入失败！！！");
            return result;
        } finally {
            fileInputStream.close();
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }
}
