package com.aote.plugin;

import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 用作保存excel导入的数据
 */
@Component
@Transactional
public class OperateMaterial {
    @Autowired
    private SqlServer sqlServer;

    private Logger logger = Logger.getLogger(OperateMaterial.class);
    /*
     * 存库操作
     */
    public JSONObject saveData(List<Map<Integer, String>> headList,List<Map<Integer, Object>> dataList) throws Exception{
        JSONObject result = new JSONObject();
        try{
            List<Object> orgList = new ArrayList<>();
            List<JSONObject> typeList = new ArrayList<>();
            List<JSONObject> nameList = new ArrayList<>();
            List<JSONObject> styleList = new ArrayList<>();
            for (Map<Integer,Object> map : dataList) {
                JSONObject jsonObject1 = new JSONObject();
                JSONObject jsonObject2 = new JSONObject();
                JSONObject jsonObject3 = new JSONObject();
                jsonObject1.put("name",map.get(3));
                jsonObject1.put("parentname",map.get(1));
                jsonObject1.put("price",map.get(4));
                jsonObject1.put("unit",map.get(5));
                jsonObject1.put("type",map.get(6));
                jsonObject1.put("code",map.get(2));
                jsonObject1.put("org",map.get(8));
                styleList.add(jsonObject1);
                jsonObject2.put("name",map.get(6));
                jsonObject2.put("org",map.get(8));
                typeList.add(jsonObject2);
                jsonObject3.put("parentname",map.get(6));
                jsonObject3.put("name",map.get(1));
                jsonObject3.put("org",map.get(8));
                nameList.add(jsonObject3);
                orgList.add(map.get(8));
            }
            orgList = orgList.stream().distinct().collect(Collectors.toList());
            List<JSONObject> orgObjList = new ArrayList<>();
            for(Object obj : orgList){
                JSONArray jsonArray = sqlServer.query("select id,name from t_organization where id = '" + obj + "'");
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("oid",((JSONObject)jsonArray.get(0)).getString("id"));
                jsonObject.put("name",((JSONObject)jsonArray.get(0)).getString("name"));
                orgObjList.add(jsonObject);
            }
            typeList = toRepeat(typeList);
            nameList = toRepeat(nameList);
            getResult(orgObjList, "公司",null,1);
            getResult(typeList, "分类","org",2);
            getResult(nameList, "品名","parentname",3);
            getResult(styleList, "型号","parentname",4);
            result.put("code","200");
            result.put("msg","导入成功！！！");
            return result;
        } catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            throw new Exception(exception);
        }
    }

    public void getResult(List<JSONObject> datalist,
                          String str,
                          String parentKey,
                          Integer flag) throws Exception{
        try{
            JSONArray jsonArray = sqlServer.query("select \n" +
                    "\tt1.name t1name,\n" +
                    "\tt1.id t1id,\n" +
                    "\to.id oid,\n" +
                    "\tt1.type t1type,\n" +
                    "\tt2.id t2id,\n" +
                    "\tt2.name t2name,\n" +
                    "\tt2.parent_id t2parent_id,\n" +
                    "\tt3.id t3id,\n" +
                    "\tt3.name t3name,\n" +
                    "\tt3.parent_id t3parent_id,\n" +
                    "\tt4.id t4id,\n" +
                    "\tt4.name t4name,\n" +
                    "\tt4.parent_id t4parent_id,\n" +
                    "\tt4.price t4price,\n" +
                    "\tt4.unit t4unit\n" +
                    "from \n" +
                    "\t(select id,name,type from t_material_info where type = '公司') t1 \n" +
                    "\tleft join t_organization o on t1.name = o.name\n" +
                    "\tleft join t_material_info t2 on t2.parent_id = t1.id\n" +
                    "\tleft join t_material_info t3 on t3.parent_id = t2.id\n" +
                    "\tleft join t_material_info t4 on t4.parent_id = t3.id");
            for (int i = 0;i < jsonArray.length();i++) {
                JSONObject material = jsonArray.getJSONObject(i);
                for (JSONObject obj : datalist) {
                    if(flag == 1){
                        if (material.get("oid").equals(obj.get("oid"))) {
                            datalist.remove(obj);
                            break;
                        }
                    } else if (flag == 2) {
                        if (obj.get(parentKey).equals(material.get("oid"))) {
                            if (material.get("t2name").equals(obj.get("name"))) {
                                datalist.remove(obj);
                                break;
                            }
                        }
                    } else if (flag == 3) {
                        if (obj.get("org").equals(material.get("oid"))) {
                            if (obj.get(parentKey).equals(material.get("t2name"))) {
                                if (material.get("t3name").equals(obj.get("name"))) {
                                    datalist.remove(obj);
                                    break;
                                }
                            }
                        }
                    } else if (flag == 4) {
                        if(obj.get("org").equals(material.get("oid"))) {
                            if (obj.get("type").equals(material.get("t2name"))) {
                                if (obj.get(parentKey).equals(material.get("t3name"))) {
                                    if (material.get("t4name").equals(obj.get("name"))
                                    && material.get("t4price").equals(obj.get("price"))
                                    && material.get("t4unit").equals(obj.get("unit"))) {
                                        datalist.remove(obj);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            if (datalist.size() > 0) {
                for (JSONObject obj : datalist) {
                    if (flag == 1) {
                        obj.remove("oid");
                        obj.put("type", str);
                        sqlServer.entityServer.partialSave("t_material_info", obj);
                    } else if (flag == 2) {
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            if (obj.get(parentKey).equals(jsonObject.get("oid"))) {
                                obj.put("parent_id", jsonObject.getInt("t1id"));
                                obj.put("type", str);
                                sqlServer.entityServer.partialSave("t_material_info", obj);
                                break;
                            }
                        }
                    } else if (flag == 3) {
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            if(obj.get("org").equals(jsonObject.get("oid"))){
                                if (obj.get(parentKey).equals(jsonObject.get("t2name"))) {
                                    obj.put("parent_id", jsonObject.getInt("t2id"));
                                    obj.put("type", str);
                                    sqlServer.entityServer.partialSave("t_material_info", obj);
                                    break;
                                }
                            }
                        }
                    } else if (flag == 4) {
                        for (int i = 0; i < jsonArray.length(); i++) {
                            JSONObject jsonObject = jsonArray.getJSONObject(i);
                            if(obj.get("org").equals(jsonObject.get("oid"))){
                                if(obj.get("type").equals(jsonObject.get("t2name"))){
                                    if (obj.get(parentKey).equals(jsonObject.get("t3name"))) {
                                        obj.put("parent_id", jsonObject.getInt("t3id"));
                                        obj.put("type", str);
                                        sqlServer.entityServer.partialSave("t_material_info", obj);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }catch (Exception exception) {
            logger.debug(exception.getMessage(), exception);
            throw new Exception(exception);
        }
    }
    public List<JSONObject> toRepeat(List<JSONObject> objectList){
        List<JSONObject> result = new ArrayList<>();
        for (int i = 0;i < objectList.size();i++){
            for (int j = 0;j < i;j++){
                if(objectList.get(i).has("parentname")){
                    if(objectList.get(i).getString("name").equals(objectList.get(j).getString("name"))
                            && objectList.get(i).getString("org").equals(objectList.get(j).getString("org"))
                            && objectList.get(i).getString("parentname").equals(objectList.get(j).getString("parentname"))){
                        result.remove(objectList.get(j));
                    }
                }else {
                    if(objectList.get(i).getString("name").equals(objectList.get(j).getString("name"))
                            && objectList.get(i).getString("org").equals(objectList.get(j).getString("org"))){
                        result.remove(objectList.get(j));
                    }
                }
            }
            result.add(objectList.get(i));
        }
        return result;
    }
}
