package com.aote.plugin;



import javax.imageio.ImageIO;
import javax.swing.*;
import java.awt.*;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.util.UUID;

/**
 * com.aote.plugin
 *
 * @author Administrator
 * @creater 2021-09-13 14:56
 */
public class NewImage {
    /**
     * 生成图片
     * &#64;param cellsValue 以二维数组形式存放 表格里面的值
     * &#64;param path 文件保存路径
     */
    public void myGraphicsGeneration(String cellsValue[][], String path, String filepath,String user) {
        // 字体大小
        int fontTitileSize = 15;
        // 横线的行数
        int totalrow = cellsValue.length + 1;
        // 竖线的行数
        int totalcol = 0;
        if (cellsValue[0] != null) {
            totalcol = cellsValue[0].length;
        }
        // 图片宽度
        int imageWidth = 1024;
        // 行高
        int rowheight = 40;
        // 图片高度
        int imageHeight = totalrow * rowheight + 70;
        // 起始高度
        int startHeight = 10;
        // 起始宽度
        int startWidth = 10;
        // 单元格宽度
        int colwidth = (int) ((imageWidth - 20) / totalcol);
        BufferedImage image = new BufferedImage(imageWidth, imageHeight, BufferedImage.TYPE_INT_RGB);
        Graphics graphics = image.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, imageWidth, imageHeight);
        graphics.setColor(new Color(220, 240, 240));

        //画横线
        for (int j = 0; j < totalrow; j++) {
            graphics.setColor(Color.black);
            if (j == 4) {
                graphics.drawLine(startWidth, startHeight + (j + 1) * rowheight + 40, startWidth + colwidth * (totalcol - 2), startHeight + (j + 1) * rowheight + 40);

            } else if (j == 5) {
                graphics.drawLine(startWidth, startHeight + (j + 1) * rowheight + 40, startWidth, startHeight + (j + 1) * rowheight + 40);

            } else {
                graphics.drawLine(startWidth, startHeight + (j + 1) * rowheight + 40, startWidth + colwidth * totalcol, startHeight + (j + 1) * rowheight + 40);

            }

        }
        //画竖线
        graphics.setColor(Color.black);
        graphics.drawLine(startWidth, startHeight + rowheight + 40, startWidth, startHeight + rowheight * totalrow + 40);
        graphics.drawLine(startWidth + 1 * colwidth, startHeight + rowheight + 40, startWidth + 1 * colwidth, startHeight + rowheight * (totalrow - 2) + 40);
        graphics.drawLine(startWidth + 2 * colwidth, startHeight + rowheight + 40, startWidth + 2 * colwidth, startHeight + rowheight * (totalrow - 4) + 40);
        graphics.drawLine(startWidth + 2 * colwidth, startHeight + rowheight * (totalrow - 3) + 40, startWidth + 2 * colwidth, startHeight + rowheight * (totalrow - 2) + 40);
        graphics.drawLine(startWidth + 3 * colwidth, startHeight + rowheight + 40, startWidth + 3 * colwidth, startHeight + rowheight * (totalrow - 4) + 40);
        graphics.drawLine(startWidth + 3 * colwidth, startHeight + rowheight * (totalrow - 3) + 40, startWidth + 3 * colwidth, startHeight + rowheight * totalrow + 40);
        graphics.drawLine(startWidth + 5 * colwidth, startHeight + rowheight + 40, startWidth + 5 * colwidth, startHeight + rowheight * totalrow + 40);
        graphics.drawLine(startWidth + 4 * colwidth, startHeight + rowheight + 40, startWidth + 4 * colwidth, startHeight + rowheight * (totalrow - 4) + 40);

        //            graphics.drawLine(startWidth+k*colwidth, startHeight+rowheight+40, startWidth+k*colwidth, startHeight+rowheight*totalrow+40);

        //设置字体
        Font font = new Font("微软雅黑", Font.BOLD, 30);
        graphics.setFont(font);
        //写标题
        String title = "巩义市商服用户燃气用量记录表";
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int titleWidth = fontMetrics.stringWidth(title);
        graphics.drawString(title, (imageWidth - titleWidth) / 2, startHeight + rowheight - 10);
        font = new Font("微软雅黑", Font.PLAIN, 17);
        graphics.setFont(font);
        graphics.drawString(user, startWidth, startHeight + rowheight + 20);
       FileInputStream in = null;
        byte[] bytes = null;
        try {
            in = new FileInputStream(filepath);
            bytes = new byte[in.available()];
            in.read(bytes);
            in.close();
        } catch (Exception e) {
            e.printStackTrace();
        }


        ImageIcon imageIcon = new ImageIcon(bytes);
        graphics.drawImage(imageIcon.getImage(), startWidth + 3 * colwidth+2, startHeight + rowheight * (totalrow - 3) + 42, 397, 117, imageIcon.getImageObserver());
        //写入内容
        for (int n = 0; n < cellsValue.length; n++) {
            for (int l = 0; l < cellsValue[n].length; l++) {
                if (n == 0) {
                    font = new Font("微软雅黑", Font.PLAIN, 20);
                    graphics.setFont(font);
                    graphics.setColor(Color.BLACK);
                } else if (n > 1 && n < 4 && l == 0) {
                    font = new Font("微软雅黑", Font.PLAIN, 20);
                    graphics.setFont(font);
                    graphics.setColor(Color.BLACK);
                } else if (n > 0 && l > 0) {
                    font = new Font("微软雅黑", Font.PLAIN, fontTitileSize);
                    graphics.setFont(font);
                    graphics.setColor(Color.BLACK);
                } else {
                    font = new Font("微软雅黑", Font.PLAIN, fontTitileSize);
                    graphics.setFont(font);
                    graphics.setColor(Color.BLACK);
                }
                graphics.drawString(cellsValue[n][l].toString(), startWidth + colwidth * l + 20, startHeight + rowheight * (n + 2) + 25);
            }
        }
        // 保存图片
        createImage(image, path);
    }

    /**
     * 将图片保存到指定位置
     * &#64;param image 缓冲文件类
     * &#64;param fileLocation 文件位置
     */
    public void createImage(BufferedImage image, String fileLocation) {
        try {
            String formatName = fileLocation.substring(fileLocation.lastIndexOf(".") + 1);
            ImageIO.write(image, formatName, new File(fileLocation));
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

//    public static void main(String[] args) {
//        NewImage cg = new NewImage();
//        String table[][] = {
//                {"上次气表底数", "本次气表底数", "本月用气量", "单价（元/立方）", "应交金额"},
//                {"30", "35", "5", "3.5", "17.5"},
//                {"气费金额（大写）", "金额大写哈哈哈哈哈哈哈哈哈哈哈"},
//                {"抄表人", "张鹏程", "用户签名"},
//                {"请于本月28日前到营业厅缴费,逾期未缴费的，将采取停气措施，本月底前仍未交费"},
//                {"的，每天将按欠费金额的千分之五收取滞纳金"}
//        };
//        String uuid = UUID.randomUUID().toString();
//        String filepath = "d:\\aaaa.jpg";
//        cg.myGraphicsGeneration(table, "d:\\" + uuid + ".jpg", filepath,"用户姓名");
//    }
}
