package com.aote.plugin;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelReader;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

@Component
public class FuGuReadExcel {
    private static final Logger logger = Logger.getLogger(ReadExcel.class);
    @Autowired
    private FuGuOperateBlackListExcel fuGuOperateBlackListExcel;

    public JSONObject readExcelData(String data) throws Exception {
        JSONObject dataObj = new JSONObject(data);
        ExcelReader excelReader = null;
        InputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(dataObj.getString("filepath"));
            ModelDataListener modelDataListener = new ModelDataListener();
            EasyExcel.read(fileInputStream, modelDataListener).sheet().doRead();
            List<Map<Integer, String>> headList = modelDataListener.getHeadList();
            List<Map<Integer, Object>> dataList = modelDataListener.getDataList();
            return fuGuOperateBlackListExcel.saveData(headList, dataList, dataObj);
        } catch (Exception exception) {
            logger.error(exception.getMessage(), exception);
            JSONObject result = new JSONObject();
            result.put("code","500");
            result.put("msg","导入失败！！！");
            return result;
        } finally {
            fileInputStream.close();
            if (excelReader != null) {
                excelReader.finish();
            }
        }
    }
}
