package com.aote.plugin;

import com.af.plugins.JsonTools;
import com.aote.entity.EntityServer;
import com.aote.rs.EntityService;
import com.aote.rs.LogicService;
import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
/*
 * 府谷黑名单用户导入
 * */
@Component
@Transactional
public class FuGuOperateBlackListExcel {

    @Autowired
    private SqlServer sqlServer;
    @Autowired
    private EntityServer entityServer;

    private JsonTools jsonTools = new JsonTools();

    private Logger log = Logger.getLogger(FuGuOperateBlackListExcel.class);
    //存库操作
    public JSONObject saveData(List<Map<Integer, String>> headList, List<Map<Integer, Object>> dataList,JSONObject dataObj) throws Exception{
        JSONObject result = new JSONObject();
        try{
            List<JSONObject> dataObjList = new ArrayList<>();
            for (Map<Integer,Object> map : dataList) {
                JSONObject saveDataObj = new JSONObject();
                saveDataObj.put("f_userinfo_code",map.get(0));
                saveDataObj.put("f_user_name",map.get(1));
                saveDataObj.put("f_limit_times",map.get(2));
                saveDataObj.put("f_limit_value",map.get(3));
                saveDataObj.put("f_limit_amount",map.get(4));
                saveDataObj.put("f_operat_type",dataObj.getString("f_operat_type"));
                saveDataObj.put("f_state",dataObj.getString("f_state"));
                saveDataObj.put("f_operator",dataObj.getString("f_operator"));
                saveDataObj.put("f_operatorid",dataObj.getString("f_operatorid"));
                saveDataObj.put("f_orgid",dataObj.getString("f_orgid"));
                saveDataObj.put("f_orgname",dataObj.getString("f_orgname"));
                saveDataObj.put("f_depid",dataObj.getString("f_depid"));
                saveDataObj.put("f_depname",dataObj.getString("f_depname"));
                saveDataObj.put("f_operate_date",dataObj.getString("f_operate_date"));
                saveDataObj.put("f_describe",dataObj.getString("f_operator") + "对客户" + map.get(2) + "进行拉黑");
                saveDataObj.put("f_comments",map.get(5));
                JSONArray userinfoId = sqlServer.query("select f_userinfo_id from t_userinfo where f_userinfo_code='" + map.get(0) + "'");
                saveDataObj.put("f_userinfo_id",((JSONObject)userinfoId.get(0)).get("f_userinfo_id"));
                dataObjList.add(saveDataObj);
            }
            log.debug(dataObjList);
            for(int i = 0;i < dataObjList.size();i++){
                for(int j = 0;j < dataObjList.size();j++){
                    if(i!=j && dataObjList.get(i).get("f_userinfo_id").equals(dataObjList.get(j).get("f_userinfo_id"))
                    && dataObjList.get(i).getString("f_userinfo_code").equals(dataObjList.get(j).getString("f_userinfo_code"))) {
                        result.put("code",500);
                        result.put("msg","当前excel文件中有重复用户信息，请检查文件后再进行导入！");
                        return result;
                    }
                }
            }
            JSONArray userinfoIdRes = sqlServer.query("select f_userinfo_id from t_userproperties where f_state != '无效' ");
            for (JSONObject obj : dataObjList) {
                for(int i = 0; i < userinfoIdRes.length();i++){
                    JSONObject user = userinfoIdRes.getJSONObject(i);
                    if(obj.get("f_userinfo_id").equals(user.get("f_userinfo_id"))){
                        result.put("code",500);
                        result.put("msg","当前excel文件中有用户已被拉黑，请检查文件后再进行导入！");
                        return result;
                    }
                }
            }

            for (JSONObject obj : dataObjList) {
                JSONObject data = new JSONObject();
                data.put("condition","f_userinfo_code = '" +obj.getString("f_userinfo_code") + "'" );
                data.put("f_orgid",dataObj.getString("f_orgid"));
                JSONArray jsonArray = sqlServer.query("sale_getUserAndVersion", data);
                obj.put("version",((JSONObject)jsonArray.get(0)).get("version"));
                Integer record_id = jsonTools.convertToJson(entityServer.partialSave("t_record", obj)).getInt("id");
                obj.put("record_id",record_id);
            }
            for (JSONObject obj : dataObjList) {
                JSONObject userProperties = new JSONObject();
                userProperties.put("f_parameter_key","blackList");
                userProperties.put("f_parameter_value",dataObj.getString("f_operate_date"));
                userProperties.put("f_state","有效");
                userProperties.put("f_userinfo_id",obj.get("f_userinfo_id"));
                userProperties.put("f_record_id",obj.getInt("record_id"));
                userProperties.put("f_comments",obj.getString("f_comments"));
                entityServer.partialSave("t_userproperties", userProperties);
                JSONArray prices = sqlServer.query("select f_price_id from t_userfiles where f_userinfo_id='" + obj.get("f_userinfo_id") + "'");
                JSONObject gasEntity = new JSONObject();
                gasEntity.put("f_third_pay",1);
                gasEntity.put("f_time_type","黑名单");
                gasEntity.put("f_time_value","9999");
                gasEntity.put("f_limit_times",obj.getString("f_limit_times"));
                gasEntity.put("f_limit_type","气量");
                gasEntity.put("f_limit_value",obj.getString("f_limit_value"));
                gasEntity.put("f_start_date",dataObj.getString("f_operate_date"));
                gasEntity.put("f_limit_amount",obj.getString("f_limit_amount"));
                gasEntity.put("f_price_id",((JSONObject)prices.get(0)).get("f_price_id"));
                gasEntity.put("f_userinfo_id",obj.get("f_userinfo_id"));
                entityServer.partialSave("t_limit_gas",gasEntity);
            }
            result.put("code",200);
            result.put("msg","导入成功！！！");
            return result;
        } catch (Exception exception){
            log.error(exception.getMessage(), exception);
            throw new Exception(exception);
        }

    }
}
