package com.aote;

import com.aote.sql.SqlServer;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.List;

@Component
public class TableBookImport {

    private static final Logger LOGGER = Logger.getLogger(TableBookImport.class);

    @Autowired
    private SqlServer sqlServer;


    public void run(String tableName, JSONArray array) {
        List<Object> dataList = array.toList();

        // 每次取的数据大小
        int pageSize = 1000;
        int totalSize = dataList.size();
        int temp = totalSize / pageSize + 1;
        boolean special = totalSize % pageSize == 0;

        List<Object> cutList;
        for (int i = 0; i < temp; i++) {
            if (i == temp - 1) {
                if (special) {
                    break;
                }
                cutList = dataList.subList(pageSize * i, totalSize);
            } else {
                cutList = dataList.subList(pageSize * i, pageSize * (i + 1));
            }
            LOGGER.info("存储进度：第(" + (i + 1) + ")组，共" + cutList.size() + "条");
            StringBuilder sql = new StringBuilder("INSERT INTO " + tableName + "(");
            StringBuilder sqlValue = new StringBuilder(" VALUES ");
            HashMap<String, Object> first = (HashMap<String, Object>) cutList.get(0);
            for (String key : first.keySet()) {
                sql.append(key).append(",");
            }
            cutList.forEach(item -> {
                sqlValue.append("(");
                HashMap<String, Object> itemObj = (HashMap<String, Object>) item;
                for (String key : first.keySet()) {
                    if (itemObj.containsKey(key)) {
                        sqlValue.append(itemObj.get(key)).append(",");
                    } else {
                        sqlValue.append("null,");
                    }
                }
                sqlValue.deleteCharAt(sqlValue.length() - 1).append("),");
            });
            sql.deleteCharAt(sql.length() - 1).append(")");
            sqlValue.deleteCharAt(sqlValue.length() - 1);
            sql.append(sqlValue);
            System.out.println("----->" + sql);
            sqlServer.run(String.valueOf(sql));
        }
    }
}
