package com.af.timingJob;

import com.aote.rs.BatchBusinessBase;
import com.aote.rs.LogicService;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Lazy(false)
public class MeterDownNew {

    static Logger log = Logger.getLogger(LogicService.class);

    @Autowired
    private LogicService logicService;
    @Autowired
    private BatchBusinessBase batchBusinessBase;

    @Scheduled(cron = "0 5 0 * * ? ")
    public void doJob(){
        log.debug("进入了定时器执行定时任务");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("获取到的执行配置为---》"+conf.get("MeterDownNew"));
        if ((boolean)conf.get("MeterDownNew")){
            try {
                System.out.println("定时任务正在执行");
                try {
                    log.debug("MeterDown定时执行自动计划下发任务");
                    String meterDownParam = logicService.xtSave("getBatchMainNew", "{data:{}}");
                    if (meterDownParam != null ){
                        JSONObject jsonObject = new JSONObject(meterDownParam);
                        int code = jsonObject.getInt("code");
                        if (code <2000){
                            batchBusinessBase.meterDownBatchAudit("batchMainNew",jsonObject);
                        }
                    }else {
                        System.out.println("没有待下发的计划");
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }catch (Exception e){
                log.error(e);
            }
        } else {
            System.err.println("未配置启动自动下发");
        }
    }

}
