package com.af.timingJob;

import com.aote.rs.LogicService;
import file.ReadFile;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

@Component
@EnableScheduling
@Lazy(false)
public class LateFeeCorn {

    static Logger log = Logger.getLogger(LogicService.class);

    @Autowired
    private LogicService logicService;

    @Scheduled(cron = "0 29 23 28-31 * ?") //每月最后一天的  23 ： 59
    public void doJob(){
        log.debug("进入了定时器执行定时任务");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("获取到的执行配置为---》"+conf.get("LateFee"));
        if ((boolean) conf.get("LateFee")){
            try {
                log.debug("开始执行批量抄表");
                logicService.xtSave("lateFee", new JSONObject().put("data", new JSONObject().toString()).toString());
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.err.println("未配置启动自动下发");
        }
    }

}

