package com.af.timingJob;

import com.aote.rs.BatchBusinessBase;
import com.aote.rs.LogicService;
import org.apache.log4j.Logger;
import org.json.JSONObject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import util.timer.ReadFile;

@Component
@EnableScheduling
@Lazy(false)
public class BatchJobTimer {
    static Logger log = Logger.getLogger(LogicService.class);

    @Autowired
    private LogicService logicService;
    @Autowired
    private BatchBusinessBase batchBusinessBase;

    @Scheduled(cron = "0 0/20  0,1,2,3,4,5 * * ? ")
    public void doJob(){
        log.debug("JobTimer进入了执行未执行批量任务定时任务");
        ReadFile file =new ReadFile();
        JSONObject conf = file.Read(file.GetResourceURL("/applicationConfig/timerConfig.json"));
        log.debug("JobTimer获取到的执行配置为---》"+conf.get("BatchJobTimer"));
        if ((boolean)conf.get("BatchJobTimer")){
            try {
                Thread.sleep(10000);
                System.out.println("定时任务正在执行");
                try {
                log.debug("BatchJobTimer定时执行批量任务");
                String executeParam = logicService.xtSave("getExecuteParam", "{data:{}}");
                if (executeParam != null ){
                    JSONObject jsonObject = new JSONObject(executeParam);
                    System.out.println("executeParam"+jsonObject);
                    int code = jsonObject.getInt("code");
                    if (code <2000){
                        int jobId = jsonObject.getInt("jobId");
                        Object o = batchBusinessBase.leisureExecute(jsonObject);
                        if (o != "0"){
                            String updateResult = logicService.xtSave("getExecuteParam", "{data:{"+"jobId:"+jobId+"}}");
                            log.debug("执行完毕"+updateResult);
                        }
                    }
                }else {
                    System.out.println("返回数据为空");
                }

            } catch (Exception e) {
                e.printStackTrace();
            }
            }catch (Exception e){
                log.error(e);
            }
        } else {
            System.err.println("未配置启动自动下发");
        }
    }
}
