/*
 * Decompiled with CFR 0.152.
 */
package pay;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONObject;
import org.xml.sax.InputSource;

public class CcbPayUtil {
    static Logger log = Logger.getLogger(CcbPayUtil.class);
    private static String[] hexDigits = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};

    public static String getOrderNum(String merchId) {
        String subfix = System.currentTimeMillis() + "";
        String orderNum = merchId.substring(6, merchId.length()) + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + subfix.substring(subfix.length() - 7);
        return orderNum;
    }

    public static String sign(JSONObject data, JSONObject config) {
        StringBuffer tmp = new StringBuffer();
        tmp.append("MERCHANTID=");
        tmp.append(data.get("MERCHANTID"));
        tmp.append("&POSID=");
        tmp.append(data.get("POSID"));
        tmp.append("&BRANCHID=");
        tmp.append(data.get("BRANCHID"));
        tmp.append("&ORDERID=");
        tmp.append(data.get("ORDERID"));
        tmp.append("&PAYMENT=");
        tmp.append(data.get("PAYMENT"));
        tmp.append("&CURCODE=");
        tmp.append(data.get("CURCODE"));
        tmp.append("&TXCODE=");
        tmp.append(data.get("TXCODE"));
        tmp.append("&REMARK1=");
        tmp.append(data.get("REMARK1"));
        tmp.append("&REMARK2=");
        tmp.append(data.get("REMARK2"));
        tmp.append("&RETURNTYPE=");
        tmp.append(data.get("RETURNTYPE"));
        tmp.append("&TIMEOUT=");
        tmp.append(data.get("TIMEOUT"));
        tmp.append("&PUB=");
        tmp.append(config.get("Pub"));
        log.debug((Object)tmp.toString());
        return CcbPayUtil.md5Str(tmp.toString(), 0);
    }

    public static String md5Str(String str, int offset) {
        try {
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            byte[] b = str.getBytes("UTF8");
            md5.update(b, offset, b.length);
            return CcbPayUtil.byteArrayToHexString(md5.digest());
        }
        catch (NoSuchAlgorithmException ex) {
            ex.printStackTrace();
            return null;
        }
        catch (UnsupportedEncodingException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String byteArrayToHexString(byte[] b) {
        String result = "";
        for (int i = 0; i < b.length; ++i) {
            result = result + CcbPayUtil.byteToHexString(b[i]);
        }
        return result;
    }

    public static String byteToHexString(byte b) {
        int n = b;
        if (n < 0) {
            n = 256 + n;
        }
        int d1 = n / 16;
        int d2 = n % 16;
        return hexDigits[d1] + hexDigits[d2];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpGet(String url, String code) {
        log.debug((Object)("GetPage:" + url));
        String content = null;
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (X11; U; Linux i686; zh-CN; rv:1.9.1.2) Gecko/20090803 Fedora/3.5.2-2.fc11 Firefox/3.5.2");
        GetMethod method = new GetMethod(url);
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            log.debug((Object)("httpClientUtils::statusCode=" + statusCode));
            log.debug((Object)method.getStatusLine());
            content = new String(method.getResponseBody(), code);
        }
        catch (Exception e) {
            log.debug((Object)"time out");
            e.printStackTrace();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
                method = null;
                httpClient = null;
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String httpPost(String url, JSONObject data, String code) {
        log.debug((Object)("GetPage:" + url));
        String content = null;
        HttpClient httpClient = new HttpClient();
        httpClient.getParams().setParameter("http.useragent", (Object)"Mozilla/5.0 (X11; U; Linux i686; zh-CN; rv:1.9.1.2) Gecko/20090803 Fedora/3.5.2-2.fc11 Firefox/3.5.2");
        PostMethod method = new PostMethod(url);
        Iterator it = data.keySet().iterator();
        while (it.hasNext()) {
            String[] s;
            String key = it.next() + "";
            Object o = data.get(key);
            if (o != null && o instanceof String) {
                method.addParameter(new NameValuePair(key, o.toString()));
            }
            if (o == null || !(o instanceof String[]) || (s = (String[])o) == null) continue;
            for (int i = 0; i < s.length; ++i) {
                method.addParameter(new NameValuePair(key, s[i]));
            }
        }
        try {
            int statusCode = httpClient.executeMethod((HttpMethod)method);
            log.debug((Object)("httpClientUtils::statusCode=" + statusCode));
            log.debug((Object)method.getStatusLine());
            content = new String(method.getResponseBody(), code);
        }
        catch (Exception e) {
            log.debug((Object)"time out");
            e.printStackTrace();
        }
        finally {
            if (method != null) {
                method.releaseConnection();
                method = null;
                httpClient = null;
            }
        }
        return content;
    }

    public static String httpPost(String url, JSONObject data) {
        return CcbPayUtil.httpPost(url, data, "UTF-8");
    }

    public static JSONObject toJson(byte[] xmlBytes, String charset) throws DocumentException {
        SAXReader reader = new SAXReader(false);
        InputSource source = new InputSource(new ByteArrayInputStream(xmlBytes));
        source.setEncoding(charset);
        Document doc = reader.read(source);
        JSONObject result = CcbPayUtil.toJson(doc.getRootElement());
        return result;
    }

    public static JSONObject toJson(Element element) {
        JSONObject result = new JSONObject();
        List els = element.elements();
        for (Element el : els) {
            if (el.elements().size() > 0) {
                result.put(el.getName().toUpperCase(), (Object)CcbPayUtil.toJson(el));
                continue;
            }
            result.put(el.getName().toUpperCase(), (Object)el.getTextTrim());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject xmlConnPost(String xml, String requesturl) {
        OutputStream out = null;
        BufferedReader bf = null;
        JSONObject json = new JSONObject();
        try {
            String encoding = "GB18030";
            String param = "requestXml=" + URLEncoder.encode(xml, encoding);
            URL url = new URL(requesturl);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setConnectTimeout(10000);
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.addRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            conn.addRequestProperty("Content-Length", String.valueOf(param.length()));
            conn.addRequestProperty("Connection", "close");
            out = conn.getOutputStream();
            out.write(param.getBytes(encoding));
            out.flush();
            out.close();
            boolean connRet = conn.getResponseCode() == 200;
            bf = connRet ? new BufferedReader(new InputStreamReader(conn.getInputStream(), encoding)) : new BufferedReader(new InputStreamReader(conn.getErrorStream(), encoding));
            String bfLine = null;
            StringBuffer sbf = new StringBuffer();
            while ((bfLine = bf.readLine()) != null) {
                sbf.append(bfLine);
            }
            log.debug((Object)("\u8fd4\u56de\u7684xml" + sbf.toString()));
            if (connRet) {
                json = CcbPayUtil.toJson(sbf.toString().getBytes(), encoding);
                json.put("code", 200);
            } else {
                json.put("code", 500);
                json.put("msg", (Object)sbf.toString());
            }
        }
        catch (Exception e) {
            json.put("code", 500);
            json.put("msg", (Object)e.getMessage());
        }
        finally {
            try {
                if (bf != null) {
                    bf.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.debug((Object)e.getMessage());
            }
        }
        return json;
    }

    public static String getSerialNum() {
        String ret = System.nanoTime() + "";
        if (ret.length() == 14) {
            int num = new Random().nextInt(99);
            ret = ret + String.format("%02d", num);
        }
        return ret;
    }

    public static String queryXml(JSONObject data) {
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>5W1002</TX_CODE>  \n<LANGUAGE>CN</LANGUAGE>\n<TX_INFO>\n<START></START>\n<STARTHOUR></STARTHOUR>\n<STARTMIN></STARTMIN>\n<END></END>\n<ENDHOUR></ENDHOUR>\n<ENDMIN></ENDMIN>\n <KIND>");
        tmpXml.append(data.get("KIND"));
        tmpXml.append("</KIND>\n<ORDER>");
        tmpXml.append(data.get("ORDER"));
        tmpXml.append("</ORDER>\n<ACCOUNT>");
        tmpXml.append("</ACCOUNT>\n<DEXCEL>");
        tmpXml.append(data.get("DEXCEL"));
        tmpXml.append("</DEXCEL>\n<MONEY>");
        tmpXml.append("</MONEY>\n<NORDERBY>");
        tmpXml.append(data.get("NORDERBY"));
        tmpXml.append("</NORDERBY>\n<PAGE>");
        tmpXml.append(data.get("PAGE"));
        tmpXml.append("</PAGE>\n<POS_CODE>");
        tmpXml.append("</POS_CODE>\n<STATUS>");
        tmpXml.append(data.get("STATUS"));
        tmpXml.append("</STATUS>\n<Mrch_No>");
        tmpXml.append("</Mrch_No>\n</TX_INFO>\n</TX>\n");
        return tmpXml.toString();
    }

    public static String refundXml(JSONObject data) {
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>5W1004</TX_CODE>  \n<LANGUAGE>CN</LANGUAGE>\n<TX_INFO>\n<MONEY>");
        tmpXml.append(data.get("MONEY"));
        tmpXml.append("</MONEY>\n<ORDER>");
        tmpXml.append(data.get("ORDER"));
        tmpXml.append("</ORDER>\n<REFUND_CODE>");
        tmpXml.append("</REFUND_CODE>\n</TX_INFO>\n<SIGN_INFO></SIGN_INFO>\n<SIGNCERT></SIGNCERT>\n</TX>\n");
        return tmpXml.toString();
    }

    public static String fileDownloadXml(JSONObject data) {
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>5W1005</TX_CODE>\n<LANGUAGE>CN</LANGUAGE>\n<TX_INFO>\n<DATE>");
        tmpXml.append(data.get("DATE"));
        tmpXml.append("</DATE>\n<KIND>");
        tmpXml.append(data.get("KIND"));
        tmpXml.append("</KIND>\n<FILETYPE>");
        tmpXml.append(data.get("FILETYPE"));
        tmpXml.append("</FILETYPE>\n<TYPE>0");
        tmpXml.append("</TYPE>\n<NORDERBY>");
        tmpXml.append("</NORDERBY>\n<POS_CODE>");
        tmpXml.append("</POS_CODE>\n<ORDER>");
        tmpXml.append("</ORDER>\n<STATUS>1");
        tmpXml.append("</STATUS>\n<BILL_FLAG>");
        tmpXml.append("</BILL_FLAG>\n<Mrch_No>");
        tmpXml.append("</Mrch_No>\n<GROUP_FLAG>");
        tmpXml.append("</GROUP_FLAG>\n</TX_INFO>\n</TX>\n");
        return tmpXml.toString();
    }

    public static String downloadXml(JSONObject data) {
        StringBuffer tmpXml = new StringBuffer();
        tmpXml.append("<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n");
        tmpXml.append("<TX>\n<REQUEST_SN>");
        tmpXml.append(data.get("REQUEST_SN"));
        tmpXml.append("</REQUEST_SN>\n<CUST_ID>");
        tmpXml.append(data.get("CUST_ID"));
        tmpXml.append("</CUST_ID>\n<USER_ID>");
        tmpXml.append(data.get("USER_ID"));
        tmpXml.append("</USER_ID>\n<PASSWORD>");
        tmpXml.append(data.get("PASSWORD"));
        tmpXml.append("</PASSWORD>\n<TX_CODE>6W0111</TX_CODE>\n<LANGUAGE>CN</LANGUAGE>\n<TX_INFO>\n<SOURCE>");
        tmpXml.append(data.get("SOURCE"));
        tmpXml.append("</SOURCE>\n<FILEPATH>merchant/shls");
        tmpXml.append("</FILEPATH>\n<LOCAL_REMOTE>");
        tmpXml.append(data.get("LOCAL_REMOTE"));
        tmpXml.append("</LOCAL_REMOTE>\n</TX_INFO>\n</TX>\n");
        return tmpXml.toString();
    }

    public void testXmlToJson() {
        String xml = "<?xml version=\"1.0\" encoding=\"GB2312\" standalone=\"yes\" ?>\n<TX>\n<REQUEST_SN>2019052117043034</REQUEST_SN>\n<CUST_ID>105871000004111</CUST_ID>\n<USER_ID>105871000004111-003</USER_ID>\n<PASSWORD>nx95533</PASSWORD>\n<TX_CODE>5W1002</TX_CODE>  \n<LANGUAGE>CN</LANGUAGE>\n<TX_INFO>\n<START></START>\n<STARTHOUR></STARTHOUR>\n<STARTMIN></STARTMIN>\n<END></END>\n<ENDHOUR></ENDHOUR>\n<ENDMIN></ENDMIN>\n <KIND>0</KIND>\n<ORDER>00000411120190521170353363</ORDER>\n<ACCOUNT></ACCOUNT>\n<DEXCEL>1</DEXCEL>\n<MONEY></MONEY>\n<NORDERBY>1</NORDERBY>\n<PAGE>1</PAGE>\n<POS_CODE></POS_CODE>\n<STATUS>3</STATUS>\n<Mrch_No></Mrch_No>\n</TX_INFO>\n</TX>";
        try {
            JSONObject json = CcbPayUtil.toJson(xml.getBytes(), "GB2312");
            System.out.println(json.toString());
        }
        catch (DocumentException e) {
            e.printStackTrace();
        }
    }
}

