package product;

import com.af.plugins.DateTools;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.net.HttpURLConnection;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class Test {

    public static void main(String[] args) throws Exception{
        String httpUrl = "http://api.tianapi.com/txapi/area/index?key=APIKEY&country=1";
        String jsonResult = request(httpUrl, "371300000000");
        System.out.println(jsonResult);

    }




    /**
     * @param
     *            :请求接口
     * @param httpArg
     *            :参数
     * @return 返回结果
     */
    public static String request(String httpUrl, String httpArg) {
        BufferedReader reader = null;
        String result = null;
        StringBuffer sbf = new StringBuffer();
        httpUrl = httpUrl + "?" + httpArg;

        try {
            URL url = new URL(httpUrl);
            HttpURLConnection connection = (HttpURLConnection) url
                    .openConnection();
            connection.setRequestMethod("GET");
            InputStream is = connection.getInputStream();
            reader = new BufferedReader(new InputStreamReader(is, "UTF-8"));
            String strRead = null;
            while ((strRead = reader.readLine()) != null) {
                sbf.append(strRead);
                sbf.append("\r\n");
            }
            reader.close();
            result = sbf.toString();
        } catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String getStairStartDate(String start, Object cycle, String handdate)
            throws Exception {
        // 参数验证
        if ("".equals(start) || start == null) {
            throw new Exception("您所传的阶梯开始时间不能为空!!");
        }
        if (cycle == null) {
            throw new Exception("您所传的阶梯周期不能为空!!");
        }
        if ("".equals(handdate) || handdate == null) {
            throw new Exception("您所传的抄表单下发时间不能为空!!");
        }

        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Calendar now = Calendar.getInstance();
        String[] str = start.split("-");
        // 开始月份
        int beginMonth = Integer.parseInt(str[0]);
        // 当前月份
        int nowMonth = getMonth(handdate);

        if (isLastYear(handdate)) {
            now.set(Calendar.YEAR, now.get(Calendar.YEAR) - 1);
        } else {
            now.set(Calendar.YEAR, now.get(Calendar.YEAR));
        }

        now.set(Calendar.DAY_OF_MONTH, Integer.parseInt(str[1]));


        // 计算月份
        int a = (nowMonth + (12 - beginMonth))%((int)cycle);
        System.out.println("取余操作" + a);
        int month = 0;
        if (isLowerDay(Integer.parseInt(str[1]))) {
            month = a == 0 ? a - (int)cycle : 0 - a;
        } else {
            month = 0 - a;
        }
        System.out.println("计算月份" + month);
        now.add(Calendar.MONTH, month);

        return format.format(now.getTime());
    }

    public static int getMonth(String date) throws ParseException {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date getdate = format.parse(date);
        Calendar cal = Calendar.getInstance();
        cal.setTime(getdate);
        return cal.get(Calendar.MONTH) + 1;
    }


    private static boolean isLastYear(String date) throws Exception {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        Date getdate = format.parse(date);

        Calendar cal = Calendar.getInstance();
        // 当前年份
        int currentYear = cal.get(Calendar.YEAR);
        // 获取传入日期的年份
        cal.setTime(getdate);
        int year = cal.get(Calendar.YEAR);
        return year < currentYear;
    }

    public static boolean isLowerDay(int d) {
        Calendar now = Calendar.getInstance();
        int day = now.get(Calendar.DATE);
        return day - d < 0;
    }



}
