package meter;
import com.af.plugins.RestTools;
import com.af.plugins.XwpfTUtil;
import com.aote.entity.EntityServer;
import com.aote.module.ModuleMapper;
import com.aote.plugins.impexp.FileManager;
import com.aote.rs.mapper.WebException;
import com.aote.util.ExcelUtil;
import file.ReadFile;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hwpf.HWPFDocument;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.json.JSONArray;
import org.json.JSONObject;
import org.junit.Test;
import org.springframework.util.ClassUtils;

import java.io.*;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * 批量sql的操作
 */
public class SettleTools {
    public final static String XLS = "xls";
    public final static String XLSX = "xlsx";
    static Logger log = Logger.getLogger(EntityServer.class);
    private static String[] parsePatterns = {"yyyy-MM-dd","yyyy年MM月dd日",
            "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd",
            "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd"};

    /**
     * 获取批量sql的values
     */
    public static String getAllsomeValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }
    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllsomFields(JSONArray json){
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    /**
     * 获取批量sql的values
     */
    public static String getAllValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();
                Object value = (Object)map.get(key);
                sbs.append("'");
                sbs.append(value);
                sbs.append("'");
                if(iterator.hasNext()){
                    sbs.append(",");
                }
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString();
    }

    /**
     * 获取特殊批量sql的fileds
     * @param json
     * @return
     */
    public static String getjsonAllFields(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");

            sbs.append("f_userinfo_code,");
            sbs.append("f_meternumber,");
            sbs.append("f_tablebase");
            sbs.append(")");
            break;
        }

        return sbs.toString().replace(",)",")");
    }
    /**
     * 获取特殊批量sql的values  {key:{}}
     */
    public static String getjsonAllValue(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql values获取");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            JSONObject maps = (JSONObject)json.get(i);
            JSONObject map = (JSONObject) maps.get("batchsttle");
            if(map.isNull("f_userinfo_code")){
                sbs.append("'0'");
            }else{
                String f_userinfo_code = (String) map.get("f_userinfo_code");
                sbs.append("'"+f_userinfo_code+"'");
            }
            sbs.append(",");
            if(map.isNull("f_meternumber")){
                sbs.append("'0'");
            }else{
                String f_meternumber = (String) map.get("f_meternumber");
                sbs.append("'"+f_meternumber+"'");
            }
            sbs.append(",");
            if(map.isNull("f_tablebase")){
                sbs.append(0);
            }else{
                sbs.append(map.get("f_tablebase"));
            }
            if(i == json.length()-1){
                sbs.append(")");
            }else{
                sbs.append("),");
            }
        }
        return sbs.toString().replace(",)",")");
    }

    /**
     * 获取批量sql的fileds
     * @param json
     * @return
     */
    public static String getAllFields(JSONArray json){
//        log.info("将要进行"+json.length()+"批量sql fields");
        StringBuffer sbs = new StringBuffer();
        for(int i=0;i<json.length();i++){
            sbs.append("(");
            String nowLineValue = "";
            JSONObject map = (JSONObject)json.get(i);
            Iterator<String> iterator = map.keySet().iterator();
            while(iterator.hasNext()){
                String key = iterator.next();

                sbs.append(key);
                if (iterator.hasNext()) {
                    sbs.append(",");
                }

            }
            sbs.append(")");
            break;
        }
        return sbs.toString();
    }

    public static List<String[]> getExcelData(String filepath){
        List<String[]> data = null;
        InputStream is = null;
        try{
            filepath = filepath.replaceAll("\\\\", "/");
            String jsonString = "{\"filepath\":\""+filepath+"\"}";
            HttpEntity httpEntity = RestTools.postHttpEntity("/rs/file/getUploadFile",new JSONObject(jsonString));
            is = httpEntity.getContent();
        }catch(Exception e){
            throw new WebException(500, filepath+"您所选的文件不存在!!!");
        }
        filepath = filepath.replace("\\", "/");
        String fileName = filepath.split("/")[filepath.split("/").length - 1];
        if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
            try {
                data = readExcel(is, fileName);
            } catch (IOException e) {
                throw new WebException(500, "文件解析错误!!!");
            }
        } else {
            throw new WebException(500, "非excel文件暂时未作处理.如有需求,请联系开发人员!!!!");
        }
        return data;
    }

    /**
     * 获取excel多少行
     */
    public static int getExcelLine(String filepath){
        List<String[]> data = getExcelData(filepath);
        if(data.size()>0){
            return data.size();
        }
        return 0;
    }

    /**
     * 获取excel字段数量
     * @param filepath
     * @return
     */
    public static int  getExcelParseJson(String filepath){
        List<String[]> data = getExcelData(filepath);
        if(data.size()>0){
            String[] strings = data.get(0);
            return strings.length;
        }
        return 0;
    }

    /**
     * 读入excel文件，解析后返回
     */
    public static List<String[]> readExcel(InputStream is, String fileName) throws IOException {
        // 检查文件
        checkFile(is);
        // 获得Workbook工作薄对象
        Workbook workbook = getWorkBook(is, fileName);
        // 创建返回对象，把每行中的值作为一个数组，所有行作为一个集合返回
        List<String[]> list = new ArrayList<>();
        if (workbook != null) {
            for (int sheetNum = 0; sheetNum < workbook.getNumberOfSheets(); sheetNum++) {
                // 获得当前sheet工作表
                Sheet sheet = workbook.getSheetAt(sheetNum);
                if (sheet == null) {
                    continue;
                }
                // 获得当前sheet的开始行
                int firstRowNum = sheet.getFirstRowNum();
                // 获得当前sheet的结束行
                int lastRowNum = sheet.getLastRowNum();
                if (sheetNum == 0) {
                    firstRowNum = firstRowNum - 1;
                }
                // 循环除了第一行的所有行
                // 列数以第一行为准
                int lastCellNum = 0;
                for (int rowNum = firstRowNum + 1; rowNum <= lastRowNum; rowNum++) {
                    // 获得当前行
                    Row row = sheet.getRow(rowNum);
                    if (row == null) {
                        continue;
                    }
                    // 获得当前行的开始列
                    int firstCellNum = row.getFirstCellNum();
                    // 获得当前行的列数
//                    int lastCellNum = row.getPhysicalNumberOfCells();
                    if (rowNum == 0) {
                        lastCellNum = row.getPhysicalNumberOfCells();
                    }
                    String[] cells = new String[lastCellNum];
                    // 循环当前行
                    for (int cellNum = firstCellNum; cellNum < lastCellNum; cellNum++) {
                        Cell cell = row.getCell(cellNum);
                        cells[cellNum] = getCellValue(cell);
                    }
                    if (validateCells(cells)) {
                        list.add(cells);
                    }
                }
            }
            workbook.close();
        }
        return list;
    }
    private static void checkFile(InputStream is) throws IOException {
        // 判断文件是否存在
        if (null == is) {
            log.error("文件不存在！");
            throw new FileNotFoundException("文件不存在！");
        }
    }
    private static Workbook getWorkBook(InputStream is, String fileName) {
        //创建Workbook工作薄对象，表示整个excel
        Workbook workbook = null;
        try {
            // 获取excel文件的io流
            //InputStream is = file.getInputStream();
            // 根据文件后缀名不同(xls和xlsx)获得不同的Workbook实现类对象
            if (fileName.endsWith(XLS)) {
                // 2003
                workbook = new HSSFWorkbook(is);
            } else if (fileName.endsWith(XLSX)) {
                // 2007
                workbook = new XSSFWorkbook(is);
            }
        } catch (IOException e) {
            log.info(e.getMessage());
        }
        return workbook;
    }
    public static boolean validateCells (String[] cells) {
        for (String str: cells) {
            if (str != null && !"".equals(str)) {
                return true;
            }
        }
        return false;
    }
    private static String getCellValue(Cell cell) {
        String cellValue = "";
        if (cell == null) {
            return cellValue;
        }
        // 把数字当成String来读，避免出现1读成1.0的情况
        if (cell.getCellType() == Cell.CELL_TYPE_NUMERIC) {
            cell.setCellType(Cell.CELL_TYPE_STRING);
        }
        // 判断数据的类型
        switch (cell.getCellType()) {
            case Cell.CELL_TYPE_NUMERIC: // 数字
                cellValue = String.valueOf(cell.getNumericCellValue());
                break;
            case Cell.CELL_TYPE_STRING: // 字符串
                cellValue = String.valueOf(cell.getStringCellValue());
                break;
            case Cell.CELL_TYPE_BOOLEAN: // Boolean
                cellValue = String.valueOf(cell.getBooleanCellValue());
                break;
            case Cell.CELL_TYPE_FORMULA: // 公式
                cellValue = String.valueOf(cell.getCellFormula());
                break;
            case Cell.CELL_TYPE_BLANK: // 空值
                cellValue = "";
                break;
            case Cell.CELL_TYPE_ERROR: // 故障
                cellValue = "非法字符";
                break;
            default:
                cellValue = "未知类型";
                break;
        }
        return cellValue;
    }

    public static double getValue(String value){
        if(value== null || "".equals(value)){
            return 0;
        }
        Double doubles = new Double(value);
        double ceil= Math.round(doubles);
        return new Double(ceil);
    }

    /**
     * 验证数据是否一致
     * @return
     */
    public static String checkData(String json,String json2){
        if(json == null || json2 == null){
            return "";
        }
        String newjson = json.substring(1,json.length()-1)+",''";
        String newjson2 = json2.substring(1,json2.length()-1)+",''";
        String[] split = newjson.split(",");
        String[] split1 = newjson2.split(",");
//        if(split.length == split1.length){
//            return "";
//        }
        List<String> list1 = Arrays.asList(split1); //将t1数组转成list数组
        List<String> list2 = new ArrayList<String>();//用来存放2个数组中不相同的元素
        for (String t : split) {
            if (!list1.contains(t)) {
                list2.add(t);
            }
        }
        if(list2.size() == 0){
            return "";
        }
        String[] strings = new String[list2.size()];
        String[] strarr = (String[])list2.toArray(strings);
        String join = StringUtils.join(strarr, ",");
        return join;
    }

    /**
     * 判断字符串或者数字是否相等
     * @param num1
     * @param num2
     * @return
     */
    public static boolean judgeValue(Object num1,Object num2){
        if(num1==null || num2==null){
            return false;
        }
        float judgenum1 = 0;
        float judgenum2 = 0;
        if(num1 instanceof Integer && num2 instanceof  Integer){
            if(num1 == num2 ) return true; else return false;
        }
        try{
            if(num1 instanceof Integer){
                judgenum1 = Float.parseFloat(Integer.toString((Integer) num1));
            }else{
                judgenum1 = Float.parseFloat((String)num1);
            }
        }catch(Exception e){
            return false;
        }
        try{
            judgenum2 = Float.parseFloat(num2.toString());
        }catch(Exception e){
            return false;
        }
        if(num1 instanceof String && num2 instanceof  String){
            if(num1.equals(num2)) return true; else return false;
        }
        if(judgenum1-judgenum2 ==0){
            return true;
        }
        return false;
    }

    /**
     * 获取json配置文件内容
     * @param filename  配置文件名 位置:applicationConfig下
     */
    public static JSONObject getjsonfromfile(String filename){
        JSONObject returnjson = new JSONObject();
        if(filename == null || "".equals(filename) ){
            returnjson.put("msg","当前银行未进行配置,请联系管理人员!");
            return returnjson;
        }
        ReadFile file =new ReadFile();
        try{
            String configFilePath = "";
            if(FileManager.class.getClassLoader().getResourceAsStream("/applicationConfig/" + filename)!=null){
                BufferedReader read = null;
                StringBuffer content = new StringBuffer();
                InputStream resourceAsStream = FileManager.class.getClassLoader().getResourceAsStream("/applicationConfig/" + filename);
                read = new BufferedReader(new InputStreamReader( resourceAsStream, StandardCharsets.UTF_8 ));
                String line;
                while ((line = read.readLine()) != null) {
                    content.append(line);
                }
                String val = content.toString();
                if("".equals(val) || !val.contains("{")){
                    return new JSONObject();
                }
                val=val.substring(val.indexOf("{"));
                returnjson = new JSONObject(val);
            }else{
                throw new Exception();
            }
        }catch(Exception e){
            returnjson.put("msg","当前银行未进行配置,请联系管理人员!");
        }
        return returnjson;
    }
    /**
     * 将数据生成到word中
     */
    public static String saveWord(String filename,JSONObject  data) throws IOException {
        if( filename.split("\\.")[1] == "docx"){
            return "";
        }

        String filepathString = ClassUtils.getDefaultClassLoader().getResource("/word//"+filename).getPath();
        String downString = filepathString.replace("word","excel");
        // String filepathString = resource.getPath();
        Iterator<String> it = data.keySet().iterator();
        HashMap<String, String> map = new HashMap<>();
        while(it.hasNext()){
            String key = it.next();
            Object obj = data.get(key);
            String value = "";
            if(obj instanceof Integer){
                value = Integer.toString((Integer) obj);
            }else if(data.get(key) instanceof String){
                value = (String)obj;
            }else{
                obj = "";
                value =(String)obj;
            }
            key = "#{"+key+"}";
            map.put(key,value);
        }

        //目的目录
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String savePath = XwpfTUtil.getPath("contractFilepath");
        File file = new File(savePath + File.separator + format.format(new Date()));
        //判断上传文件的保存目录是否存在
        if (!file.exists() && !file.isDirectory()) {
            file.mkdirs();
        }
        filename = filename.split("\\.")[0]+Long.toString(new Date().getTime())+".doc";
        String destpathString =file.getAbsolutePath() + File.separator + filename;
        System.out.println("当前保存的路径!!!!!!!===>"+destpathString);
        boolean bol = XwpfTUtil.replaceAndGenerateWord(filepathString,destpathString, map);

        if(bol){
            return destpathString;
        }
        return "";
    }
    public static String saveDownPath(String filename,String filepath){
        try {
            String filepathString = ClassUtils.getDefaultClassLoader().getResource("/word//"+filename).getPath();
            String downString = filepathString.substring(0, filepathString.lastIndexOf("WEB-INF"));
            downString = downString+"/word";
            File file = new File(downString);
            if(!file.exists()){
                file.mkdir();
            }
            downString = downString+"/"+filename;
            HWPFDocument document = new HWPFDocument(new FileInputStream(filepath));
            FileOutputStream outStream = null;
            outStream = new FileOutputStream(downString);
            document.write(outStream);
            outStream.close();
            return downString;
        } catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }
    public static String gethtml(String filename) throws Exception {
        String descfilename = filename.substring(0, filename.lastIndexOf("doc"))+"html";
        String descpath = XwpfTUtil.docxToHtml(filename, descfilename);
        //String result = XwpfTUtil.readfile(descpath);
        String[] split = descpath.split("\\\\");
        String encode = URLEncoder.encode(split[split.length-1]);
        descpath = descpath.replaceAll(split[split.length-1],encode);
        //String encode = URLDecoder.decode(descpath);
        File file = new File(descpath);
        FileInputStream fi = new FileInputStream(file);
        byte [] b = new byte[1024];
        int len = 0;
        StringBuilder sb = new StringBuilder();
        while(-1 != (len = fi.read(b))) {
            String s = new String(b,"utf8");
            sb.append(s);
        }
        return sb.toString();
    }
    public boolean iszeor(Object o1,Object o2){
        if(o1 instanceof BigDecimal){
            o1 = (BigDecimal)o1;
            o1 = ((BigDecimal) o1).doubleValue();
        }
        if(o2 instanceof Integer){
            o2 = (Integer)o2;
            o2 = ((Integer) o2).doubleValue();
        }
        if((Double)o1-(Double)o2 == 0){
            return true;
        }else{
            return false;
        }

    }

    /**
     * 将excel中的时间
     * @param exceltime  读取excel中的时间  44035.5083564815  或者 2020-07-23 12:12:02
     * @return   返回转换后的时间  2020-07-23 12:12:02
     */
    public String exceltimeget(String exceltime) {
        StringBuffer stringBuffer = new StringBuffer();
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Double time=0d;
        int excletimestart = 0;
        int timeend = 0;
        if(exceltime==null || "".equals(exceltime)){
            return "";
        }
        try {
            Date parse = simpleDateFormat.parse(exceltime);
            return exceltime;
        } catch (ParseException e) {
        }
        try {
            time = Double.parseDouble(exceltime);
        } catch (NumberFormatException e) {
            return "";
        }
        Calendar instance = Calendar.getInstance();
        instance.set(1900, 1, 1,0,0,0);
        //计算时间前半段
        excletimestart = (int) Math.floor(time)-33;
        instance.add(Calendar.DATE,excletimestart);
        simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        stringBuffer.append(simpleDateFormat.format(instance.getTime()));
        stringBuffer.append(" ");
        //计算时间后半段
        simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
        instance.set(1900, 1, 1,0,0,0);
        timeend = (int) ((time-Double.parseDouble(String.valueOf(excletimestart+32)))* 60 * 60 * 24);
        instance.add(Calendar.SECOND,timeend);
        stringBuffer.append(simpleDateFormat.format(instance.getTime()));
        return stringBuffer.toString();
    }
    /**
     * 公共sql模板
     * @return
     */
    public ArrayList<String> getfiles(){
        ArrayList<String> strings = new ArrayList<>();
        strings.add("f_userinfo_code");
        strings.add("f_operator_date");
        strings.add("f_operator_type");
        strings.add("f_error_type");
        strings.add("f_operator_info");
        strings.add("f_msg");
        return strings;
    }

    //将jsonarray转为sql
    public String jsontoSql(JSONArray arr){
        if(arr.length()==0) return "";
        StringBuffer header = new StringBuffer();
        StringBuffer body = new StringBuffer();
        StringBuffer sql = new StringBuffer();
        ArrayList<String> getfiles = getfiles();
        ArrayList<Object> defaultvalue = new ArrayList<>();
        boolean headerflag = false;
        for(int i =0;i<arr.length();i++){
            JSONObject pushdata = (JSONObject) arr.get(i);
            Iterator<String> iterator = getfiles.iterator();
            body.append("(");
            while(iterator.hasNext()){
                String next = iterator.next();
                if(!headerflag){
                    header.append(next);
                    if(iterator.hasNext()){
                        header.append(",");
                    }
                }
                String otherString = "";
                if(pushdata.has(next)){
                    Object o= pushdata.get(next);
                    if(o instanceof String){
                        otherString = (String) o;
                    }else if(o instanceof BigDecimal){
                        BigDecimal bd = (BigDecimal) o;
                        otherString = bd.toString();
                    }else if(o instanceof Integer){
                        otherString = Integer.toString((Integer) o);
                    }else if(o instanceof Double){
                        otherString = Double.toString((Double) o);
                    }else if(o instanceof Float){
                        otherString = Float.toString((Float) o);
                    }
                }
                body.append("'");
                if(defaultvalue.contains(next) && "".equals(otherString)){
                    otherString = "0";
                }
                if(otherString=="" || otherString==null){
                    body.append("");
                }else{
                    body.append(otherString);
                }
                body.append("'");
                if(iterator.hasNext()){
                    body.append(",");
                }
            }
            headerflag=true;
            body.append(")");
            if(i < arr.length()-1){
                body.append(",");
            }
        }
        return "("+header.toString()+")"+ " values"+body.toString();
    }

}
